/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.substitutions;

import io.bigconnect.dw.ner.common.places.substitutions.AbstractSubstitutionMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikipediaDemonymMap
extends AbstractSubstitutionMap {
    private static final Logger logger = LoggerFactory.getLogger(WikipediaDemonymMap.class);
    public static final String RESOURCE_NAME = "wikipedia-demonyms.tsv";

    public WikipediaDemonymMap() {
        this.ignoreCase = false;
        try {
            this.loadFromFile();
        }
        catch (IOException e) {
            logger.error("Unable to load demonym list! " + e);
        }
    }

    private void loadFromFile() throws IOException {
        logger.info("Loading demonyms from wikipedia-demonyms.tsv");
        this.map = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(RESOURCE_NAME)));
        br.readLine();
        br.readLine();
        String row = null;
        while ((row = br.readLine()) != null) {
            String[] columns = row.split("\t");
            String countryName = columns[0];
            String[] adjectivals = columns[1].split(", ");
            ArrayList<String> demonyms = new ArrayList<String>();
            for (int c = 2; c < columns.length; ++c) {
                demonyms.addAll(Arrays.asList(columns[c].split(", ")));
            }
            demonyms.addAll(Arrays.asList(adjectivals));
            for (String demonym : demonyms) {
                this.put(demonym.trim(), countryName.trim());
                logger.trace("added " + demonym + " to " + countryName);
            }
        }
    }

    public String replaceAll(String textToParse) {
        int demonymsFound = 0;
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(textToParse);
        int start = boundary.first();
        StringBuffer cleanedText = new StringBuffer();
        int end = boundary.next();
        while (end != -1) {
            String originalWord = textToParse.substring(start, end);
            String cleanedWord = this.substituteIfNeeded(originalWord);
            if (!cleanedWord.equals(originalWord)) {
                ++demonymsFound;
                logger.debug("    substituting demonym: " + originalWord + " -> " + cleanedWord);
            }
            cleanedText.append(cleanedWord);
            start = end;
            end = boundary.next();
        }
        logger.debug("  Replaced " + demonymsFound + " demonyms");
        return cleanedText.toString();
    }
}

