/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.substitutions;

import io.bigconnect.dw.ner.common.places.substitutions.AbstractSubstitutionMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSubstitutionMap
extends AbstractSubstitutionMap {
    private static final Logger logger = LoggerFactory.getLogger(CustomSubstitutionMap.class);

    public CustomSubstitutionMap(String fileName) {
        this(fileName, ",", ';', true, true);
    }

    public CustomSubstitutionMap(String fileName, boolean ignoreCase) {
        this(fileName, ",", ';', true, ignoreCase);
    }

    public CustomSubstitutionMap(String fileName, String separator, char comment, boolean skipFirstRow, boolean ignoreCase) {
        try {
            this.loadFromFile(fileName, separator, comment, skipFirstRow, ignoreCase);
        }
        catch (IOException e) {
            logger.error("Unable to load substitution list! " + e);
        }
    }

    protected void loadFromFile(String fileName, String separator, char comment, boolean skipFirstRow, boolean ignoreCase) throws IOException {
        logger.info("Loading custom substitutions from " + fileName + " ignoreCase=" + ignoreCase);
        this.map = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName)));
        if (skipFirstRow) {
            br.readLine();
        }
        String row = null;
        while ((row = br.readLine()) != null) {
            if (row.length() == 0 || row.charAt(0) == comment) continue;
            String[] columns = row.split(separator);
            String original = columns[0].trim();
            String replacement = columns[1].trim();
            if (ignoreCase) {
                original = columns[0].toLowerCase().trim();
                replacement = columns[1].toLowerCase().trim();
            }
            this.put(original, replacement);
        }
        logger.trace(this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => " + (String)entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

