/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.focus;

import com.bericotech.clavin.gazetteer.CountryCode;
import com.bericotech.clavin.gazetteer.GeoName;
import com.bericotech.clavin.resolver.ResolvedLocation;
import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.places.Adm1GeoNameLookup;
import io.bigconnect.dw.ner.common.places.CountryGeoNameLookup;
import io.bigconnect.dw.ner.common.places.focus.FocusLocation;
import io.bigconnect.dw.ner.common.places.focus.FocusStrategy;
import io.bigconnect.dw.ner.common.places.focus.FocusUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyOfMentionFocusStrategy
implements FocusStrategy {
    private static final Logger logger = LoggerFactory.getLogger(FrequencyOfMentionFocusStrategy.class);
    private Configuration configuration;

    public FrequencyOfMentionFocusStrategy(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<FocusLocation> selectCountries(List<ResolvedLocation> resolvedLocations) {
        ArrayList<FocusLocation> results = new ArrayList<FocusLocation>();
        HashMap<CountryCode, Integer> countryCounts = FocusUtils.getCountryCounts(resolvedLocations);
        if (countryCounts.size() == 0) {
            return results;
        }
        CountryCode primaryCountry = null;
        for (CountryCode countryCode : countryCounts.keySet()) {
            if (primaryCountry != null && countryCounts.get(countryCode) <= countryCounts.get(primaryCountry)) continue;
            primaryCountry = countryCode;
        }
        logger.info("Found primary country " + primaryCountry);
        if (primaryCountry != null) {
            results.add(new FocusLocation(CountryGeoNameLookup.lookup(primaryCountry.name(), this.configuration), countryCounts.get(primaryCountry)));
            for (CountryCode countryCode : countryCounts.keySet()) {
                if (countryCode == primaryCountry || countryCounts.get(countryCode) != countryCounts.get(primaryCountry)) continue;
                results.add(new FocusLocation(CountryGeoNameLookup.lookup(countryCode.name(), this.configuration), countryCounts.get(countryCode)));
            }
        }
        return results;
    }

    @Override
    public List<FocusLocation> selectStates(List<ResolvedLocation> resolvedLocations) {
        ArrayList<FocusLocation> results = new ArrayList<FocusLocation>();
        HashMap<String, Integer> stateCounts = FocusUtils.getStateCounts(resolvedLocations, this.configuration);
        if (stateCounts.size() == 0) {
            return results;
        }
        String primaryState = null;
        int highestCount = 0;
        for (String stateCode : stateCounts.keySet()) {
            int count = stateCounts.get(stateCode);
            if (primaryState != null && count <= highestCount) continue;
            highestCount = count;
            primaryState = stateCode;
        }
        logger.info("Found primary state " + primaryState.toString());
        if (primaryState != null) {
            int primaryStateCount = stateCounts.get(primaryState);
            results.add(new FocusLocation(Adm1GeoNameLookup.lookup(primaryState, this.configuration), primaryStateCount));
            for (String stateCode : stateCounts.keySet()) {
                int count = stateCounts.get(stateCode);
                if (stateCode == primaryState || count != primaryStateCount) continue;
                results.add(new FocusLocation(Adm1GeoNameLookup.lookup(stateCode, this.configuration), count));
            }
        }
        return results;
    }

    @Override
    public List<FocusLocation> selectCities(List<ResolvedLocation> resolvedLocations) {
        ArrayList<FocusLocation> results = new ArrayList<FocusLocation>();
        HashMap<GeoName, Integer> cityCounts = FocusUtils.getCityCounts(resolvedLocations);
        if (cityCounts.size() == 0) {
            return results;
        }
        Object primaryCity = null;
        int highestCount = 0;
        for (GeoName geoname : cityCounts.keySet()) {
            int count = cityCounts.get(geoname);
            if (primaryCity != null && count <= highestCount) continue;
            highestCount = count;
            primaryCity = geoname;
        }
        logger.info("Found primary city " + primaryCity.toString());
        if (primaryCity != null) {
            int primaryCityCount = cityCounts.get(primaryCity);
            results.add(new FocusLocation((GeoName)primaryCity, primaryCityCount));
            for (GeoName city : cityCounts.keySet()) {
                int count = cityCounts.get(city);
                if ((city == primaryCity || count != primaryCityCount) && (city == primaryCity || count <= 1)) continue;
                results.add(new FocusLocation(city, count));
            }
        }
        return results;
    }
}

