/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.disambiguation.GenericPass;
import java.util.ArrayList;
import java.util.List;

public class TopPreferringColocatedPass
extends GenericPass {
    @Override
    protected List<List<ResolvedLocation>> disambiguate(List<List<ResolvedLocation>> possibilitiesToDo, List<ResolvedLocation> bestCandidates) {
        ArrayList<List<ResolvedLocation>> possibilitiesToRemove = new ArrayList<List<ResolvedLocation>>();
        for (List<ResolvedLocation> candidates : possibilitiesToDo) {
            boolean foundOne = false;
            for (ResolvedLocation candidate : candidates) {
                if (foundOne || !this.inSameCountry(candidate, bestCandidates)) continue;
                bestCandidates.add(candidate);
                possibilitiesToRemove.add(candidates);
                foundOne = true;
            }
            if (!foundOne) {
                for (ResolvedLocation candidate : candidates) {
                    if (foundOne || !TopPreferringColocatedPass.isCity(candidate)) continue;
                    bestCandidates.add(candidate);
                    possibilitiesToRemove.add(candidates);
                    foundOne = true;
                }
            }
            if (foundOne) continue;
            ResolvedLocation candidate = candidates.get(0);
            TopPreferringColocatedPass.logResolvedLocationInfo(candidate);
            bestCandidates.add(candidate);
            possibilitiesToRemove.add(candidates);
        }
        return possibilitiesToRemove;
    }

    @Override
    public String getDescription() {
        return "Pick the top result, preferrring ones in the a country found already (last ditch effort)";
    }
}

