/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.disambiguation.GenericPass;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopAdminPopulatedPass
extends GenericPass {
    private static final Logger logger = LoggerFactory.getLogger(TopAdminPopulatedPass.class);

    @Override
    protected List<List<ResolvedLocation>> disambiguate(List<List<ResolvedLocation>> possibilitiesToDo, List<ResolvedLocation> bestCandidates) {
        ArrayList<List<ResolvedLocation>> possibilitiesToRemove = new ArrayList<List<ResolvedLocation>>();
        for (List<ResolvedLocation> candidates : possibilitiesToDo) {
            ResolvedLocation adminCandidate;
            ResolvedLocation cityCandidate;
            List<ResolvedLocation> exactMatches = TopAdminPopulatedPass.getExactMatches(candidates);
            if (exactMatches.size() > 0) {
                logger.debug("  " + exactMatches.size() + " exact matches for");
                cityCandidate = this.findFirstCityCandidate(exactMatches, true);
                adminCandidate = this.findFirstAdminCandidate(exactMatches, true);
                if (cityCandidate != null) {
                    logger.debug("    city " + cityCandidate.getGeoname().getGeonameID());
                }
                if (adminCandidate != null) {
                    logger.debug("    admin " + adminCandidate.getGeoname().getGeonameID());
                }
                if (this.chooseCityOverAdmin(cityCandidate, adminCandidate)) {
                    bestCandidates.add(cityCandidate);
                    possibilitiesToRemove.add(candidates);
                    continue;
                }
                if (adminCandidate == null) continue;
                bestCandidates.add(adminCandidate);
                possibilitiesToRemove.add(candidates);
                continue;
            }
            logger.debug("  no exact matches for");
            cityCandidate = this.findFirstCityCandidate(candidates, false);
            adminCandidate = this.findFirstAdminCandidate(candidates, false);
            if (cityCandidate != null) {
                logger.debug("    city " + cityCandidate.getGeoname().getGeonameID());
            }
            if (adminCandidate != null) {
                logger.debug("    admin " + adminCandidate.getGeoname().getGeonameID());
            }
            if (this.chooseCityOverAdmin(cityCandidate, adminCandidate)) {
                bestCandidates.add(cityCandidate);
                possibilitiesToRemove.add(candidates);
                continue;
            }
            if (adminCandidate == null) continue;
            bestCandidates.add(adminCandidate);
            possibilitiesToRemove.add(candidates);
        }
        return possibilitiesToRemove;
    }

    @Override
    public String getDescription() {
        return "Pick the top Admin Region or Populated Place remaining";
    }
}

