/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.disambiguation.GenericPass;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplePassChain {
    private static final Logger logger = LoggerFactory.getLogger(MultiplePassChain.class);
    private List<GenericPass> passes = new ArrayList<GenericPass>();
    private int callCount = 0;

    public void add(GenericPass pass) {
        this.passes.add(pass);
    }

    public List<ResolvedLocation> disambiguate(List<List<ResolvedLocation>> possibilities) {
        ++this.callCount;
        ArrayList<ResolvedLocation> bestCandidates = new ArrayList<ResolvedLocation>();
        int round = 0;
        for (GenericPass pass : this.passes) {
            logger.debug("Pass " + round + ": " + pass.getDescription());
            pass.execute(possibilities, bestCandidates);
            ++round;
        }
        return bestCandidates;
    }

    public void logPassTriggerStats() {
        int round = 0;
        logger.debug("Called " + this.callCount + " times:");
        for (GenericPass pass : this.passes) {
            logger.debug("  Pass " + round + ": " + pass.getDescription());
            logger.debug("    triggered " + pass.getTriggerCount() + " times");
            ++round;
        }
    }
}

