/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.CliffLocationResolver;
import io.bigconnect.dw.ner.common.places.disambiguation.ExactAdmin1MatchPass;
import io.bigconnect.dw.ner.common.places.disambiguation.ExactColocationsPass;
import io.bigconnect.dw.ner.common.places.disambiguation.FuzzyMatchedCountriesPass;
import io.bigconnect.dw.ner.common.places.disambiguation.GenericPass;
import io.bigconnect.dw.ner.common.places.disambiguation.LargeAreasPass;
import io.bigconnect.dw.ner.common.places.disambiguation.LocationDisambiguationStrategy;
import io.bigconnect.dw.ner.common.places.disambiguation.MultiplePassChain;
import io.bigconnect.dw.ner.common.places.disambiguation.TopAdminPopulatedPass;
import io.bigconnect.dw.ner.common.places.disambiguation.TopColocationsPass;
import io.bigconnect.dw.ner.common.places.disambiguation.TopPreferringColocatedPass;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeuristicDisambiguationStrategy
implements LocationDisambiguationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(HeuristicDisambiguationStrategy.class);
    private MultiplePassChain chain = new MultiplePassChain();

    public HeuristicDisambiguationStrategy() {
        this.chain.add(new LargeAreasPass());
        this.chain.add(new FuzzyMatchedCountriesPass());
        this.chain.add(new ExactAdmin1MatchPass());
        this.chain.add(new ExactColocationsPass());
        this.chain.add(new TopColocationsPass());
        this.chain.add(new TopAdminPopulatedPass());
        this.chain.add(new TopPreferringColocatedPass());
    }

    @Override
    public List<ResolvedLocation> select(CliffLocationResolver resolver, List<List<ResolvedLocation>> allPossibilities) {
        logger.debug("Starting with " + allPossibilities.size() + " lists to do:");
        for (List<ResolvedLocation> candidates : allPossibilities) {
            ResolvedLocation firstCandidate = candidates.get(0);
            logger.debug("  Location: " + firstCandidate.getLocation().getText() + "@" + firstCandidate.getLocation().getPosition());
            for (ResolvedLocation candidate : candidates) {
                GenericPass.logResolvedLocationInfo(candidate);
            }
        }
        List<ResolvedLocation> bestCandidates = this.chain.disambiguate(allPossibilities);
        return bestCandidates;
    }

    @Override
    public void logStats() {
        this.chain.logPassTriggerStats();
    }
}

