/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.gazetteer.FeatureClass;
import com.bericotech.clavin.gazetteer.GeoName;
import com.bericotech.clavin.resolver.ResolvedLocation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericPass {
    private static final Logger logger = LoggerFactory.getLogger(GenericPass.class);
    private int triggerCount = 0;

    public void execute(List<List<ResolvedLocation>> possibilitiesToDo, List<ResolvedLocation> bestCandidates) {
        if (possibilitiesToDo.size() == 0) {
            return;
        }
        List<List<ResolvedLocation>> possibilitiesToRemove = this.disambiguate(possibilitiesToDo, bestCandidates);
        for (ResolvedLocation resolvedLocation : bestCandidates) {
            GenericPass.logSelectedCandidate(resolvedLocation);
            GenericPass.logResolvedLocationInfo(resolvedLocation);
        }
        this.triggerCount += possibilitiesToRemove.size();
        for (List list : possibilitiesToRemove) {
            possibilitiesToDo.remove(list);
        }
        logger.debug("Still have " + possibilitiesToDo.size() + " lists to do");
    }

    public abstract String getDescription();

    protected abstract List<List<ResolvedLocation>> disambiguate(List<List<ResolvedLocation>> var1, List<ResolvedLocation> var2);

    static boolean isExactMatch(ResolvedLocation candidate) {
        return candidate.getGeoname().getName().equalsIgnoreCase(candidate.getLocation().getText());
    }

    static boolean isExactMatchToAdmin1(ResolvedLocation candidate) {
        return candidate.getGeoname().getAdmin1Code().equalsIgnoreCase(candidate.getLocation().getText());
    }

    protected static List<ResolvedLocation> getExactMatches(List<ResolvedLocation> candidates) {
        ArrayList<ResolvedLocation> exactMatches = new ArrayList<ResolvedLocation>();
        for (ResolvedLocation item : candidates) {
            if (!GenericPass.isExactMatch(item)) continue;
            exactMatches.add(item);
        }
        return exactMatches;
    }

    protected static List<ResolvedLocation> getExactMatchesOrAdmin1ExactMatches(List<ResolvedLocation> candidates) {
        ArrayList<ResolvedLocation> exactMatches = new ArrayList<ResolvedLocation>();
        for (ResolvedLocation item : candidates) {
            if (!GenericPass.isExactMatch(item) && !GenericPass.isExactMatchToAdmin1(item)) continue;
            exactMatches.add(item);
        }
        return exactMatches;
    }

    protected static boolean inSameSuperPlace(ResolvedLocation candidate, List<ResolvedLocation> list) {
        for (ResolvedLocation item : list) {
            if (!candidate.getGeoname().getAdmin1Code().equals(item.getGeoname().getAdmin1Code())) continue;
            return true;
        }
        return false;
    }

    protected static boolean isCity(ResolvedLocation candidate) {
        return candidate.getGeoname().getPopulation() > 0L && candidate.getGeoname().getFeatureClass() == FeatureClass.P;
    }

    protected static boolean isAdminRegion(ResolvedLocation candidate) {
        return candidate.getGeoname().getPopulation() > 0L && candidate.getGeoname().getFeatureClass() == FeatureClass.A;
    }

    protected static boolean isCountry(ResolvedLocation candidate) {
        return candidate.getGeoname().getPopulation() > 0L && candidate.getGeoname().getAdmin1Code().equals("00");
    }

    protected ResolvedLocation findFirstCityCandidate(List<ResolvedLocation> candidates, boolean exactMatchRequired) {
        for (ResolvedLocation candidate : candidates) {
            if (!GenericPass.isCity(candidate)) continue;
            if (exactMatchRequired && GenericPass.isExactMatch(candidate)) {
                return candidate;
            }
            if (exactMatchRequired) continue;
            return candidate;
        }
        return null;
    }

    protected ResolvedLocation findFirstAdminCandidate(List<ResolvedLocation> candidates, boolean exactMatchRequired) {
        for (ResolvedLocation candidate : candidates) {
            if (!GenericPass.isAdminRegion(candidate)) continue;
            if (exactMatchRequired && GenericPass.isExactMatch(candidate)) {
                return candidate;
            }
            if (exactMatchRequired) continue;
            return candidate;
        }
        return null;
    }

    protected boolean chooseCityOverAdmin(ResolvedLocation cityCandidate, ResolvedLocation adminCandidate) {
        if (cityCandidate == null) {
            return false;
        }
        if (adminCandidate == null) {
            return true;
        }
        return cityCandidate.getGeoname().getPopulation() > adminCandidate.getGeoname().getPopulation() || cityCandidate.getGeoname().getPrimaryCountryCode() == adminCandidate.getGeoname().getPrimaryCountryCode();
    }

    protected List<ResolvedLocation> inSameCountry(List<ResolvedLocation> candidates, List<ResolvedLocation> placesAlreadyPicked, boolean citiesOnly, boolean exactMatchesOnly, boolean populatedOnly) {
        ArrayList<ResolvedLocation> candidatesInSameCountry = new ArrayList<ResolvedLocation>();
        for (ResolvedLocation candidate : candidates) {
            if (!this.inSameCountry(candidate, placesAlreadyPicked) || citiesOnly && !GenericPass.isCity(candidate) || exactMatchesOnly && !GenericPass.isExactMatch(candidate) || populatedOnly && !GenericPass.isPopulated(candidate)) continue;
            candidatesInSameCountry.add(candidate);
        }
        return candidatesInSameCountry;
    }

    protected static boolean isPopulated(ResolvedLocation candidate) {
        return candidate.getGeoname().getPopulation() > 0L;
    }

    protected boolean inSameCountry(ResolvedLocation candidate, List<ResolvedLocation> placesAlreadyPicked) {
        for (ResolvedLocation selected : placesAlreadyPicked) {
            if (!this.inSameCountry(candidate, selected)) continue;
            return true;
        }
        return false;
    }

    protected boolean inSameCountry(ResolvedLocation loc1, ResolvedLocation loc2) {
        return loc1.getGeoname().getPrimaryCountryCode().equals((Object)loc2.getGeoname().getPrimaryCountryCode());
    }

    protected boolean inSameAdmin1(ResolvedLocation candidate, List<ResolvedLocation> list) {
        for (ResolvedLocation item : list) {
            if (!candidate.getGeoname().getAdmin1Code().equals(item.getGeoname().getAdmin1Code())) continue;
            return true;
        }
        return false;
    }

    public static void logSelectedCandidate(ResolvedLocation candidate) {
        logger.debug("  PICKED: " + candidate.getLocation().getText() + "@" + candidate.getLocation().getPosition());
    }

    public static void logResolvedLocationInfo(ResolvedLocation resolvedLocation) {
        GeoName candidatePlace = resolvedLocation.getGeoname();
        logger.debug("    " + candidatePlace.getGeonameID() + " " + candidatePlace.getName() + ", " + candidatePlace.getAdmin1Code() + ", " + candidatePlace.getPrimaryCountryCode() + " / " + resolvedLocation.getConfidence() + " / " + candidatePlace.getPopulation() + " / " + candidatePlace.getFeatureClass() + " ( isExactMatch=" + GenericPass.isExactMatch(resolvedLocation) + " )");
    }

    public int getTriggerCount() {
        return this.triggerCount;
    }
}

