/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.gazetteer.FeatureClass;
import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.disambiguation.GenericPass;
import java.util.ArrayList;
import java.util.List;

public class FuzzyMatchedCountriesPass
extends GenericPass {
    @Override
    protected List<List<ResolvedLocation>> disambiguate(List<List<ResolvedLocation>> possibilitiesToDo, List<ResolvedLocation> bestCandidates) {
        ArrayList<List<ResolvedLocation>> possibilitiesToRemove = new ArrayList<List<ResolvedLocation>>();
        for (List<ResolvedLocation> candidates : possibilitiesToDo) {
            ResolvedLocation countryCandidate = this.findFirstCountryCandidate(candidates, false);
            if (countryCandidate == null) continue;
            bestCandidates.add(countryCandidate);
            possibilitiesToRemove.add(candidates);
        }
        return possibilitiesToRemove;
    }

    protected ResolvedLocation findFirstCountryCandidate(List<ResolvedLocation> candidates, boolean exactMatchRequired) {
        boolean keepGoing = true;
        for (ResolvedLocation candidate : candidates) {
            if (!keepGoing || candidate.getGeoname().getFeatureClass().equals((Object)FeatureClass.T)) continue;
            if (FuzzyMatchedCountriesPass.isCountry(candidate)) {
                if (exactMatchRequired && FuzzyMatchedCountriesPass.isExactMatch(candidate)) {
                    return candidate;
                }
                if (exactMatchRequired) continue;
                return candidate;
            }
            keepGoing = false;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Pick countries that might not be an exact match";
    }
}

