/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places.disambiguation;

import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.disambiguation.GenericPass;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactColocationsPass
extends GenericPass {
    private static final Logger logger = LoggerFactory.getLogger(ExactColocationsPass.class);

    @Override
    protected List<List<ResolvedLocation>> disambiguate(List<List<ResolvedLocation>> possibilitiesToDo, List<ResolvedLocation> bestCandidates) {
        ArrayList<List<ResolvedLocation>> possibilitiesToRemove = new ArrayList<List<ResolvedLocation>>();
        possibilitiesToRemove.clear();
        if (bestCandidates.size() == 0) {
            return possibilitiesToRemove;
        }
        for (List<ResolvedLocation> candidates : possibilitiesToDo) {
            ResolvedLocation candidateToPick = null;
            List<ResolvedLocation> colocatedExactCityCandidates = this.inSameCountry(candidates, bestCandidates, true, true, true);
            logger.debug("  Found " + colocatedExactCityCandidates.size() + " colocations");
            if (colocatedExactCityCandidates.size() == 1) {
                candidateToPick = colocatedExactCityCandidates.get(0);
            } else if (colocatedExactCityCandidates.size() > 1) {
                List<ResolvedLocation> shareCountryAndAdm1 = this.inSameCountryAndAdm1(colocatedExactCityCandidates, bestCandidates);
                candidateToPick = shareCountryAndAdm1.size() > 0 ? shareCountryAndAdm1.get(0) : colocatedExactCityCandidates.get(0);
            }
            if (candidateToPick == null) continue;
            logger.debug("  " + candidateToPick.getGeoname().getGeonameID() + "  " + candidateToPick.getGeoname().getName() + " is in " + candidateToPick.getGeoname().getPrimaryCountryCode());
            bestCandidates.add(candidateToPick);
            possibilitiesToRemove.add(candidates);
        }
        return possibilitiesToRemove;
    }

    private List<ResolvedLocation> inSameCountryAndAdm1(List<ResolvedLocation> candidates, List<ResolvedLocation> alreadyPicked) {
        ArrayList<ResolvedLocation> colocations = new ArrayList<ResolvedLocation>();
        for (ResolvedLocation pickedLocation : alreadyPicked) {
            for (ResolvedLocation candidate : candidates) {
                if (!this.isSameCountryAndAdm1(candidate, pickedLocation)) continue;
                colocations.add(candidate);
            }
        }
        return colocations;
    }

    private boolean isSameCountryAndAdm1(ResolvedLocation place1, ResolvedLocation place2) {
        return place1.getGeoname().getAdmin1Code().equals(place2.getGeoname().getAdmin1Code());
    }

    @Override
    public String getDescription() {
        return "Looking for top populated city exact match in same countries/states as best results so far";
    }
}

