/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places;

import com.bericotech.clavin.gazetteer.GeoName;
import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.ParseManager;
import io.bigconnect.dw.ner.common.places.AbstractGeoNameLookup;
import io.bigconnect.dw.ner.common.places.CliffLocationResolver;
import io.bigconnect.dw.ner.common.places.UnknownGeoNameIdException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountryGeoNameLookup
extends AbstractGeoNameLookup {
    public static final Logger logger = LoggerFactory.getLogger(CountryGeoNameLookup.class);
    public static final String RESOURCE_NAME = "countryInfo.txt";
    private static CountryGeoNameLookup instance;
    private Configuration configuration;

    public CountryGeoNameLookup(Configuration configuration) throws IOException {
        this.configuration = configuration;
    }

    @Override
    public void parse() {
        try {
            CliffLocationResolver resolver = ParseManager.getResolver(this.configuration);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(RESOURCE_NAME)));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                String[] columns = line.trim().split("\t");
                try {
                    String iso3166Alpha2 = columns[0];
                    int geonameId = Integer.parseInt(columns[16]);
                    this.put(iso3166Alpha2, resolver.getByGeoNameId(geonameId));
                }
                catch (NumberFormatException nfe) {
                    logger.error("Couldn't parse geoname id from line: " + line);
                }
                catch (UnknownGeoNameIdException ugie) {
                    logger.error("Uknown geoNameId " + ugie.getGeoNameId() + " for: " + columns[4]);
                }
            }
            logger.info("Loaded " + this.size() + " countries");
        }
        catch (Exception e) {
            logger.error("Unable to load location resolver");
            logger.error(e.toString());
        }
    }

    private static CountryGeoNameLookup getInstance(Configuration configuration) throws IOException {
        if (instance == null) {
            instance = new CountryGeoNameLookup(configuration);
        }
        return instance;
    }

    public static GeoName lookup(String countryCodeAlpha2, Configuration configuration) {
        try {
            CountryGeoNameLookup lookup = CountryGeoNameLookup.getInstance(configuration);
            GeoName countryGeoName = lookup.get(countryCodeAlpha2);
            logger.debug("Found '" + countryCodeAlpha2 + "': " + countryGeoName);
            return countryGeoName;
        }
        catch (IOException ioe) {
            logger.error("Couldn't lookup country geoname!");
            logger.error(ioe.toString());
            return null;
        }
    }
}

