/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places;

import com.bericotech.clavin.ClavinException;
import com.bericotech.clavin.extractor.LocationOccurrence;
import com.bericotech.clavin.gazetteer.CountryCode;
import com.bericotech.clavin.gazetteer.FeatureClass;
import com.bericotech.clavin.gazetteer.FeatureCode;
import com.bericotech.clavin.gazetteer.GeoName;
import com.bericotech.clavin.gazetteer.query.FuzzyMode;
import com.bericotech.clavin.gazetteer.query.Gazetteer;
import com.bericotech.clavin.gazetteer.query.QueryBuilder;
import com.bericotech.clavin.resolver.ClavinLocationResolver;
import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.places.UnknownGeoNameIdException;
import io.bigconnect.dw.ner.common.places.disambiguation.HeuristicDisambiguationStrategy;
import io.bigconnect.dw.ner.common.places.disambiguation.LocationDisambiguationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliffLocationResolver
extends ClavinLocationResolver {
    private static final Logger logger = LoggerFactory.getLogger(CliffLocationResolver.class);
    public static final int MAX_HIT_DEPTH = 10;
    private LocationDisambiguationStrategy disambiguationStrategy = new HeuristicDisambiguationStrategy();
    private boolean filterOutDemonyms = false;

    public CliffLocationResolver(Gazetteer gazetteer) {
        super(gazetteer);
    }

    public GeoName getByGeoNameId(int geoNameId) throws UnknownGeoNameIdException {
        try {
            return this.getGazetteer().getGeoName(geoNameId);
        }
        catch (ClavinException ce) {
            throw new UnknownGeoNameIdException(geoNameId);
        }
    }

    public List<ResolvedLocation> resolveLocations(List<LocationOccurrence> locations, int maxHitDepth, int maxContextWindow, boolean fuzzy) throws ClavinException {
        List<LocationOccurrence> filteredLocations;
        if (locations == null || locations.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.filterOutDemonyms) {
            filteredLocations = new ArrayList<LocationOccurrence>();
            for (LocationOccurrence location : locations) {
                if (CliffLocationResolver.isDemonym((LocationOccurrence)location)) continue;
                filteredLocations.add(location);
            }
        } else {
            filteredLocations = locations;
        }
        if (filteredLocations.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        QueryBuilder builder = new QueryBuilder().maxResults(maxHitDepth).fuzzyMode(fuzzy ? FuzzyMode.NO_EXACT : FuzzyMode.OFF).includeHistorical(true);
        if (maxHitDepth > 1) {
            ArrayList<List<ResolvedLocation>> allCandidates = new ArrayList<List<ResolvedLocation>>();
            long startTime = System.nanoTime();
            for (LocationOccurrence location : filteredLocations) {
                ArrayList<ResolvedLocation> candidates = new ArrayList<ResolvedLocation>();
                if (this.getGazetteer() != null) {
                    candidates.addAll(this.getGazetteer().getClosestLocations(builder.location(location).build()));
                } else {
                    candidates.add(this.toResolvedLocation(location));
                }
                if (candidates.size() <= 0) continue;
                allCandidates.add(candidates);
            }
            long gazetteerTime = System.nanoTime() - startTime;
            ArrayList<ResolvedLocation> bestCandidates = new ArrayList();
            startTime = System.nanoTime();
            bestCandidates = this.disambiguationStrategy.select(this, allCandidates);
            long disambiguationTime = System.nanoTime() - startTime;
            logger.debug("gazetterAndDisambiguation: " + gazetteerTime + " / " + disambiguationTime);
            return bestCandidates;
        }
        ArrayList<ResolvedLocation> resolvedLocations = new ArrayList<ResolvedLocation>();
        for (LocationOccurrence location : filteredLocations) {
            List candidateLocations;
            if (this.getGazetteer() != null) {
                candidateLocations = this.getGazetteer().getClosestLocations(builder.location(location).build());
            } else {
                candidateLocations = new ArrayList<ResolvedLocation>();
                candidateLocations.add(this.toResolvedLocation(location));
            }
            if (candidateLocations.size() <= 0) continue;
            resolvedLocations.add((ResolvedLocation)candidateLocations.get(0));
        }
        return resolvedLocations;
    }

    private ResolvedLocation toResolvedLocation(LocationOccurrence location) {
        return new ResolvedLocation(location, (GeoName)new DummyGeoName(location), location.getText(), false);
    }

    public void logStats() {
        this.disambiguationStrategy.logStats();
    }

    public static class DummyGeoName
    implements GeoName {
        private LocationOccurrence locationOccurrence;

        public DummyGeoName(LocationOccurrence locationOccurrence) {
            this.locationOccurrence = locationOccurrence;
        }

        public String getPrimaryCountryName() {
            return "";
        }

        public String getParentAncestryKey() {
            return null;
        }

        public String getAncestryKey() {
            return null;
        }

        public boolean isTopLevelAdminDivision() {
            return false;
        }

        public boolean isTopLevelTerritory() {
            return false;
        }

        public boolean isDescendantOf(GeoName geoname) {
            return false;
        }

        public boolean isAncestorOf(GeoName geoname) {
            return false;
        }

        public Integer getParentId() {
            return null;
        }

        public GeoName getParent() {
            return null;
        }

        public boolean setParent(GeoName prnt) {
            return false;
        }

        public boolean isAncestryResolved() {
            return false;
        }

        public int getGeonameID() {
            return 0;
        }

        public String getName() {
            return this.locationOccurrence.getText();
        }

        public String getAsciiName() {
            return this.getName();
        }

        public List<String> getAlternateNames() {
            return new ArrayList<String>();
        }

        public String getPreferredName() {
            return this.getName();
        }

        public double getLatitude() {
            return 0.0;
        }

        public double getLongitude() {
            return 0.0;
        }

        public FeatureClass getFeatureClass() {
            return FeatureClass.NULL;
        }

        public FeatureCode getFeatureCode() {
            return FeatureCode.NULL;
        }

        public CountryCode getPrimaryCountryCode() {
            return CountryCode.NULL;
        }

        public List<CountryCode> getAlternateCountryCodes() {
            return new ArrayList<CountryCode>();
        }

        public String getAdmin1Code() {
            return null;
        }

        public String getAdmin2Code() {
            return null;
        }

        public String getAdmin3Code() {
            return null;
        }

        public String getAdmin4Code() {
            return null;
        }

        public long getPopulation() {
            return 0L;
        }

        public int getElevation() {
            return 0;
        }

        public int getDigitalElevationModel() {
            return 0;
        }

        public TimeZone getTimezone() {
            return null;
        }

        public Date getModificationDate() {
            return null;
        }

        public String getGazetteerRecord() {
            return null;
        }

        public String getGazetteerRecordWithAncestry() {
            return null;
        }
    }
}

