/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.places;

import com.bericotech.clavin.gazetteer.CountryCode;
import com.bericotech.clavin.gazetteer.GeoName;
import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.ParseManager;
import io.bigconnect.dw.ner.common.places.AbstractGeoNameLookup;
import io.bigconnect.dw.ner.common.places.CliffLocationResolver;
import io.bigconnect.dw.ner.common.places.UnknownGeoNameIdException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Adm1GeoNameLookup
extends AbstractGeoNameLookup {
    public static final Logger logger = LoggerFactory.getLogger(Adm1GeoNameLookup.class);
    public static final String RESOURCE_NAME = "admin1CodesASCII.txt";
    private static Adm1GeoNameLookup instance;
    private Configuration configuration;

    public Adm1GeoNameLookup(Configuration configuration) throws IOException {
        this.configuration = configuration;
    }

    public static String getKey(String countryCode, String ADM1) {
        return countryCode + "." + ADM1;
    }

    public static String getKey(CountryCode countryCode, String ADM1) {
        return Adm1GeoNameLookup.getKey(countryCode.name(), ADM1);
    }

    public GeoName get(String countryCode, String ADM1) {
        return this.get(Adm1GeoNameLookup.getKey(countryCode, ADM1));
    }

    @Override
    public void parse() {
        try {
            CliffLocationResolver resolver = ParseManager.getResolver(this.configuration);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(RESOURCE_NAME)));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                String[] columns = line.trim().split("\t");
                String key = columns[0];
                String name = columns[1];
                int geonameId = Integer.parseInt(columns[3]);
                try {
                    this.put(key, resolver.getByGeoNameId(geonameId));
                }
                catch (UnknownGeoNameIdException e) {
                    logger.error("Uknown geoNameId " + geonameId + " for " + name);
                }
            }
            logger.info("Loaded " + this.size() + " countries");
        }
        catch (Exception e) {
            logger.error("Unable to load location resolver");
            logger.error(e.toString());
        }
    }

    private static Adm1GeoNameLookup getInstance(Configuration configuration) throws IOException {
        if (instance == null) {
            instance = new Adm1GeoNameLookup(configuration);
        }
        return instance;
    }

    public static GeoName lookup(String countryCodeDotAdm1Code, Configuration configuration) {
        try {
            Adm1GeoNameLookup lookup = Adm1GeoNameLookup.getInstance(configuration);
            GeoName geoName = lookup.get(countryCodeDotAdm1Code);
            logger.debug("Found '" + countryCodeDotAdm1Code + "': " + geoName);
            return geoName;
        }
        catch (IOException ioe) {
            logger.error("Couldn't lookup state ADM1 geoname!");
            logger.error(ioe.toString());
            return null;
        }
    }

    public static boolean isValid(String countryCodeDotAdm1Code, Configuration configuration) {
        boolean valid = false;
        try {
            Adm1GeoNameLookup lookup = Adm1GeoNameLookup.getInstance(configuration);
            valid = lookup.contains(countryCodeDotAdm1Code);
        }
        catch (IOException ioe) {
            logger.error("Couldn't lookup state ADM1 geoname!");
            logger.error(ioe.toString());
        }
        return valid;
    }

    public static GeoName lookup(String countryCode, String adm1Code, Configuration configuration) {
        return Adm1GeoNameLookup.lookup(Adm1GeoNameLookup.getKey(countryCode, adm1Code), configuration);
    }
}

