/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.people.disambiguation;

import io.bigconnect.dw.ner.common.extractor.PersonOccurrence;
import io.bigconnect.dw.ner.common.people.ResolvedPerson;
import io.bigconnect.dw.ner.common.people.disambiguation.PersonDisambiguationStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KindaDumbDisambiguationStrategy
implements PersonDisambiguationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(KindaDumbDisambiguationStrategy.class);

    @Override
    public List<ResolvedPerson> select(List<PersonOccurrence> allPossibilities) {
        ArrayList<ResolvedPerson> bestCandidates = new ArrayList<ResolvedPerson>();
        for (PersonOccurrence occurrence : allPossibilities) {
            if (bestCandidates.size() == 0) {
                bestCandidates.add(new ResolvedPerson(occurrence));
                continue;
            }
            boolean added = false;
            for (ResolvedPerson alreadyAdded : bestCandidates) {
                String newDude = occurrence.text.toLowerCase(Locale.US);
                String oldDude = alreadyAdded.getName().toLowerCase(Locale.US);
                if (oldDude.indexOf(newDude) < 0 && newDude.indexOf(oldDude) < 0) continue;
                logger.debug(alreadyAdded.getName() + " is a version of " + occurrence.text);
                alreadyAdded.addOccurrence(occurrence);
                added = true;
                break;
            }
            if (added) continue;
            bestCandidates.add(new ResolvedPerson(occurrence));
        }
        return bestCandidates;
    }

    @Override
    public void logStats() {
    }
}

