/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.orgs.disambiguation;

import io.bigconnect.dw.ner.common.extractor.OrganizationOccurrence;
import io.bigconnect.dw.ner.common.orgs.ResolvedOrganization;
import io.bigconnect.dw.ner.common.orgs.disambiguation.OrganizationDisambiguationStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDuplicatesDisambiguationStrategy
implements OrganizationDisambiguationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RemoveDuplicatesDisambiguationStrategy.class);

    @Override
    public List<ResolvedOrganization> select(List<OrganizationOccurrence> allPossibilities) {
        ArrayList<ResolvedOrganization> bestCandidates = new ArrayList<ResolvedOrganization>();
        for (OrganizationOccurrence occurrence : allPossibilities) {
            if (bestCandidates.size() == 0) {
                bestCandidates.add(new ResolvedOrganization(occurrence));
                continue;
            }
            boolean added = false;
            for (ResolvedOrganization alreadyAdded : bestCandidates) {
                String oldDude;
                String newDude = occurrence.text.toLowerCase(Locale.US);
                if (!newDude.equals(oldDude = alreadyAdded.getName().toLowerCase(Locale.US))) continue;
                logger.debug(alreadyAdded.getName() + " is a duplicate of " + occurrence.text);
                alreadyAdded.addOccurrence(occurrence);
                added = true;
                break;
            }
            if (added) continue;
            bestCandidates.add(new ResolvedOrganization(occurrence));
        }
        return bestCandidates;
    }

    @Override
    public void logStats() {
    }
}

