/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.extractor;

import com.bericotech.clavin.extractor.LocationOccurrence;
import com.bericotech.clavin.gazetteer.CountryCode;
import com.bericotech.clavin.gazetteer.GeoName;
import com.bericotech.clavin.resolver.ResolvedLocation;
import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.extractor.GenericOccurrence;
import io.bigconnect.dw.ner.common.extractor.OrganizationOccurrence;
import io.bigconnect.dw.ner.common.extractor.PersonOccurrence;
import io.bigconnect.dw.ner.common.orgs.ResolvedOrganization;
import io.bigconnect.dw.ner.common.people.ResolvedPerson;
import io.bigconnect.dw.ner.common.places.CountryGeoNameLookup;
import java.util.ArrayList;
import java.util.List;

public class ExtractedEntities {
    private List<LocationOccurrence> locations;
    private List<ResolvedLocation> resolvedLocations;
    private List<PersonOccurrence> people;
    private List<ResolvedPerson> resolvedPeople;
    private List<OrganizationOccurrence> organizations;
    private List<ResolvedOrganization> resolvedOrganizations;
    private List<GenericOccurrence> otherEntities;
    private Configuration configuration;

    public ExtractedEntities(Configuration configuration) {
        this.configuration = configuration;
        this.locations = new ArrayList<LocationOccurrence>();
        this.resolvedPeople = new ArrayList<ResolvedPerson>();
        this.people = new ArrayList<PersonOccurrence>();
        this.resolvedLocations = new ArrayList<ResolvedLocation>();
        this.organizations = new ArrayList<OrganizationOccurrence>();
        this.resolvedOrganizations = new ArrayList<ResolvedOrganization>();
        this.otherEntities = new ArrayList<GenericOccurrence>();
    }

    public void merge(ExtractedEntities e2) {
        this.locations.addAll(e2.getLocations());
        this.resolvedPeople.addAll(e2.getResolvedPeople());
        this.people.addAll(e2.getPeople());
        this.resolvedLocations.addAll(e2.getResolvedLocations());
        this.organizations.addAll(e2.getOrganizations());
        this.resolvedOrganizations.addAll(e2.getResolvedOrganizations());
        this.otherEntities.addAll(e2.getOtherEntities());
    }

    public void addOrganization(OrganizationOccurrence organization) {
        this.organizations.add(organization);
    }

    public void addPerson(PersonOccurrence person) {
        this.people.add(person);
    }

    public void addLocation(LocationOccurrence location) {
        this.locations.add(location);
    }

    public void addGenericEntity(GenericOccurrence occurrence) {
        this.otherEntities.add(occurrence);
    }

    public List<PersonOccurrence> getPeople() {
        return this.people;
    }

    public List<LocationOccurrence> getLocations() {
        return this.locations;
    }

    public List<OrganizationOccurrence> getOrganizations() {
        return this.organizations;
    }

    public List<GenericOccurrence> getOtherEntities() {
        return this.otherEntities;
    }

    public void setResolvedLocations(List<ResolvedLocation> locs) {
        this.resolvedLocations = locs;
    }

    public List<ResolvedLocation> getResolvedLocations() {
        return this.resolvedLocations;
    }

    public List<ResolvedOrganization> getResolvedOrganizations() {
        return this.resolvedOrganizations;
    }

    public List<CountryCode> getUniqueCountries() {
        return ExtractedEntities.getUniqueCountries(this.resolvedLocations);
    }

    public List<GeoName> getUniqueCountryGeoNames() {
        return ExtractedEntities.getUniqueCountryGeoNames(this.resolvedLocations, this.configuration);
    }

    public static List<CountryCode> getUniqueCountries(List<ResolvedLocation> resolvedLocations) {
        ArrayList<CountryCode> countries = new ArrayList<CountryCode>();
        for (ResolvedLocation resolvedLocation : resolvedLocations) {
            CountryCode country = resolvedLocation.getGeoname().getPrimaryCountryCode();
            if (country == CountryCode.NULL || countries.contains(country)) continue;
            countries.add(country);
        }
        return countries;
    }

    public static List<GeoName> getUniqueCountryGeoNames(List<ResolvedLocation> resolvedLocations, Configuration configuration) {
        List<CountryCode> countryCodes = ExtractedEntities.getUniqueCountries(resolvedLocations);
        ArrayList<GeoName> geoNames = new ArrayList<GeoName>();
        for (CountryCode countryCode : countryCodes) {
            geoNames.add(CountryGeoNameLookup.lookup(countryCode.name(), configuration));
        }
        return geoNames;
    }

    public void setResolvedPeople(List<ResolvedPerson> resolvedPeople) {
        this.resolvedPeople = resolvedPeople;
    }

    public List<ResolvedPerson> getResolvedPeople() {
        return this.resolvedPeople;
    }

    public void setResolvedOrganizations(List<ResolvedOrganization> resolvedOrganizations) {
        this.resolvedOrganizations = resolvedOrganizations;
    }
}

