/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common.extractor;

import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.extractor.EntityExtractor;
import io.bigconnect.dw.ner.common.extractor.ExtractedEntities;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityExtractorService {
    private static final Logger logger = LoggerFactory.getLogger(EntityExtractorService.class);
    private static EntityExtractorService service;
    private ServiceLoader<EntityExtractor> loader;
    private Configuration configuration;

    private EntityExtractorService(Configuration configuration) {
        this.configuration = configuration;
        this.loader = ServiceLoader.load(EntityExtractor.class);
    }

    public static synchronized EntityExtractorService getInstance(Configuration configuration) {
        if (service == null) {
            service = new EntityExtractorService(configuration);
        }
        return service;
    }

    public void initialize(Configuration config) throws Exception {
        Iterator<EntityExtractor> extractors = this.loader.iterator();
        logger.info("Initializing NER Extractors");
        while (extractors.hasNext()) {
            EntityExtractor currentExtractor = extractors.next();
            logger.info("Initializing Extractor - {}", (Object)currentExtractor.getName());
            currentExtractor.initialize(config);
        }
    }

    public ExtractedEntities extractEntities(String languageCode, String textToParse, boolean manuallyReplaceDemonyms) {
        ExtractedEntities e = new ExtractedEntities(this.configuration);
        try {
            Iterator<EntityExtractor> extractors = this.loader.iterator();
            while (extractors != null && extractors.hasNext()) {
                EntityExtractor currentExtractor = extractors.next();
                ExtractedEntities e2 = currentExtractor.extractEntities(languageCode, textToParse, manuallyReplaceDemonyms);
                e.merge(e2);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            e = null;
            serviceError.printStackTrace();
        }
        return e;
    }

    public ExtractedEntities extractEntitiesFromSentences(String languageCode, Map[] sentences, boolean manuallyReplaceDemonyms) {
        ExtractedEntities e = new ExtractedEntities(this.configuration);
        try {
            Iterator<EntityExtractor> extractors = this.loader.iterator();
            while (extractors != null && extractors.hasNext()) {
                EntityExtractor currentExtractor = extractors.next();
                ExtractedEntities e2 = currentExtractor.extractEntitiesFromSentences(languageCode, sentences, manuallyReplaceDemonyms);
                e.merge(e2);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            e = null;
            serviceError.printStackTrace();
        }
        return e;
    }
}

