/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common;

import com.bericotech.clavin.gazetteer.CountryCode;
import com.bericotech.clavin.gazetteer.GeoName;
import com.bericotech.clavin.gazetteer.query.Gazetteer;
import com.bericotech.clavin.gazetteer.query.LuceneGazetteer;
import com.bericotech.clavin.resolver.ResolvedLocation;
import com.google.gson.Gson;
import com.mware.core.config.Configuration;
import io.bigconnect.dw.ner.common.EntityParser;
import io.bigconnect.dw.ner.common.extractor.EntityExtractorService;
import io.bigconnect.dw.ner.common.extractor.ExtractedEntities;
import io.bigconnect.dw.ner.common.extractor.SentenceLocationOccurrence;
import io.bigconnect.dw.ner.common.orgs.ResolvedOrganization;
import io.bigconnect.dw.ner.common.people.ResolvedPerson;
import io.bigconnect.dw.ner.common.places.Adm1GeoNameLookup;
import io.bigconnect.dw.ner.common.places.CliffLocationResolver;
import io.bigconnect.dw.ner.common.places.CountryGeoNameLookup;
import io.bigconnect.dw.ner.common.places.UnknownGeoNameIdException;
import io.bigconnect.dw.ner.common.places.focus.FocusLocation;
import io.bigconnect.dw.ner.common.places.focus.FocusStrategy;
import io.bigconnect.dw.ner.common.places.focus.FrequencyOfMentionFocusStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseManager {
    public static final String CONFIGURATION_PREFIX = "entityExtractor";
    public static final String GEOINDEX_PATH = "entityExtractor.geoIndexPath";
    static final String PARSER_VERSION = "2.4.2";
    private static final Logger logger = LoggerFactory.getLogger(ParseManager.class);
    public static EntityParser parser = null;
    private static CliffLocationResolver resolver;
    private static FocusStrategy focusStrategy;
    public static final String STATUS_OK = "ok";
    public static final String STATUS_ERROR = "error";

    public static HashMap getResponseMap(HashMap results) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", STATUS_OK);
        response.put("version", PARSER_VERSION);
        response.put("results", results);
        return response;
    }

    public static GeoName getGeoName(int id) throws UnknownGeoNameIdException {
        GeoName geoname = resolver.getByGeoNameId(id);
        return geoname;
    }

    public static HashMap getGeoNameInfo(int id, Configuration config) {
        return ParseManager.getGeoNameInfo(id, true, config);
    }

    public static HashMap getGeoNameInfo(int id, boolean withAncestry, Configuration config) {
        try {
            GeoName geoname = ParseManager.getGeoName(id);
            HashMap info = ParseManager.writeGeoNameToHash(geoname, config);
            if (withAncestry) {
                HashMap childInfo = info;
                GeoName child = geoname;
                while (child.getParent() != null) {
                    GeoName parent = child.getParent();
                    HashMap parentInfo = ParseManager.writeGeoNameToHash(parent, config);
                    childInfo.put("parent", parentInfo);
                    child = parent;
                    childInfo = parentInfo;
                }
            }
            HashMap response = ParseManager.getResponseMap(info);
            return response;
        }
        catch (UnknownGeoNameIdException e) {
            logger.warn(e.getMessage());
            return ParseManager.getErrorText("Invalid GeoNames id " + id);
        }
    }

    public static HashMap parseFromText(String languageCode, String text, boolean manuallyReplaceDemonyms, Configuration config) {
        long startTime = System.currentTimeMillis();
        HashMap results = null;
        if (text.trim().length() == 0) {
            return ParseManager.getErrorText("No text");
        }
        try {
            ExtractedEntities entities = ParseManager.extractAndResolve(config, languageCode, text, manuallyReplaceDemonyms);
            results = ParseManager.parseFromEntities(entities, config);
        }
        catch (Exception e) {
            logger.error(e.toString(), (Throwable)e);
            results = ParseManager.getErrorText(e.toString());
        }
        long endTime = System.currentTimeMillis();
        long elapsedMillis = endTime - startTime;
        results.put("milliseconds", elapsedMillis);
        return results;
    }

    public static HashMap parseFromSentences(String languageCode, String jsonText, boolean manuallyReplaceDemonyms, Configuration config) {
        long startTime = System.currentTimeMillis();
        HashMap results = null;
        if (jsonText.trim().length() == 0) {
            return ParseManager.getErrorText("No text");
        }
        try {
            Gson gson = new Gson();
            Map[] sentences = (Map[])gson.fromJson(jsonText, Map[].class);
            ExtractedEntities entities = ParseManager.extractAndResolveFromSentences(config, languageCode, sentences, manuallyReplaceDemonyms);
            results = ParseManager.parseFromEntities(entities, config);
        }
        catch (Exception e) {
            results = ParseManager.getErrorText(e.toString());
        }
        long endTime = System.currentTimeMillis();
        long elapsedMillis = endTime - startTime;
        results.put("milliseconds", elapsedMillis);
        return results;
    }

    public static HashMap parseFromEntities(ExtractedEntities entities, Configuration configuration) {
        if (entities == null) {
            return ParseManager.getErrorText("No place or person entitites detected in this text.");
        }
        logger.debug("Adding Mentions:");
        HashMap<String, Cloneable> results = new HashMap<String, Cloneable>();
        HashMap<String, Cloneable> placeResults = new HashMap<String, Cloneable>();
        ArrayList<HashMap> resolvedPlaces = new ArrayList<HashMap>();
        for (ResolvedLocation resolvedLocation : entities.getResolvedLocations()) {
            Iterator<FocusLocation> loc = ParseManager.writeResolvedLocationToHash(resolvedLocation, configuration);
            resolvedPlaces.add((HashMap)((Object)loc));
        }
        placeResults.put("mentions", resolvedPlaces);
        logger.debug("Adding Focus:");
        HashMap focusResults = new HashMap();
        if (resolvedPlaces.size() > 0) {
            logger.debug("Adding Country Focus:");
            ArrayList<HashMap> focusLocationInfoList = new ArrayList<HashMap>();
            for (FocusLocation focusLocation : focusStrategy.selectCountries(entities.getResolvedLocations())) {
                try {
                    focusLocationInfoList.add(ParseManager.writeAboutnessLocationToHash(focusLocation, configuration));
                }
                catch (NullPointerException npe) {
                    logger.warn("Got an about country with no Geoname info :-( ");
                }
            }
            focusResults.put("countries", focusLocationInfoList);
            logger.debug("Adding State Focus:");
            focusLocationInfoList = new ArrayList();
            for (FocusLocation focusLocation : focusStrategy.selectStates(entities.getResolvedLocations())) {
                focusLocationInfoList.add(ParseManager.writeAboutnessLocationToHash(focusLocation, configuration));
            }
            focusResults.put("states", focusLocationInfoList);
            logger.debug("Adding City Focus:");
            focusLocationInfoList = new ArrayList();
            for (FocusLocation focusLocation : focusStrategy.selectCities(entities.getResolvedLocations())) {
                focusLocationInfoList.add(ParseManager.writeAboutnessLocationToHash(focusLocation, configuration));
            }
            focusResults.put("cities", focusLocationInfoList);
        }
        placeResults.put("focus", focusResults);
        results.put("places", placeResults);
        logger.debug("Adding People:");
        List<ResolvedPerson> resolvedPeople = entities.getResolvedPeople();
        ArrayList<Object> personResults = new ArrayList<Object>();
        for (ResolvedPerson person : resolvedPeople) {
            HashMap<String, Object> sourceInfo = new HashMap<String, Object>();
            sourceInfo.put("name", person.getName());
            sourceInfo.put("count", person.getOccurenceCount());
            personResults.add(sourceInfo);
        }
        results.put("people", personResults);
        logger.debug("Adding Organizations:");
        List<ResolvedOrganization> list = entities.getResolvedOrganizations();
        ArrayList organizationResults = new ArrayList();
        for (ResolvedOrganization organization : list) {
            HashMap<String, Object> sourceInfo = new HashMap<String, Object>();
            sourceInfo.put("name", organization.getName());
            sourceInfo.put("count", organization.getOccurenceCount());
            organizationResults.add(sourceInfo);
        }
        results.put("organizations", organizationResults);
        HashMap response = ParseManager.getResponseMap(results);
        return response;
    }

    public static HashMap writeGeoNameToHash(GeoName place, Configuration configuration) {
        HashMap<String, Object> loc = new HashMap<String, Object>();
        loc.put("id", place.getGeonameID());
        loc.put("name", place.getName());
        loc.put("lat", place.getLatitude());
        loc.put("lon", place.getLongitude());
        loc.put("population", place.getPopulation());
        String featureCode = place.getFeatureCode().toString();
        loc.put("featureClass", place.getFeatureClass().toString());
        loc.put("featureCode", featureCode);
        String primaryCountryCodeAlpha2 = "";
        if (place.getPrimaryCountryCode() != CountryCode.NULL) {
            primaryCountryCodeAlpha2 = place.getPrimaryCountryCode().toString();
        }
        loc.put("countryCode", primaryCountryCodeAlpha2);
        GeoName countryGeoName = CountryGeoNameLookup.lookup(primaryCountryCodeAlpha2, configuration);
        String countryGeoNameId = "";
        if (countryGeoName != null) {
            countryGeoNameId = "" + countryGeoName.getGeonameID();
        }
        loc.put("countryGeoNameId", countryGeoNameId);
        String admin1Code = "";
        if (place.getAdmin1Code() != null) {
            admin1Code = place.getAdmin1Code();
        }
        loc.put("stateCode", admin1Code);
        GeoName adm1GeoName = Adm1GeoNameLookup.lookup(primaryCountryCodeAlpha2, admin1Code, configuration);
        String stateGeoNameId = "";
        if (adm1GeoName != null) {
            stateGeoNameId = "" + adm1GeoName.getGeonameID();
        }
        loc.put("stateGeoNameId", stateGeoNameId);
        return loc;
    }

    public static HashMap writeAboutnessLocationToHash(FocusLocation location, Configuration configuration) {
        HashMap loc = ParseManager.writeGeoNameToHash(location.getGeoName(), configuration);
        loc.put("score", location.getScore());
        return loc;
    }

    public static HashMap writeResolvedLocationToHash(ResolvedLocation resolvedLocation, Configuration configuration) {
        HashMap loc = ParseManager.writeGeoNameToHash(resolvedLocation.getGeoname(), configuration);
        int charIndex = resolvedLocation.getLocation().getPosition();
        loc.put("confidence", Float.valueOf(resolvedLocation.getConfidence()));
        HashMap<String, Object> sourceInfo = new HashMap<String, Object>();
        sourceInfo.put("string", resolvedLocation.getLocation().getText());
        sourceInfo.put("charIndex", charIndex);
        if (resolvedLocation.getLocation() instanceof SentenceLocationOccurrence) {
            sourceInfo.put("storySentencesId", ((SentenceLocationOccurrence)resolvedLocation.getLocation()).storySentenceId);
        }
        loc.put("source", sourceInfo);
        return loc;
    }

    public static ExtractedEntities extractAndResolve(Configuration config, String languageCode, String text) throws Exception {
        return ParseManager.extractAndResolve(config, languageCode, text, false);
    }

    public static ExtractedEntities extractAndResolve(Configuration config, String languageCode, String text, boolean manuallyReplaceDemonyms) throws Exception {
        return ParseManager.getParserInstance(config).extractAndResolve(languageCode, text, manuallyReplaceDemonyms);
    }

    public static ExtractedEntities extractAndResolveFromSentences(Configuration config, String languageCode, Map[] sentences, boolean manuallyReplaceDemonyms) throws Exception {
        return ParseManager.getParserInstance(config).extractAndResolveFromSentences(languageCode, sentences, manuallyReplaceDemonyms);
    }

    public static HashMap getErrorText(String msg) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("version", PARSER_VERSION);
        info.put("status", STATUS_ERROR);
        info.put("details", msg);
        return info;
    }

    public static void logStats() {
        if (resolver != null) {
            resolver.logStats();
        }
    }

    public static EntityParser getParserInstance(Configuration config) throws Exception {
        if (parser == null) {
            focusStrategy = new FrequencyOfMentionFocusStrategy(config);
            EntityExtractorService extractor = EntityExtractorService.getInstance(config);
            extractor.initialize(config);
            boolean useFuzzyMatching = false;
            LuceneGazetteer gazetteer = null;
            File gazetteerDir = new File(config.get(GEOINDEX_PATH, ""));
            if (!gazetteerDir.exists() || !gazetteerDir.isDirectory()) {
                logger.error("Missing gazetter! Download and build a CLAVIN IndexDirectory at " + config.get(GEOINDEX_PATH, ""));
            } else {
                logger.info("Loading CLAVIN Gazetteer from " + config.get(GEOINDEX_PATH, ""));
                gazetteer = new LuceneGazetteer(new File(config.get(GEOINDEX_PATH, "")));
            }
            resolver = new CliffLocationResolver((Gazetteer)gazetteer);
            parser = new EntityParser(extractor, resolver, useFuzzyMatching, 10);
            logger.info("Created parser successfully");
        }
        return parser;
    }

    public static CliffLocationResolver getLocationResolver(Configuration configuration) throws Exception {
        ParseManager.getParserInstance(configuration);
        return resolver;
    }

    public static FocusStrategy getFocusStrategy(Configuration configuration) throws Exception {
        ParseManager.getParserInstance(configuration);
        return focusStrategy;
    }

    public static CliffLocationResolver getResolver(Configuration configuration) throws Exception {
        ParseManager.getParserInstance(configuration);
        return resolver;
    }
}

