/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common;

import com.bericotech.clavin.resolver.ResolvedLocation;
import io.bigconnect.dw.ner.common.extractor.EntityExtractorService;
import io.bigconnect.dw.ner.common.extractor.ExtractedEntities;
import io.bigconnect.dw.ner.common.orgs.OrganizationResolver;
import io.bigconnect.dw.ner.common.orgs.ResolvedOrganization;
import io.bigconnect.dw.ner.common.people.PersonResolver;
import io.bigconnect.dw.ner.common.people.ResolvedPerson;
import io.bigconnect.dw.ner.common.places.CliffLocationResolver;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityParser {
    private static final Logger logger = LoggerFactory.getLogger(EntityParser.class);
    private EntityExtractorService extractor;
    private CliffLocationResolver locationResolver;
    private PersonResolver personResolver;
    private OrganizationResolver organizationResolver;
    private final boolean fuzzy;
    private final int maxHitDepth;

    public EntityParser(EntityExtractorService extractor, CliffLocationResolver resolver, boolean fuzzy, int maxHitDepth) {
        this.extractor = extractor;
        this.locationResolver = resolver;
        this.personResolver = new PersonResolver();
        this.organizationResolver = new OrganizationResolver();
        this.fuzzy = fuzzy;
        this.maxHitDepth = maxHitDepth;
    }

    public ExtractedEntities extractAndResolve(String languageCode, String inputText, boolean manuallyReplaceDemonyms) throws Exception {
        ExtractedEntities extractedEntities = this.extractor.extractEntities(languageCode, inputText, manuallyReplaceDemonyms);
        return this.resolve(extractedEntities);
    }

    public ExtractedEntities extractAndResolveFromSentences(String languageCode, Map[] sentences, boolean manuallyReplaceDemonyms) throws Exception {
        ExtractedEntities extractedEntities = this.extractor.extractEntitiesFromSentences(languageCode, sentences, manuallyReplaceDemonyms);
        return this.resolve(extractedEntities);
    }

    public ExtractedEntities resolve(ExtractedEntities entities) throws Exception {
        List<ResolvedLocation> resolvedLocations = this.locationResolver.resolveLocations(entities.getLocations(), this.maxHitDepth, -1, this.fuzzy);
        entities.setResolvedLocations(resolvedLocations);
        logger.trace("resolvedLocations: {}", resolvedLocations);
        List<ResolvedPerson> resolvedPeople = this.personResolver.resolve(entities.getPeople());
        entities.setResolvedPeople(resolvedPeople);
        logger.trace("resolvedPeople: {}", resolvedPeople);
        List<ResolvedOrganization> resolvedOrganizations = this.organizationResolver.resolve(entities.getOrganizations());
        entities.setResolvedOrganizations(resolvedOrganizations);
        logger.trace("resolvedOrganizations: {}", resolvedOrganizations);
        return entities;
    }
}

