/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.ner.common;

import com.bericotech.clavin.resolver.ResolvedLocation;
import com.google.inject.Inject;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.RawObjectSchema;
import com.mware.core.model.termMention.TermMentionBuilder;
import com.mware.core.model.termMention.TermMentionRepository;
import com.mware.core.model.termMention.TermMentionUtils;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import com.mware.ontology.IgnoredMimeTypes;
import io.bigconnect.dw.ner.common.ParseManager;
import io.bigconnect.dw.ner.common.extractor.ExtractedEntities;
import io.bigconnect.dw.ner.common.extractor.GenericOccurrence;
import io.bigconnect.dw.ner.common.extractor.OrganizationOccurrence;
import io.bigconnect.dw.ner.common.extractor.PersonOccurrence;
import io.bigconnect.dw.ner.common.orgs.ResolvedOrganization;
import io.bigconnect.dw.ner.common.people.ResolvedPerson;
import io.bigconnect.dw.text.common.NerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class EntityExtractionDataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(EntityExtractionDataWorker.class);
    private TermMentionRepository termMentionRepository;
    private TermMentionUtils termMentionUtils;
    boolean resolveUnknownEntities;

    @Inject
    public EntityExtractionDataWorker(TermMentionRepository termMentionRepository) {
        this.termMentionRepository = termMentionRepository;
    }

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.resolveUnknownEntities = this.getConfiguration().getBoolean("entity.extractor.resolve-unknown", false);
        this.termMentionUtils = new TermMentionUtils(this.getGraph(), this.getVisibilityTranslator(), this.getAuthorizations(), this.getUser());
    }

    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (IgnoredMimeTypes.contains((String)((String)BcSchema.MIME_TYPE.getFirstPropertyValue(element)))) {
            return false;
        }
        if (property.getName().equals(RawObjectSchema.RAW_LANGUAGE.getPropertyName())) {
            String language = (String)RawObjectSchema.RAW_LANGUAGE.getPropertyValue(property);
            return !StringUtils.isEmpty((CharSequence)language);
        }
        return false;
    }

    public void execute(InputStream in, DataWorkerData data) throws Exception {
        String language = (String)RawObjectSchema.RAW_LANGUAGE.getPropertyValue(data.getProperty());
        Property textProperty = BcSchema.TEXT.getProperty(this.refresh(data.getElement()), data.getProperty().getKey());
        if (textProperty == null) {
            return;
        }
        StreamingPropertyValue textPropertyValue = (StreamingPropertyValue)BcSchema.TEXT.getPropertyValue(textProperty);
        if (textPropertyValue == null) {
            LOGGER.warn("Could not find text property for language: " + language, new Object[0]);
            return;
        }
        String text = IOUtils.toString((InputStream)textPropertyValue.getInputStream(), (Charset)StandardCharsets.UTF_8);
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        try {
            Vertex outVertex = (Vertex)this.refresh(data.getElement());
            NerUtils.removeEntityTermMentions((Vertex)outVertex, (TermMentionRepository)this.termMentionRepository, (TermMentionUtils)this.termMentionUtils, (Graph)this.getGraph(), (Authorizations)this.getAuthorizations());
            ExtractedEntities entities = ParseManager.extractAndResolve(this.getConfiguration(), language, text);
            if (entities != null) {
                VisibilityJson tmVisibilityJson = new VisibilityJson();
                tmVisibilityJson.setSource("");
                this.addLocations(outVertex, textProperty, tmVisibilityJson, entities);
                this.addPersons(outVertex, textProperty, tmVisibilityJson, entities);
                this.addOrganizations(outVertex, textProperty, tmVisibilityJson, entities);
                this.addOtherEntities(outVertex, textProperty, tmVisibilityJson, entities);
                this.getGraph().flush();
                this.pushTextUpdated(data);
            } else {
                LOGGER.debug("No entities extracted", new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error extracting entities: " + e.getMessage(), (Throwable)e);
        }
    }

    private List<Vertex> addLocations(Vertex outVertex, Property property, VisibilityJson visibilityJson, ExtractedEntities entities) {
        HashSet<String> alreadyResolvedMentions = new HashSet<String>();
        ArrayList<Vertex> termMentions = new ArrayList<Vertex>();
        for (ResolvedLocation resolvedLocation : entities.getResolvedLocations()) {
            float confidence = resolvedLocation.getConfidence();
            int start = resolvedLocation.getLocation().getPosition();
            int end = start + resolvedLocation.getLocation().getText().length();
            String name = resolvedLocation.getGeoname().getName();
            if (alreadyResolvedMentions.contains(name)) continue;
            Vertex termMention = this.termMentionUtils.createTermMention(outVertex, property.getKey(), property.getName(), name, "location", start, end, visibilityJson);
            termMentions.add(termMention);
            Vertex resolvedToVertex = this.findExistingVertexWithConceptAndTitle("location", name);
            if (resolvedToVertex == null && this.resolveUnknownEntities) {
                resolvedToVertex = this.createResolvedVertex("location", name, outVertex.getVisibility());
            }
            if (resolvedToVertex != null) {
                this.resolveTermMention(outVertex, termMention, resolvedToVertex, "location", name);
                this.getGraph().flush();
            }
            alreadyResolvedMentions.add(name);
        }
        return termMentions;
    }

    private List<Vertex> addOrganizations(Vertex outVertex, Property property, VisibilityJson visibilityJson, ExtractedEntities entities) {
        ArrayList<Vertex> termMentions = new ArrayList<Vertex>();
        HashSet<String> alreadyResolvedMentions = new HashSet<String>();
        List<ResolvedOrganization> resolvedOrganizations = entities.getResolvedOrganizations();
        for (ResolvedOrganization organization : resolvedOrganizations) {
            String name = organization.getName();
            OrganizationOccurrence occurrence = organization.getOccurrences().get(0);
            int start = occurrence.position;
            int end = start + occurrence.text.length();
            if (alreadyResolvedMentions.contains(name)) continue;
            Vertex termMention = this.termMentionUtils.createTermMention(outVertex, property.getKey(), property.getName(), name, "organization", start, end, visibilityJson);
            termMentions.add(termMention);
            Vertex resolvedToVertex = this.findExistingVertexWithConceptAndTitle("organization", name);
            if (resolvedToVertex == null && this.resolveUnknownEntities) {
                resolvedToVertex = this.createResolvedVertex("organization", name, outVertex.getVisibility());
            }
            if (resolvedToVertex != null) {
                this.resolveTermMention(outVertex, termMention, resolvedToVertex, "organization", name);
                this.getGraph().flush();
            }
            alreadyResolvedMentions.add(name);
        }
        return termMentions;
    }

    private List<Vertex> addPersons(Vertex outVertex, Property property, VisibilityJson visibilityJson, ExtractedEntities entities) {
        HashSet<String> alreadyResolvedMentions = new HashSet<String>();
        ArrayList<Vertex> termMentions = new ArrayList<Vertex>();
        List<ResolvedPerson> resolvedOrganizations = entities.getResolvedPeople();
        for (ResolvedPerson person : resolvedOrganizations) {
            String name = person.getName();
            PersonOccurrence occurrence = person.getOccurrences().get(0);
            int start = occurrence.position;
            int end = start + occurrence.text.length();
            if (alreadyResolvedMentions.contains(name)) continue;
            Vertex termMention = this.termMentionUtils.createTermMention(outVertex, property.getKey(), property.getName(), name, "person", start, end, visibilityJson);
            termMentions.add(termMention);
            Vertex resolvedToVertex = this.findExistingVertexWithConceptAndTitle("person", name);
            if (resolvedToVertex == null && this.resolveUnknownEntities) {
                resolvedToVertex = this.createResolvedVertex("person", name, outVertex.getVisibility());
            }
            if (resolvedToVertex != null) {
                this.resolveTermMention(outVertex, termMention, resolvedToVertex, "person", name);
                this.getGraph().flush();
            }
            alreadyResolvedMentions.add(name);
        }
        return termMentions;
    }

    private List<Vertex> addOtherEntities(Vertex outVertex, Property property, VisibilityJson visibilityJson, ExtractedEntities entities) {
        HashSet<String> alreadyResolvedMentions = new HashSet<String>();
        ArrayList<Vertex> termMentions = new ArrayList<Vertex>();
        List<GenericOccurrence> otherEntities = entities.getOtherEntities();
        for (GenericOccurrence entity : otherEntities) {
            String name = entity.text;
            int start = entity.position;
            int end = start + name.length();
            String conceptType = entity.conceptType;
            if (alreadyResolvedMentions.contains(name)) continue;
            Vertex termMention = this.termMentionUtils.createTermMention(outVertex, property.getKey(), property.getName(), name, conceptType, start, end, visibilityJson);
            termMentions.add(termMention);
            Vertex resolvedToVertex = this.findExistingVertexWithConceptAndTitle(conceptType, name);
            if (resolvedToVertex == null && this.resolveUnknownEntities) {
                resolvedToVertex = this.createResolvedVertex("person", name, outVertex.getVisibility());
            }
            if (resolvedToVertex != null) {
                this.resolveTermMention(outVertex, termMention, resolvedToVertex, conceptType, name);
                this.getGraph().flush();
            }
            alreadyResolvedMentions.add(name);
        }
        return termMentions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vertex findExistingVertexWithConceptAndTitle(String conceptType, String title) {
        try (QueryResultsIterable existingVertices = this.getGraph().query(this.getAuthorizations()).hasConceptType(new String[]{conceptType}).has(BcSchema.TITLE.getPropertyName(), (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)title.trim())).vertices();){
            Iterator iterator = existingVertices.iterator();
            if (!iterator.hasNext()) return null;
            Vertex vertex = (Vertex)iterator.next();
            return vertex;
        }
        catch (IOException ex) {
            LOGGER.warn(ex.getMessage(), new Object[0]);
        }
        return null;
    }

    private Vertex resolveTermMention(Vertex outVertex, Vertex termMention, Vertex resolvedToVertex, String conceptType, String title) {
        String edgeId = outVertex.getId() + "-" + "hasDetectedEntity" + "-" + resolvedToVertex.getId();
        Edge resolvedEdge = this.getGraph().prepareEdge(edgeId, outVertex, resolvedToVertex, "hasDetectedEntity", outVertex.getVisibility()).save(this.getAuthorizations());
        String processId = ((Object)((Object)this)).getClass().getName();
        new TermMentionBuilder(termMention, outVertex).resolvedTo(resolvedToVertex, resolvedEdge).title(title).conceptName(conceptType).process(processId).resolvedFromTermMention(termMention.getId()).visibilityJson((VisibilityJson)BcSchema.TERM_MENTION_VISIBILITY_JSON.getPropertyValue((Element)termMention, (Object)new VisibilityJson())).save(this.getGraph(), this.getVisibilityTranslator(), this.getUser(), this.getAuthorizations());
        return resolvedToVertex;
    }

    private Vertex createResolvedVertex(String conceptType, String title, Visibility visibility) {
        VisibilityJson visibilityJson = new VisibilityJson();
        Metadata metadata = Metadata.create();
        BcSchema.VISIBILITY_JSON_METADATA.setMetadata(metadata, (Object)visibilityJson, this.getVisibilityTranslator().getDefaultVisibility());
        String id = this.getGraph().getIdGenerator().nextId();
        VertexBuilder vertexMutation = this.getGraph().prepareVertex(id, visibility, conceptType);
        BcSchema.TITLE.addPropertyValue((ElementMutation)vertexMutation, "", (Object)title, metadata, visibility);
        return (Vertex)vertexMutation.save(this.getAuthorizations());
    }
}

