/*
 * This file is part of the BigConnect project.
 *
 * Copyright (c) 2013-2020 MWARE SOLUTIONS SRL
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation with the addition of the
 * following permission added to Section 15 as permitted in Section 7(a):
 * FOR ANY PART OF THE COVERED WORK IN WHICH THE COPYRIGHT IS OWNED BY
 * MWARE SOLUTIONS SRL, MWARE SOLUTIONS SRL DISCLAIMS THE WARRANTY OF
 * NON INFRINGEMENT OF THIRD PARTY RIGHTS

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA, 02110-1301 USA, or download the license from the following URL:
 * https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License.
 *
 * You can be released from the requirements of the license by purchasing
 * a commercial license. Buying such a license is mandatory as soon as you
 * develop commercial activities involving the BigConnect software without
 * disclosing the source code of your own applications.
 *
 * These activities include: offering paid services to customers as an ASP,
 * embedding the product in a web application, shipping BigConnect with a
 * closed source product.
 */
package io.bigconnect.dw.ner.common.places.substitutions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class CustomSubstitutionMap extends AbstractSubstitutionMap {

    private static final Logger logger = LoggerFactory.getLogger(CustomSubstitutionMap.class);

    public CustomSubstitutionMap(String fileName){
        this(fileName,",",';',true,true);
    }

    public CustomSubstitutionMap(String fileName, boolean ignoreCase){
        this(fileName,",",';',true,ignoreCase);
    }

    public CustomSubstitutionMap(String fileName,String separator,char comment,boolean skipFirstRow, boolean ignoreCase){
        try {
            loadFromFile(fileName, separator, comment,skipFirstRow,ignoreCase);
        } catch (IOException e) {
            logger.error("Unable to load substitution list! "+e);
        }
    }

    protected void loadFromFile(String fileName,String separator,char comment,boolean skipFirstRow,boolean ignoreCase) throws IOException{
        logger.info("Loading custom substitutions from "+fileName+" ignoreCase="+ignoreCase);
        map = new HashMap<String,String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName)));
        // drop the table header rows
        if(skipFirstRow) br.readLine();
        // now walk each line
        String row = null;
        while ((row = br.readLine()) != null) {
            if(row.length()==0) continue;
            if(row.charAt(0)==comment) continue;    // skip comment lines
            String[] columns = row.split(separator);
            String original = columns[0].trim();
            String replacement = columns[1].trim();
            if(ignoreCase){
                original = columns[0].toLowerCase().trim();
                replacement = columns[1].toLowerCase().trim();
            }
            put( original, replacement );
        }
        logger.trace(this.toString());
    }

    public String toString(){
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("  " + entry.getKey() + " => " + entry.getValue()+"\n");
        }
        return sb.toString();
    }

}

