/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.image.metadata.utils;

import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.GpsDirectory;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.Values;

public class HeadingExtractor {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(HeadingExtractor.class);

    public static DoubleValue getImageHeading(Metadata metadata) {
        GpsDirectory gpsDir = (GpsDirectory)metadata.getFirstDirectoryOfType(GpsDirectory.class);
        if (gpsDir != null) {
            try {
                Double imageHeading = gpsDir.getDouble(17);
                return Values.doubleValue((double)imageHeading);
            }
            catch (MetadataException e) {
                LOGGER.debug("getDouble(TAG_GPS_IMAGE_DIRECTION) threw MetadataException when attempting toretrieve GPS Heading.", new Object[0]);
            }
        }
        return null;
    }
}

