/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.image.metadata.utils;

import com.drew.lang.GeoLocation;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.GpsDirectory;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.Values;

public class GeoPointExtractor {
    public static GeoPointValue getGeoPoint(Metadata metadata) {
        GeoLocation geoLocation;
        GpsDirectory gpsDir = (GpsDirectory)metadata.getFirstDirectoryOfType(GpsDirectory.class);
        if (gpsDir != null && (geoLocation = gpsDir.getGeoLocation()) != null) {
            Double latitude = geoLocation.getLatitude();
            Double longitude = geoLocation.getLongitude();
            Double altitude = null;
            try {
                altitude = gpsDir.getDouble(6);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
            if (latitude != null && latitude != 0.0 && longitude != null && longitude != 0.0) {
                if (altitude != null && altitude != 0.0) {
                    GeoPoint geoPoint = new GeoPoint(latitude.doubleValue(), longitude.doubleValue(), altitude.doubleValue());
                    return Values.geoPointValue((GeoPoint)geoPoint);
                }
                GeoPoint geoPoint = new GeoPoint(latitude.doubleValue(), longitude.doubleValue());
                return Values.geoPointValue((GeoPoint)geoPoint);
            }
        }
        return null;
    }
}

