/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.image.metadata.utils;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DimensionsExtractor {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(DimensionsExtractor.class);

    public static Integer getWidthViaMetadata(Metadata metadata) {
        return DimensionsExtractor.getDimensionViaMetadata(metadata, Dimension.WIDTH);
    }

    public static Integer getHeightViaMetadata(Metadata metadata) {
        return DimensionsExtractor.getDimensionViaMetadata(metadata, Dimension.HEIGHT);
    }

    private static Integer getDimensionViaMetadata(Metadata metadata, Dimension dimensionType) {
        if (dimensionType == null) {
            return null;
        }
        String tagName = dimensionType == Dimension.WIDTH ? "Image Width" : "Image Height";
        for (Directory directory : metadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                Integer dimension;
                if (!tagName.equalsIgnoreCase(tag.getTagName()) || (dimension = directory.getInteger(tag.getTagType())) == null) continue;
                return dimension;
            }
        }
        return null;
    }

    public static Integer getWidthViaBufferedImage(File imageFile) {
        try {
            BufferedImage bufImage = ImageIO.read(imageFile);
            int width = bufImage.getWidth();
            return width;
        }
        catch (IOException e) {
            if (imageFile != null) {
                LOGGER.debug("Could not read imageFile: " + imageFile.getName(), new Object[0]);
            }
            return null;
        }
    }

    public static Integer getHeightViaBufferedImage(File imageFile) {
        try {
            BufferedImage bufImage = ImageIO.read(imageFile);
            int height = bufImage.getHeight();
            return height;
        }
        catch (IOException e) {
            if (imageFile != null) {
                LOGGER.debug("Could not read imageFile: " + imageFile.getName(), new Object[0]);
            }
            return null;
        }
    }

    private static enum Dimension {
        WIDTH,
        HEIGHT;

    }
}

