/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.image.metadata;

import com.google.inject.Inject;
import com.mware.bigconnect.image.ImageTransform;
import com.mware.bigconnect.image.ImageTransformExtractor;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.ingest.dataworker.PostMimeTypeWorker;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.properties.types.BooleanSingleValueBcProperty;
import com.mware.core.model.properties.types.IntegerSingleValueBcProperty;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.mutation.ElementMutation;
import com.mware.ge.mutation.ExistingElementMutation;
import java.io.File;
import java.util.ArrayList;

@Name(value="Drewnoakes Image Metadata")
@Description(value="Extracts image metadata using Drewnoakes after MIME type")
public class ImageOrientationPostMimeTypeWorker
extends PostMimeTypeWorker {
    private SchemaRepository ontologyRepository;
    private BooleanSingleValueBcProperty yAxisFlippedProperty;
    private IntegerSingleValueBcProperty clockwiseRotationProperty;

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.yAxisFlippedProperty = new BooleanSingleValueBcProperty(this.ontologyRepository.getRequiredPropertyNameByIntent("media.yAxisFlipped"));
        this.clockwiseRotationProperty = new IntegerSingleValueBcProperty(this.ontologyRepository.getRequiredPropertyNameByIntent("media.clockwiseRotation"));
    }

    public void execute(String mimeType, DataWorkerData data, Authorizations authorizations) throws Exception {
        if (!mimeType.startsWith("image")) {
            return;
        }
        File localFile = this.getLocalFileForRaw(data.getElement());
        Metadata metadata = data.createPropertyMetadata(this.getUser());
        ExistingElementMutation mutation = this.refresh(data.getElement(), authorizations).prepareMutation();
        ImageTransform imageTransform = ImageTransformExtractor.getImageTransform((File)localFile);
        ArrayList changedProperties = new ArrayList();
        this.yAxisFlippedProperty.updateProperty(changedProperties, data.getElement(), (ElementMutation)mutation, (Object)imageTransform.isYAxisFlipNeeded(), metadata, data.getVisibility());
        this.clockwiseRotationProperty.updateProperty(changedProperties, data.getElement(), (ElementMutation)mutation, (Object)imageTransform.getCWRotationNeeded(), metadata, data.getVisibility());
        Element e = mutation.save(authorizations);
        this.getGraph().flush();
        this.getWebQueueRepository().broadcastPropertiesChange(e, changedProperties, null, data.getPriority());
        this.getWorkQueueRepository().pushGraphPropertyQueue(e, changedProperties, null, null, data.getPriority());
    }

    @Inject
    public void setSchemaRepository(SchemaRepository schemaRepository) {
        this.ontologyRepository = schemaRepository;
    }
}

