/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.image.metadata;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageMetadataReader;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.MediaBcSchema;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.FileSizeUtil;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import io.bigconnect.dw.image.metadata.utils.DateExtractor;
import io.bigconnect.dw.image.metadata.utils.DimensionsExtractor;
import io.bigconnect.dw.image.metadata.utils.GeoPointExtractor;
import io.bigconnect.dw.image.metadata.utils.HeadingExtractor;
import io.bigconnect.dw.image.metadata.utils.MakeExtractor;
import io.bigconnect.dw.image.metadata.utils.ModelExtractor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@Name(value="Drewnoakes Image Metadata")
@Description(value="Extracts image metadata using Drewnoakes open source tool")
public class ImageMetadataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ImageMetadataWorker.class);
    public static final String MULTI_VALUE_KEY = ImageMetadataWorker.class.getName();
    private String fileSizeIri;
    private String dateTakenIri;
    private String deviceMakeIri;
    private String deviceModelIri;
    private String geoLocationIri;
    private String headingIri;
    private String metadataIri;
    private String widthIri;
    private String heightIri;

    public boolean isLocalFileRequired() {
        return true;
    }

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.headingIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.imageHeading", "public-ontology");
        this.geoLocationIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("geoLocation", "public-ontology");
        this.dateTakenIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.dateTaken", "public-ontology");
        this.deviceMakeIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.deviceMake", "public-ontology");
        this.deviceModelIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.deviceModel", "public-ontology");
        this.widthIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.width", "public-ontology");
        this.heightIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.height", "public-ontology");
        this.metadataIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.metadata", "public-ontology");
        this.fileSizeIri = this.getSchemaRepository().getRequiredPropertyNameByIntent("media.fileSize", "public-ontology");
    }

    private void setProperty(String iri, Value value, ExistingElementMutation<Vertex> mutation, Metadata metadata, DataWorkerData data, List<String> properties) {
        if (iri != null && value != null) {
            mutation.addPropertyValue(MULTI_VALUE_KEY, iri, value, metadata, data.getVisibility());
            properties.add(iri);
        }
    }

    public void execute(InputStream in, DataWorkerData data) throws Exception {
        File imageFile = data.getLocalFile();
        if (imageFile == null) {
            return;
        }
        BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(imageFile));
        FileType detectedFileType = FileTypeDetector.detectFileType((BufferedInputStream)fileInputStream);
        if (detectedFileType == null || detectedFileType == FileType.Unknown) {
            return;
        }
        Metadata metadata = data.createPropertyMetadata(this.getUser());
        ExistingElementMutation mutation = this.refresh(data.getElement()).prepareMutation();
        ArrayList<String> properties = new ArrayList<String>();
        com.drew.metadata.Metadata imageMetadata = null;
        try {
            imageMetadata = ImageMetadataReader.readMetadata((InputStream)fileInputStream);
        }
        catch (Exception e) {
            LOGGER.error("Could not read metadata from imageFile: %s", new Object[]{imageFile, e});
        }
        Integer width = null;
        Integer height = null;
        if (imageMetadata != null) {
            this.setProperty(this.dateTakenIri, (Value)DateExtractor.getDateDefault(imageMetadata), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
            this.setProperty(this.deviceMakeIri, (Value)MakeExtractor.getMake(imageMetadata), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
            this.setProperty(this.deviceModelIri, (Value)ModelExtractor.getModel(imageMetadata), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
            this.setProperty(this.geoLocationIri, (Value)GeoPointExtractor.getGeoPoint(imageMetadata), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
            this.setProperty(this.headingIri, (Value)HeadingExtractor.getImageHeading(imageMetadata), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
            width = DimensionsExtractor.getWidthViaMetadata(imageMetadata);
            height = DimensionsExtractor.getHeightViaMetadata(imageMetadata);
        }
        if (width == null) {
            width = DimensionsExtractor.getWidthViaBufferedImage(imageFile);
        }
        this.setProperty(this.widthIri, Values.of((Object)width), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
        if (height == null) {
            height = DimensionsExtractor.getHeightViaBufferedImage(imageFile);
        }
        this.setProperty(this.heightIri, Values.of((Object)height), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
        this.setProperty(this.fileSizeIri, Values.of((Object)FileSizeUtil.getSize((File)imageFile)), (ExistingElementMutation<Vertex>)mutation, metadata, data, properties);
        Element e = mutation.save(this.getAuthorizations());
        this.getGraph().flush();
        for (String propertyName : properties) {
            if (this.getWebQueueRepository().shouldBroadcastGraphPropertyChange(propertyName, data.getPriority())) {
                this.getWebQueueRepository().broadcastPropertyChange(e, MULTI_VALUE_KEY, propertyName, null);
            }
            this.getWorkQueueRepository().pushGraphPropertyQueue(e, MULTI_VALUE_KEY, propertyName, null, null, data.getPriority(), ElementOrPropertyStatus.UPDATE, null);
        }
    }

    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (property.getName().equals(MediaBcSchema.VIDEO_FRAME.getPropertyName())) {
            return false;
        }
        String mimeType = (String)BcSchema.MIME_TYPE_METADATA.getMetadataValue(property.getMetadata(), null);
        return mimeType != null && mimeType.startsWith("image");
    }
}

