/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.image.face;

import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.types.BooleanBcProperty;
import com.mware.core.model.properties.types.IntegerBcProperty;
import com.mware.core.model.properties.types.StringBcProperty;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.GeException;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import io.bigconnect.dw.image.face.MultipartUtility;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

@Name(value="Face Descriptor Data Worker")
@Description(value="Extracts face descriptors for face recognition process")
public class FaceDescriptorDataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(FaceDescriptorDataWorker.class);
    private static final Boolean USE_CLASSIFIER = true;
    private static final BooleanBcProperty PROCESSED_PROPERTY = new BooleanBcProperty("processed");
    private static final String FACE_PERSON_RELATIONSHIP_NAME = "faceOf";
    private static final String DEFAULT_EXTRACTOR_URL = "http://127.0.0.1:5000/face";
    private static final String DEFAULT_DETECTOR_URL = "127.0.0.1:6060";
    private static final String DETECTOR_RELOAD_ENDPOINT = "/reload";
    private static final String EXTRACTOR_URL_CONF_KEY = "face.extractor.url";
    private static final String DETECTOR_URL_CONF_KEY = "face.detectors.url";
    public static final IntegerBcProperty FACE_NUMBER = new IntegerBcProperty("noFaces");
    public static final StringBcProperty FACE_DESCRIPTOR = new StringBcProperty("faceDescriptor");
    private String extractorUrl;
    private List<String> detectorsUrls;
    private final Configuration configuration;

    @Inject
    public FaceDescriptorDataWorker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        this.extractorUrl = Optional.ofNullable(this.configuration.get(EXTRACTOR_URL_CONF_KEY, DEFAULT_EXTRACTOR_URL)).orElseThrow(() -> new GeException("'face.extractor.path' config property not found."));
        String _urls = Optional.ofNullable(this.configuration.get(DETECTOR_URL_CONF_KEY, DEFAULT_DETECTOR_URL)).orElseThrow(() -> new GeException("'face.detectors.url' config property not found."));
        this.detectorsUrls = Arrays.asList(_urls.split(","));
        try {
            new URL(this.extractorUrl);
        }
        catch (MalformedURLException e) {
            throw new GeException("Value configured for 'face.extractor.url' is not a valid URL.");
        }
    }

    public boolean isHandled(Element element, Property property) {
        Edge edge;
        if (element instanceof Edge && FACE_PERSON_RELATIONSHIP_NAME.equals((edge = (Edge)element).getLabel())) {
            Property processed = edge.getProperty(PROCESSED_PROPERTY.getPropertyName());
            if (processed != null) {
                return !((BooleanValue)processed.getValue()).booleanValue();
            }
            return true;
        }
        return false;
    }

    public void execute(InputStream in, DataWorkerData data) throws Exception {
        LOGGER.debug("Executing Face Descriptor Data Worker", new Object[0]);
        Edge edge = (Edge)data.getElement();
        Vertex person = edge.getVertex(Direction.IN, this.getAuthorizations());
        Vertex image = edge.getVertex(Direction.OUT, this.getAuthorizations());
        StreamingPropertyValue rawImage = (StreamingPropertyValue)BcSchema.RAW.getPropertyValue((Element)image);
        try {
            this.runExtractor(person, rawImage);
            PROCESSED_PROPERTY.addPropertyValue((Element)edge, "", (Object)Boolean.TRUE, data.createPropertyMetadata(this.getUser()), this.getVisibilityTranslator().getDefaultVisibility(), this.getAuthorizations());
            this.getWebQueueRepository().broadcastPropertyChange((Element)edge, "", PROCESSED_PROPERTY.getPropertyName(), data.getWorkspaceId());
            this.getWorkQueueRepository().pushGraphPropertyQueue((Element)edge, "", PROCESSED_PROPERTY.getPropertyName(), data.getWorkspaceId(), data.getVisibilitySource(), Priority.HIGH, ElementOrPropertyStatus.UPDATE, null);
            this.getGraph().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void runExtractor(Vertex vertex, StreamingPropertyValue rawImage) throws Exception {
        MultipartUtility multipart = new MultipartUtility(this.extractorUrl, "UTF-8");
        multipart.addFilePart("file", "file", rawImage.getInputStream());
        String descriptor = multipart.finish();
        if (!StringUtils.isEmpty((String)descriptor)) {
            Property oldDescriptor;
            Property noFaces = vertex.getProperty(FACE_NUMBER.getPropertyName());
            int numberOfFaces = 0;
            if (noFaces != null && noFaces.getValue() != null) {
                numberOfFaces = ((IntValue)noFaces.getValue()).value();
                FACE_NUMBER.removeProperty((Element)vertex, "", this.getAuthorizations());
            }
            if (!USE_CLASSIFIER.booleanValue() && (oldDescriptor = vertex.getProperty(FACE_DESCRIPTOR.getPropertyName())) != null && oldDescriptor.getValue() != null) {
                String old = ((TextValue)oldDescriptor.getValue()).stringValue();
                descriptor = this.mean(old, descriptor, numberOfFaces);
                FACE_DESCRIPTOR.removeProperty((Element)vertex, old, this.getAuthorizations());
            }
            FACE_DESCRIPTOR.addPropertyValue((Element)vertex, descriptor, (Object)descriptor, vertex.getVisibility(), this.getAuthorizations());
            FACE_NUMBER.addPropertyValue((Element)vertex, "", (Object)(++numberOfFaces), vertex.getVisibility(), this.getAuthorizations());
            this.getGraph().flush();
            this.getWebQueueRepository().broadcastPropertyChange((Element)vertex, descriptor, FACE_DESCRIPTOR.getPropertyName(), null);
            this.getWorkQueueRepository().pushGraphPropertyQueue((Element)vertex, descriptor, FACE_DESCRIPTOR.getPropertyName(), null, null, Priority.HIGH, ElementOrPropertyStatus.UPDATE, null);
            this.notifyDetectors();
        }
    }

    private void notifyDetectors() {
        this.detectorsUrls.forEach(url -> {
            try {
                MultipartUtility req = new MultipartUtility("http://" + url + DETECTOR_RELOAD_ENDPOINT, "UTF-8");
                req.finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private String mean(String first, String second, int n) {
        String[] firstList = first.split(",");
        String[] secondList = second.split(",");
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < firstList.length; ++i) {
            if (!result.toString().isEmpty()) {
                result.append(",");
            }
            result.append((Float.parseFloat(firstList[i]) * (float)n + Float.parseFloat(secondList[i])) / (float)(n + 1) + "");
        }
        return result.toString();
    }
}

