/*
 * Decompiled with CFR 0.152.
 */
package com.mware.gpw.groovy;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.gpw.groovy.GroovyDataWorker;
import com.mware.gpw.groovy.ScriptData;
import groovy.lang.GroovyShell;
import groovy.lang.MetaMethod;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroovyDataWorkerScriptRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GroovyDataWorker.class);
    public static final String CONFIG_SCRIPT_DIR = GroovyDataWorker.class.getName() + ".scriptDir";
    public static final String CONFIG_REFRESH_INTERVAL_MS = GroovyDataWorker.class.getName() + ".refreshIntervalMs";
    public static final int CONFIG_REFRESH_INTERVAL_MS_DEFAULT = 1000;
    private final long refreshInterval;
    private final File scriptDir;
    private long lastRefreshTime;
    private Map<File, ScriptData> scripts = new HashMap<File, ScriptData>();

    @Inject
    public GroovyDataWorkerScriptRepository(Configuration configuration) {
        this.refreshInterval = configuration.getInt(CONFIG_REFRESH_INTERVAL_MS, Integer.valueOf(1000)).intValue();
        String scriptDirStr = configuration.get(CONFIG_SCRIPT_DIR, null);
        Preconditions.checkNotNull((Object)scriptDirStr, (Object)(CONFIG_SCRIPT_DIR + " is required configuration parameter"));
        this.scriptDir = new File(scriptDirStr);
    }

    public void refreshScripts() {
        if (!this.isReadyToRefresh()) {
            return;
        }
        ArrayList<File> filesToRemove = new ArrayList<File>(this.scripts.keySet());
        this.refreshScripts(filesToRemove, this.scriptDir);
        this.removeScriptsThatAreNoLongerPresent(filesToRemove);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    private void removeScriptsThatAreNoLongerPresent(List<File> filesToRemove) {
        for (File f : filesToRemove) {
            LOGGER.info("removing script: %s", new Object[]{f.getAbsolutePath()});
            this.scripts.remove(f);
        }
    }

    private boolean isReadyToRefresh() {
        return this.lastRefreshTime + this.refreshInterval <= System.currentTimeMillis();
    }

    private void refreshScripts(List<File> filesToRemove, File file) {
        if (file.isFile()) {
            if (!file.getAbsolutePath().endsWith(".groovy")) {
                return;
            }
            try {
                this.refreshScript(file);
                filesToRemove.remove(file);
            }
            catch (Exception e) {
                LOGGER.error("Could not load script: " + file.getAbsolutePath(), (Throwable)e);
            }
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                return;
            }
            for (File child : children) {
                this.refreshScripts(filesToRemove, child);
            }
        }
    }

    private void refreshScript(File file) throws IOException {
        ScriptData scriptData = this.scripts.get(file);
        if (!this.isNew(file, scriptData)) {
            return;
        }
        scriptData = this.loadScript(file);
        this.scripts.put(file, scriptData);
    }

    private ScriptData loadScript(File file) throws IOException {
        LOGGER.info("Loading %s", new Object[]{file.getAbsolutePath()});
        GroovyShell shell = new GroovyShell();
        Script script = shell.parse(file);
        this.validateScript(script);
        ScriptData scriptData = new ScriptData(file, script);
        return scriptData;
    }

    private boolean isNew(File file, ScriptData scriptData) {
        if (scriptData == null) {
            return true;
        }
        return scriptData.getModifiedTime() < file.lastModified();
    }

    private void validateScript(Script script) {
        MetaMethod isHandledMethod = script.getMetaClass().getMetaMethod("isHandled", new Object[]{Element.class, Property.class});
        Preconditions.checkNotNull((Object)isHandledMethod, (Object)"Could not find isHandled(Element, Property) method in script");
        MetaMethod executeMethod = script.getMetaClass().getMetaMethod("execute", new Object[]{InputStream.class, DataWorkerData.class});
        Preconditions.checkNotNull((Object)executeMethod, (Object)"Could not find execute(InputStream, GraphPropertyWorkData) method in script");
    }

    public Iterable<ScriptData> getScriptDatas() {
        return this.scripts.values();
    }
}

