/*
 * Decompiled with CFR 0.152.
 */
package com.mware.gpw.groovy;

import com.google.inject.Inject;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.gpw.groovy.GroovyDataWorkerScriptRepository;
import com.mware.gpw.groovy.ScriptData;
import java.io.InputStream;

@Name(value="Groovy GPW Script Executor")
@Description(value="Runs groovy scripts as graph property workers")
public class GroovyDataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GroovyDataWorker.class);
    private final GroovyDataWorkerScriptRepository scriptRepository;

    @Inject
    public GroovyDataWorker(GroovyDataWorkerScriptRepository scriptRepository) {
        this.scriptRepository = scriptRepository;
    }

    public boolean isHandled(Element element, Property property) {
        this.scriptRepository.refreshScripts();
        for (ScriptData scriptData : this.scriptRepository.getScriptDatas()) {
            try {
                if (!scriptData.isHandled(element, property)) continue;
                return true;
            }
            catch (Throwable ex) {
                LOGGER.error("could not run isHandle method on script: %s", new Object[]{scriptData.toString(), ex});
            }
        }
        return false;
    }

    public void execute(InputStream in, DataWorkerData data) throws Exception {
        for (ScriptData scriptData : this.scriptRepository.getScriptDatas()) {
            if (!scriptData.isHandled(data.getElement(), data.getProperty())) continue;
            try {
                scriptData.execute(in, data);
            }
            catch (Throwable ex) {
                LOGGER.error("could not run execute method on script: %s", new Object[]{scriptData.toString(), ex});
            }
        }
    }
}

