/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.google.translate;

import com.google.cloud.translate.v3beta1.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3beta1.LocationName;
import com.google.cloud.translate.v3beta1.SupportedLanguage;
import com.google.cloud.translate.v3beta1.SupportedLanguages;
import com.google.cloud.translate.v3beta1.TranslationServiceClient;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.notification.SystemNotificationRepository;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.types.BcProperty;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Element;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.util.Preconditions;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import io.bigconnect.dw.google.common.schema.GoogleCredentialUtils;
import io.bigconnect.dw.google.translate.GoogleTranslateSchemaContribution;
import io.bigconnect.dw.google.translate.LanguageDetectorUtil;
import io.bigconnect.dw.text.common.TextPropertyHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Name(value="Google Translate")
@Description(value="Uses Google API to translate text to English")
@Singleton
public class GoogleTranslateDataWorker
extends DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(GoogleTranslateDataWorker.class);
    private static final String CONFIG_TARGET_LANGUAGE = "google.translate.target_language";
    private Set<String> supportedLanguages;
    private String targetLanguage;
    private LocationName locationName;
    private LanguageDetectorUtil languageDetector;
    private SystemNotificationRepository systemNotificationRepository;

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        super.prepare(workerPrepareData);
        GoogleCredentialUtils.checkCredentials();
        this.targetLanguage = this.getConfiguration().get(CONFIG_TARGET_LANGUAGE, "");
        Preconditions.checkState((!StringUtils.isEmpty((CharSequence)this.targetLanguage) ? 1 : 0) != 0, (Object)"Please provide the google.translate.target_language config property");
        this.supportedLanguages = this.getSupportedTranslations();
        Preconditions.checkState((this.supportedLanguages != null && !this.supportedLanguages.isEmpty() ? 1 : 0) != 0, (Object)("No translations supported for language: " + this.targetLanguage));
        this.locationName = LocationName.of((String)GoogleCredentialUtils.getProjectId(), (String)"global");
        this.languageDetector = new LanguageDetectorUtil();
    }

    public boolean isHandled(Element element, Property property) {
        if (property == null) {
            return false;
        }
        if (GoogleTranslateSchemaContribution.GOOGLE_TRANSLATE_PROPERTY.getPropertyName().equals(property.getName())) {
            Boolean performTranslate = GoogleTranslateSchemaContribution.GOOGLE_TRANSLATE_PROPERTY.getPropertyValue(element, false);
            return Boolean.TRUE.equals(performTranslate);
        }
        return false;
    }

    public void execute(InputStream in, DataWorkerData data) throws Exception {
        Element element = this.refresh(data.getElement());
        boolean success = true;
        success = success && this.translateTextProperties(element, data);
        boolean bl = success = success && this.translateTitleProperties(element, data);
        if (success) {
            GoogleTranslateSchemaContribution.GOOGLE_TRANSLATE_PROPERTY.setProperty(element, (Object)Boolean.FALSE, Visibility.EMPTY, element.getAuthorizations());
        } else {
            GoogleTranslateSchemaContribution.GOOGLE_TRANSLATE_PROPERTY.setProperty(element, (Object)Boolean.TRUE, Visibility.EMPTY, element.getAuthorizations());
        }
        this.getGraph().flush();
    }

    /*
     * Exception decompiling
     */
    private boolean translateTitleProperties(Element element, DataWorkerData data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean translateTextProperties(Element element, DataWorkerData data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Property> findKeyedPropertiesToTranslate(Element element, BcProperty<?> propertyToTranslate) {
        ArrayList<Property> propertiesToTranslate = new ArrayList<Property>();
        for (Property property : propertyToTranslate.getProperties(element)) {
            boolean canTranslate;
            String titleLanguage = TextPropertyHelper.getTextLanguage((Property)property);
            if (StringUtils.isEmpty((CharSequence)titleLanguage) && !StringUtils.isEmpty((CharSequence)(titleLanguage = (String)this.languageDetector.detectLanguage((String)property.getValue().asObjectCopy()).or((Object)"")))) {
                ExistingElementMutation m = element.prepareMutation();
                m.setPropertyMetadata(property, BcSchema.TEXT_LANGUAGE_METADATA.getMetadataKey(), (Value)Values.stringValue((String)titleLanguage), Visibility.EMPTY);
                element = m.save(this.getAuthorizations());
            }
            if (!StringUtils.isEmpty((CharSequence)titleLanguage) && this.targetLanguage.equals(titleLanguage) || !(canTranslate = StringUtils.isEmpty((CharSequence)titleLanguage) || this.supportedLanguages.contains(titleLanguage))) continue;
            propertiesToTranslate.add(property);
        }
        return propertiesToTranslate;
    }

    private void logElement(Element element, String sourceLanguage, String text) {
        String SEPARATOR = "|$";
        Vertex v = (Vertex)element;
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append("gTranslateLog_8365775793").append("|$").append(text.length()).append("|$").append(v.getPropertyValue("createdDate")).append("|$").append(v.getId()).append("|$").append(v.getPropertyValue("title")).append("|$").append(v.getConceptType()).append("|$").append(v.getPropertyValue("source")).append("|$").append(sourceLanguage).append("|$").append(v.getTimestamp());
        LOGGER.warn(sb.toString(), new Object[0]);
    }

    public Set<String> getSupportedTranslations() throws IOException {
        try (TranslationServiceClient client = TranslationServiceClient.create();){
            LocationName parent = LocationName.of((String)GoogleCredentialUtils.getProjectId(), (String)"global");
            GetSupportedLanguagesRequest request = GetSupportedLanguagesRequest.newBuilder().setParent(parent.toString()).setDisplayLanguageCode(this.targetLanguage).build();
            SupportedLanguages response = client.getSupportedLanguages(request);
            Set<String> set = response.getLanguagesList().stream().map(SupportedLanguage::getLanguageCode).collect(Collectors.toSet());
            return set;
        }
    }

    @Inject
    public void setSystemNotificationRepository(SystemNotificationRepository systemNotificationRepository) {
        this.systemNotificationRepository = systemNotificationRepository;
    }
}

