/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.dw.google.common.schema;

import com.google.auth.oauth2.ServiceAccountCredentials;
import com.mware.ge.util.Preconditions;
import java.io.IOException;

public class GoogleCredentialUtils {
    public static void checkCredentials() {
        Preconditions.checkNotNull((Object)System.getenv("GOOGLE_APPLICATION_CREDENTIALS"), (Object)"The GOOGLE_APPLICATION_CREDENTIALS env variable is not set.");
    }

    public static String getProjectId() {
        try {
            GoogleCredentialUtils.checkCredentials();
            ServiceAccountCredentials credentials = (ServiceAccountCredentials)ServiceAccountCredentials.getApplicationDefault();
            return credentials.getProjectId();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not retrieve projectId from credentials file", e);
        }
    }
}

