/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.cypher.internal.ir;

import com.mware.ge.cypher.internal.util.Cardinality;
import com.mware.ge.cypher.internal.util.Cardinality$;
import com.mware.ge.cypher.internal.util.Selectivity;
import com.mware.ge.cypher.internal.util.Selectivity$;
import com.mware.ge.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001f\ty1+\u001a7fGRLg/\u001b;z)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0011\u0011N\u001d\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000f!\taaY=qQ\u0016\u0014(BA\u0005\u000b\u0003\t9WM\u0003\u0002\f\u0019\u0005)Qn^1sK*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003+\u0011\tA!\u001e;jY&\u0011qC\u0005\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001")
public class SelectivityTest
extends CypherFunSuite {
    public SelectivityTest() {
        this.test("negating a selectivity behaves as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(((Selectivity)Selectivity$.MODULE$.of(0.1).get()).negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((Selectivity)Selectivity$.MODULE$.of(5.6E-17).get()).negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((Selectivity)Selectivity$.MODULE$.of(1.0E-300).get()).negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ZERO().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ZERO().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ONE()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ONE().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ZERO()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.ONE().negate()).should(this.$outer.equal(Selectivity$.MODULE$.ZERO()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(Selectivity$.MODULE$.CLOSEST_TO_ONE().negate()).should(this.$outer.not()).equal((Object)Selectivity$.MODULE$.ONE(), Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("selectivity and cardinality should not be able to produce NaN or Infinity through multiplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SelectivityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new Cardinality(Double.POSITIVE_INFINITY).$times(Selectivity$.MODULE$.ZERO())).should(this.$outer.equal(Cardinality$.MODULE$.EMPTY()), (Object)Equality$.MODULE$.default());
                Cardinality maxCardinality = new Cardinality(Double.MAX_VALUE);
                this.$outer.convertToAnyShouldWrapper(new Cardinality(Double.POSITIVE_INFINITY).$times(Cardinality$.MODULE$.SINGLE())).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new Cardinality(Double.POSITIVE_INFINITY).$times(new Cardinality(12.0))).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(maxCardinality.$times(new Cardinality(1.00001))).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new Cardinality(3223143.0).$up(50)).should(this.$outer.equal(maxCardinality), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

