/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.cypher.internal.ir;

import com.mware.ge.cypher.internal.ir.InterestingOrder;
import com.mware.ge.cypher.internal.ir.InterestingOrder$;
import com.mware.ge.cypher.internal.ir.ProvidedOrder;
import com.mware.ge.cypher.internal.ir.ProvidedOrder$;
import com.mware.ge.cypher.internal.util.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001f\t\t\u0002K]8wS\u0012,Gm\u0014:eKJ$Vm\u001d;\u000b\u0005\r!\u0011AA5s\u0015\t)a!\u0001\u0005j]R,'O\\1m\u0015\t9\u0001\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u0013)\t!aZ3\u000b\u0005-a\u0011!B7xCJ,'\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0013\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002")
public class ProvidedOrderTest
extends CypherFunSuite {
    public ProvidedOrderTest() {
        this.test("should append provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProvidedOrder left = ProvidedOrder$.MODULE$.asc("a").asc("b");
                ProvidedOrder right = ProvidedOrder$.MODULE$.asc("c").asc("d");
                this.$outer.convertToAnyShouldWrapper(left.followedBy(right).columns()).should(this.$outer.be().apply(left.columns().$plus$plus((GenTraversableOnce)right.columns(), Seq$.MODULE$.canBuildFrom())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should append empty provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProvidedOrder left = ProvidedOrder$.MODULE$.asc("a").asc("b");
                ProvidedOrder right = ProvidedOrder$.MODULE$.empty();
                this.$outer.convertToAnyShouldWrapper(left.followedBy(right).columns()).should(this.$outer.be().apply((Object)left.columns()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("when provided order is empty the result combined provided order should always be empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProvidedOrder left = ProvidedOrder$.MODULE$.empty();
                ProvidedOrder right = ProvidedOrder$.MODULE$.asc("c").asc("d");
                ProvidedOrder empty = ProvidedOrder$.MODULE$.empty();
                this.$outer.convertToAnyShouldWrapper(left.followedBy(right).columns()).should(this.$outer.be().apply((Object)Seq$.MODULE$.empty()));
                this.$outer.convertToAnyShouldWrapper(left.followedBy(empty).columns()).should(this.$outer.be().apply((Object)Seq$.MODULE$.empty()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should trim provided order to before any matching function arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProvidedOrder left = ProvidedOrder$.MODULE$.asc("a").asc("b").asc("c").asc("d");
                this.$outer.convertToAnyShouldWrapper(left.upToExcluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).columns()).should(this.$outer.be().apply((Object)left.columns()));
                this.$outer.convertToAnyShouldWrapper(left.upToExcluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).columns()).should(this.$outer.be().apply((Object)Seq$.MODULE$.empty()));
                this.$outer.convertToAnyShouldWrapper(left.upToExcluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).columns()).should(this.$outer.be().apply(left.columns().slice(0, 2)));
                this.$outer.convertToAnyShouldWrapper(ProvidedOrder$.MODULE$.empty().upToExcluding((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).columns()).should(this.$outer.be().apply((Object)Seq$.MODULE$.empty()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Empty required order satisfied by anything", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.empty().satisfiedBy(ProvidedOrder$.MODULE$.empty()))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.empty().satisfiedBy(ProvidedOrder$.MODULE$.asc("x")))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.empty().satisfiedBy(ProvidedOrder$.MODULE$.desc("x")))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.empty().satisfiedBy(ProvidedOrder$.MODULE$.asc("x").asc("y")))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.empty().satisfiedBy(ProvidedOrder$.MODULE$.desc("x").desc("y")))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Single property required order satisfied by matching provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.asc("x").satisfiedBy(ProvidedOrder$.MODULE$.asc("x")))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Single property required order satisfied by longer provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.asc("x").satisfiedBy(ProvidedOrder$.MODULE$.asc("x").asc("y")))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.asc("x").satisfiedBy(ProvidedOrder$.MODULE$.asc("x").desc("y")))).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Single property required order not satisfied by mismatching provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.asc("x").satisfiedBy(ProvidedOrder$.MODULE$.asc("y")))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.asc("x").satisfiedBy(ProvidedOrder$.MODULE$.desc("x")))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)InterestingOrder$.MODULE$.asc("x").satisfiedBy(ProvidedOrder$.MODULE$.asc("y").asc("x")))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Multi property required order satisfied only be matching provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProvidedOrderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InterestingOrder interestingOrder = InterestingOrder$.MODULE$.asc("x").desc("y").asc("z");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)interestingOrder.satisfiedBy(ProvidedOrder$.MODULE$.asc("x")))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)interestingOrder.satisfiedBy(ProvidedOrder$.MODULE$.asc("x").desc("y")))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)interestingOrder.satisfiedBy(ProvidedOrder$.MODULE$.asc("x").desc("y").asc("z")))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)interestingOrder.satisfiedBy(ProvidedOrder$.MODULE$.asc("x").desc("z").asc("y")))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)interestingOrder.satisfiedBy(ProvidedOrder$.MODULE$.asc("x").desc("y").desc("z")))).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)interestingOrder.satisfiedBy(ProvidedOrder$.MODULE$.asc("x").asc("y").desc("z")))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

