/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.IncreasingTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IncreasingTimeTest {
    private static final int NUM_ITERATIONS = 1000;
    private static final int NUM_THREADS = 10;

    @Test
    public void currentTimeMillisReturnsEverIncreasingTime() {
        ArrayList<Long> times = new ArrayList<Long>(1000);
        for (int i = 0; i < 1000; ++i) {
            times.add(IncreasingTime.currentTimeMillis());
        }
        IncreasingTimeTest.assertIncreasingTimes(1000, times);
    }

    @Test
    public void currentTimeMillisReturnsTimeGreaterThanSystemTime() {
        for (int i = 0; i < 1000; ++i) {
            long systemTime = System.currentTimeMillis();
            long increasedTime = IncreasingTime.currentTimeMillis();
            Assert.assertTrue((increasedTime > systemTime ? 1 : 0) != 0);
        }
    }

    @Test
    public void currentTimeMillisReturnsEverIncreasingTimeAcrossConcurrentThreads() throws Exception {
        final List<Long> times = Collections.synchronizedList(new ArrayList(1000));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 1000; ++i) {
                        times.add(IncreasingTime.currentTimeMillis());
                    }
                }
            });
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join(5000L);
        }
        Collections.sort(times);
        IncreasingTimeTest.assertIncreasingTimes(10000, times);
    }

    private static void assertIncreasingTimes(int expectedSize, List<Long> times) {
        Assert.assertEquals((long)expectedSize, (long)new HashSet<Long>(times).size());
        long last = times.get(0) - 1L;
        for (long time : times) {
            Assert.assertTrue((time == last + 1L ? 1 : 0) != 0);
            last = time;
        }
    }
}

