/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.AutoDeleteFileInputStream;
import com.mware.ge.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AutoDeleteFileInputStreamTest {
    private File file;

    @After
    public void after() {
        this.file.delete();
    }

    @Test
    public void existingFileShouldBeDeletedWhenStreamIsClosed() throws IOException {
        this.file = File.createTempFile(this.getClass().getSimpleName(), null);
        this.file.deleteOnExit();
        AutoDeleteFileInputStream adFileInputStream = new AutoDeleteFileInputStream(this.file);
        Assert.assertTrue((boolean)this.file.exists());
        adFileInputStream.close();
        Assert.assertFalse((boolean)this.file.exists());
    }

    @Test
    public void tempFileForStreamShouldBeDeletedWhenStreamIsClosed() throws IOException {
        String content = "stuff";
        final boolean[] baClosed = new boolean[]{false};
        ByteArrayInputStream baInputStream = new ByteArrayInputStream("stuff".getBytes()){

            @Override
            public void close() throws IOException {
                super.close();
                baClosed[0] = true;
            }
        };
        AutoDeleteFileInputStream adFileInputStream = new AutoDeleteFileInputStream((InputStream)baInputStream);
        this.file = adFileInputStream.getFile();
        Assert.assertTrue((boolean)baClosed[0]);
        Assert.assertTrue((boolean)this.file.exists());
        Assert.assertEquals((Object)"stuff", (Object)IOUtils.toString((InputStream)adFileInputStream));
        adFileInputStream.close();
        Assert.assertFalse((boolean)this.file.exists());
    }
}

