/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoRect;
import com.mware.ge.type.GeoShape;
import org.junit.Assert;
import org.junit.Test;

public class GeoRectTest {
    @Test
    public void testIntersects() {
        GeoRect rect1 = new GeoRect(new GeoPoint(10.0, 0.0), new GeoPoint(0.0, 10.0));
        GeoRect rect2 = new GeoRect(new GeoPoint(5.0, 0.0), new GeoPoint(0.0, 5.0));
        Assert.assertTrue((boolean)rect1.intersects((GeoShape)rect2));
        Assert.assertTrue((boolean)rect2.intersects((GeoShape)rect1));
        rect2 = new GeoRect(new GeoPoint(15.0, 0.0), new GeoPoint(11.0, 5.0));
        Assert.assertFalse((boolean)rect1.intersects((GeoShape)rect2));
        Assert.assertFalse((boolean)rect2.intersects((GeoShape)rect1));
        rect2 = new GeoRect(new GeoPoint(2.0, -4.0), new GeoPoint(-2.0, -2.0));
        Assert.assertFalse((boolean)rect1.intersects((GeoShape)rect2));
        Assert.assertFalse((boolean)rect2.intersects((GeoShape)rect1));
        Assert.assertTrue((boolean)rect1.intersects((GeoShape)new GeoPoint(5.0, 5.0)));
        Assert.assertFalse((boolean)rect1.intersects((GeoShape)new GeoPoint(11.0, 11.0)));
        Assert.assertTrue((boolean)rect1.intersects((GeoShape)new GeoLine(new GeoPoint(1.0, 1.0), new GeoPoint(9.0, 9.0))));
        Assert.assertTrue((boolean)rect1.intersects((GeoShape)new GeoLine(new GeoPoint(-1.0, -1.0), new GeoPoint(11.0, 11.0))));
        Assert.assertFalse((boolean)rect1.intersects((GeoShape)new GeoLine(new GeoPoint(11.0, 11.0), new GeoPoint(12.0, 12.0))));
    }

    @Test
    public void testWithin() {
        GeoRect rect1 = new GeoRect(new GeoPoint(10.0, 0.0), new GeoPoint(0.0, 10.0));
        GeoRect rect2 = new GeoRect(new GeoPoint(5.0, 1.0), new GeoPoint(1.0, 5.0));
        Assert.assertFalse((boolean)rect1.within((GeoShape)rect2));
        Assert.assertTrue((boolean)rect2.within((GeoShape)rect1));
        rect2 = new GeoRect(new GeoPoint(15.0, 0.0), new GeoPoint(11.0, 5.0));
        Assert.assertFalse((boolean)rect1.within((GeoShape)rect2));
        Assert.assertFalse((boolean)rect2.within((GeoShape)rect1));
        rect2 = new GeoRect(new GeoPoint(2.0, -4.0), new GeoPoint(-2.0, -2.0));
        Assert.assertFalse((boolean)rect1.within((GeoShape)rect2));
        Assert.assertFalse((boolean)rect2.within((GeoShape)rect1));
        Assert.assertFalse((boolean)rect1.within((GeoShape)new GeoPoint(5.0, 5.0)));
        Assert.assertFalse((boolean)rect1.within((GeoShape)new GeoPoint(11.0, 11.0)));
        Assert.assertFalse((boolean)rect1.within((GeoShape)new GeoLine(new GeoPoint(1.0, 1.0), new GeoPoint(9.0, 9.0))));
        Assert.assertFalse((boolean)rect1.within((GeoShape)new GeoLine(new GeoPoint(-1.0, -1.0), new GeoPoint(11.0, 11.0))));
        Assert.assertFalse((boolean)rect1.within((GeoShape)new GeoLine(new GeoPoint(11.0, 11.0), new GeoPoint(12.0, 12.0))));
    }
}

