/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.GeException;
import com.mware.ge.type.GeoCollection;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoPolygon;
import com.mware.ge.type.GeoShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class GeoPolygonTest {
    private static final double[][] VALID_TRIANGLE = new double[][]{{0.0, 0.0}, {2.5, 5.0}, {5.0, 0.0}, {0.0, 0.0}};
    private static final double[][] INVALID_UNCLOSED_SQUARE = new double[][]{{0.0, 0.0}, {0.0, 5.0}, {5.0, 5.0}, {5.0, 0.0}};
    private static final double[][] INVALID_BOW_TIE_LINE_INTERSECTION = new double[][]{{0.0, 0.0}, {0.0, 5.0}, {5.0, 0.0}, {5.0, 5.0}, {0.0, 0.0}};
    private static final double[][] INVALID_BOW_TIE_REUSED_POINT = new double[][]{{0.0, 0.0}, {2.5, 2.5}, {0.0, 5.0}, {5.0, 5.0}, {2.5, 2.5}, {5.0, 0.0}, {0.0, 0.0}};
    private static final double[][] INVALID_SQUARE_WITH_HOLE_VIA_REUSED_POINT = new double[][]{{0.0, 0.0}, {0.0, 5.0}, {5.0, 5.0}, {5.0, 2.5}, {4.0, 3.0}, {4.0, 2.0}, {5.0, 2.5}, {5.0, 0.0}, {0.0, 0.0}};
    private static final double[][] INVALID_CLOCKWISE_TRIANGLE = new double[][]{{0.0, 0.0}, {5.0, 0.0}, {2.5, 5.0}, {0.0, 0.0}};

    @Test
    public void testValid() {
        GeoPolygon polygon = this.createPolygon(VALID_TRIANGLE);
        polygon.validate();
    }

    @Test
    public void testInvalidClockwiseOuterShell() {
        try {
            this.createPolygon(INVALID_CLOCKWISE_TRIANGLE);
            Assert.fail((String)"Expected a validation error");
        }
        catch (GeException geException) {
            // empty catch block
        }
        GeoShape lenientPolygon = this.createLenient(INVALID_CLOCKWISE_TRIANGLE);
        lenientPolygon.validate();
        Assert.assertEquals(GeoPolygon.class, lenientPolygon.getClass());
        double[][] counterClockwistTriangle = (double[][])INVALID_CLOCKWISE_TRIANGLE.clone();
        ArrayUtils.reverse((Object[])counterClockwistTriangle);
        Assert.assertEquals(this.createGeoPoints(counterClockwistTriangle, new double[0][]), (Object)((GeoPolygon)lenientPolygon).getOuterBoundary());
    }

    @Test
    public void testInvalidReusedPointOnConcaveShape() {
        try {
            this.createPolygon(INVALID_SQUARE_WITH_HOLE_VIA_REUSED_POINT);
            Assert.fail((String)"Expected a validation error");
        }
        catch (GeException geException) {
            // empty catch block
        }
        GeoShape lenientPolygon = this.createLenient(INVALID_SQUARE_WITH_HOLE_VIA_REUSED_POINT);
        lenientPolygon.validate();
        Assert.assertEquals(GeoPolygon.class, lenientPolygon.getClass());
        Assert.assertEquals(this.createGeoPoints(new double[][]{{0.0, 0.0}, {0.0, 5.0}, {5.0, 5.0}, {5.0, 2.5}, {5.0, 0.0}, {0.0, 0.0}}, new double[0][]), (Object)((GeoPolygon)lenientPolygon).getOuterBoundary());
        Assert.assertEquals((long)1L, (long)((GeoPolygon)lenientPolygon).getHoles().size());
        Assert.assertEquals(this.createGeoPoints(new double[][]{{4.0, 2.0}, {5.0, 2.5}, {4.0, 3.0}, {4.0, 2.0}}, new double[0][]), ((GeoPolygon)lenientPolygon).getHoles().get(0));
    }

    @Test
    public void testInvalidReusedPointOnConvexShape() {
        try {
            this.createPolygon(INVALID_BOW_TIE_REUSED_POINT);
            Assert.fail((String)"Expected a validation error");
        }
        catch (GeException geException) {
            // empty catch block
        }
        GeoShape lenientPolygon = this.createLenient(INVALID_BOW_TIE_REUSED_POINT);
        lenientPolygon.validate();
        Assert.assertEquals(GeoCollection.class, lenientPolygon.getClass());
        List geoCollection = ((GeoCollection)lenientPolygon).getGeoShapes();
        Assert.assertEquals((long)2L, (long)geoCollection.size());
        Assert.assertEquals(this.createGeoPoints(new double[][]{{0.0, 0.0}, {2.5, 2.5}, {5.0, 0.0}, {0.0, 0.0}}, new double[0][]), (Object)((GeoPolygon)geoCollection.get(0)).getOuterBoundary());
        Assert.assertEquals((long)0L, (long)((GeoPolygon)geoCollection.get(0)).getHoles().size());
        Assert.assertEquals(this.createGeoPoints(new double[][]{{2.5, 2.5}, {0.0, 5.0}, {5.0, 5.0}, {2.5, 2.5}}, new double[0][]), (Object)((GeoPolygon)geoCollection.get(1)).getOuterBoundary());
        Assert.assertEquals((long)0L, (long)((GeoPolygon)geoCollection.get(1)).getHoles().size());
    }

    @Test
    public void testInvalidLineIntersection() {
        try {
            this.createPolygon(INVALID_BOW_TIE_LINE_INTERSECTION);
            Assert.fail((String)"Expected a validation error");
        }
        catch (GeException geException) {
            // empty catch block
        }
        GeoShape lenientPolygon = this.createLenient(INVALID_BOW_TIE_LINE_INTERSECTION);
        lenientPolygon.validate();
        Assert.assertEquals(GeoPolygon.class, lenientPolygon.getClass());
        Assert.assertEquals(this.createGeoPoints(new double[][]{{5.0, 0.0}, {2.5, 2.5}, {5.0, 5.0}, {5.0, 0.0}}, new double[0][]), (Object)((GeoPolygon)lenientPolygon).getOuterBoundary());
        Assert.assertEquals((long)0L, (long)((GeoPolygon)lenientPolygon).getHoles().size());
    }

    @Test
    public void testInvalidUnclosedOuterShell() {
        try {
            this.createPolygon(INVALID_UNCLOSED_SQUARE);
            Assert.fail((String)"Expected a validation error");
        }
        catch (GeException geException) {
            // empty catch block
        }
        GeoShape lenientPolygon = this.createLenient(INVALID_UNCLOSED_SQUARE);
        lenientPolygon.validate();
        Assert.assertEquals(GeoPolygon.class, lenientPolygon.getClass());
        Assert.assertEquals(this.createGeoPoints(INVALID_UNCLOSED_SQUARE, new double[][]{INVALID_UNCLOSED_SQUARE[0]}), (Object)((GeoPolygon)lenientPolygon).getOuterBoundary());
        Assert.assertEquals((long)0L, (long)((GeoPolygon)lenientPolygon).getHoles().size());
    }

    private GeoPolygon createPolygon(double[][] latLons) {
        List<GeoPoint> points = this.createGeoPoints(latLons, new double[0][]);
        return new GeoPolygon(points);
    }

    private GeoShape createLenient(double[][] latLons) {
        List<GeoPoint> points = this.createGeoPoints(latLons, new double[0][]);
        return GeoPolygon.createLenient(points);
    }

    private List<GeoPoint> createGeoPoints(double[][] latLons, double[] ... extraLatLons) {
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>();
        for (double[] latLon : latLons) {
            points.add(new GeoPoint(latLon[0], latLon[1]));
        }
        for (double[] extraLatLon : extraLatLons) {
            points.add(new GeoPoint(extraLatLon[0], extraLatLon[1]));
        }
        return points;
    }

    @Test
    public void testWithin() {
        GeoPolygon geoPolygonWithHole = new GeoPolygon(Arrays.asList(new GeoPoint(0.0, 0.0), new GeoPoint(0.0, 10.0), new GeoPoint(5.0, 10.0), new GeoPoint(10.0, 5.0), new GeoPoint(5.0, 0.0), new GeoPoint(0.0, 0.0)), Arrays.asList(Arrays.asList(new GeoPoint(1.0, 3.0), new GeoPoint(5.0, 3.0), new GeoPoint(5.0, 7.0), new GeoPoint(1.0, 7.0), new GeoPoint(1.0, 3.0))));
        Assert.assertTrue((boolean)new GeoPoint(6.0, 5.0).within((GeoShape)geoPolygonWithHole));
        Assert.assertFalse((boolean)new GeoPoint(3.0, 5.0).within((GeoShape)geoPolygonWithHole));
        Assert.assertFalse((boolean)new GeoPoint(11.0, 5.0).within((GeoShape)geoPolygonWithHole));
        Assert.assertTrue((boolean)new GeoLine(new GeoPoint(6.0, 4.0), new GeoPoint(6.0, 6.0)).within((GeoShape)geoPolygonWithHole));
        Assert.assertFalse((boolean)new GeoLine(new GeoPoint(3.0, 4.0), new GeoPoint(3.0, 6.0)).within((GeoShape)geoPolygonWithHole));
        Assert.assertFalse((boolean)new GeoLine(new GeoPoint(11.0, 4.0), new GeoPoint(11.0, 6.0)).within((GeoShape)geoPolygonWithHole));
        Assert.assertFalse((boolean)new GeoLine(new GeoPoint(9.0, 0.0), new GeoPoint(9.0, 10.0)).within((GeoShape)geoPolygonWithHole));
    }
}

