/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.google.common.collect.Lists;
import com.mware.ge.GeException;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoRect;
import com.mware.ge.type.GeoShape;
import com.mware.ge.type.GeoUtils;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GeoPointTest {
    @Test
    public void testParse() throws Exception {
        Assert.assertEquals((Object)new GeoPoint(38.9283, -77.1753), (Object)GeoPoint.parse((String)"38.9283, -77.1753"));
        Assert.assertEquals((Object)new GeoPoint(38.9283, -77.1753, 500.0), (Object)GeoPoint.parse((String)"38.9283, -77.1753, 500"));
        Assert.assertEquals((Object)new GeoPoint(38.9283, -77.1753, 500.0, 25.0), (Object)GeoPoint.parse((String)"38.9283, -77.1753, 500, ~25"));
        Assert.assertEquals((Object)new GeoPoint(38.9283, -77.1753, 0.0, 25.0), (Object)GeoPoint.parse((String)"38.9283, -77.1753, ~25"));
        Assert.assertEquals((Object)new GeoPoint(38.9283, -77.1753), (Object)GeoPoint.parse((String)"38\u00b0 55' 41.88\", -77\u00b0 10' 31.0794\""));
        try {
            GeoPoint.parse((String)"38.9283");
            throw new RuntimeException("Expected an exception");
        }
        catch (GeException geException) {
            try {
                GeoPoint.parse((String)"38.9283, -77.1753, 500, 10");
                throw new RuntimeException("Expected an exception");
            }
            catch (GeException geException2) {
                try {
                    GeoPoint.parse((String)"38.9283, -77.1753, ~500, ~10");
                    throw new RuntimeException("Expected an exception");
                }
                catch (GeException geException3) {
                    try {
                        GeoPoint.parse((String)"38.9283, -77.1753, 500, 10, 10");
                        throw new RuntimeException("Expected an exception");
                    }
                    catch (GeException geException4) {
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void testParseWithDescription() throws Exception {
        GeoPoint pt = GeoPoint.parse((String)"38.9283, -77.1753");
        Assert.assertEquals((double)38.9283, (double)pt.getLatitude(), (double)0.001);
        Assert.assertEquals((double)-77.1753, (double)pt.getLongitude(), (double)0.001);
    }

    @Test
    public void testDistanceFrom() {
        GeoPoint p1 = new GeoPoint(38.627, -90.1994);
        GeoPoint p2 = new GeoPoint(39.0438, -77.4874);
        Assert.assertEquals((double)1101.13, (double)p1.distanceFrom(p2), (double)0.01);
    }

    @Test
    public void testDistanceFromOppositeSidesOfEarth() {
        GeoPoint p1 = new GeoPoint(0.0, 0.0);
        GeoPoint p2 = new GeoPoint(0.0, 180.0);
        Assert.assertEquals((double)(GeoUtils.EARTH_CIRCUMFERENCE / 2.0), (double)p1.distanceFrom(p2), (double)0.01);
    }

    @Test
    public void testLongitudinalDistanceTo() {
        GeoPoint topLeft = new GeoPoint(10.0, 0.0);
        GeoPoint bottomRight = new GeoPoint(0.0, 10.0);
        Assert.assertEquals((double)-10.0, (double)topLeft.longitudinalDistanceTo(bottomRight), (double)0.01);
        Assert.assertEquals((double)10.0, (double)bottomRight.longitudinalDistanceTo(topLeft), (double)0.01);
        topLeft = new GeoPoint(10.0, -170.0);
        bottomRight = new GeoPoint(0.0, 170.0);
        Assert.assertEquals((double)-20.0, (double)topLeft.longitudinalDistanceTo(bottomRight), (double)0.01);
        Assert.assertEquals((double)20.0, (double)bottomRight.longitudinalDistanceTo(topLeft), (double)0.01);
    }

    @Test
    public void testCalculateCenter1Points() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0, 100.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1}));
        GeoPoint expected = new GeoPoint(10.0, 20.0, 100.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenter2Points() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0, 100.0);
        GeoPoint pt2 = new GeoPoint(10.1, 20.1, 200.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(10.05, 20.05, 150.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenter2PointsSameLongitude() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0, 100.0);
        GeoPoint pt2 = new GeoPoint(10.1, 20.0, 200.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(10.05, 20.0, 150.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenter2PointsSameLatitude() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0, 100.0);
        GeoPoint pt2 = new GeoPoint(10.0, 20.1, 200.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(10.0, 20.05, 150.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenter2PointsSamePoint() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0);
        GeoPoint pt2 = new GeoPoint(10.0, 20.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(10.0, 20.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenter4Points() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0);
        GeoPoint pt2 = new GeoPoint(20.0, 30.0);
        GeoPoint pt3 = new GeoPoint(0.0, 40.0);
        GeoPoint pt4 = new GeoPoint(40.0, 10.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(15.0546709, 24.88248913);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenterPointsAroundZero() {
        GeoPoint pt1 = new GeoPoint(10.0, 10.0);
        GeoPoint pt2 = new GeoPoint(350.0, 80.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(0.0, 45.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenterPointsOppositeSides() {
        GeoPoint pt1 = new GeoPoint(90.0, 0.0);
        GeoPoint pt2 = new GeoPoint(-90.0, 0.0);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(0.0, 0.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
        pt1 = new GeoPoint(0.0, 0.0);
        pt2 = new GeoPoint(0.0, 180.0);
        center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        expected = new GeoPoint(0.0, 90.0);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testCalculateCenterWithMissingAltitude() {
        GeoPoint pt1 = new GeoPoint(10.0, 20.0, 10.0);
        GeoPoint pt2 = new GeoPoint(10.1, 20.1);
        GeoPoint center = GeoPoint.calculateCenter((List)Lists.newArrayList((Object[])new GeoPoint[]{pt1, pt2}));
        GeoPoint expected = new GeoPoint(10.05, 20.05);
        Assert.assertEquals((String)("distance " + expected.distanceFrom(center) + " > " + 0.001), (Object)expected, (Object)center);
    }

    @Test
    public void testIsSouthEastOf() {
        GeoPoint topLeft = new GeoPoint(10.0, 0.0);
        GeoPoint bottomRight = new GeoPoint(0.0, 10.0);
        Assert.assertFalse((boolean)topLeft.isSouthEastOf(bottomRight));
        Assert.assertTrue((boolean)bottomRight.isSouthEastOf(topLeft));
        topLeft = new GeoPoint(10.0, -170.0);
        bottomRight = new GeoPoint(0.0, 170.0);
        Assert.assertFalse((boolean)topLeft.isSouthEastOf(bottomRight));
        Assert.assertTrue((boolean)bottomRight.isSouthEastOf(topLeft));
    }

    @Test
    public void testIsNorthWestOf() {
        GeoPoint topLeft = new GeoPoint(10.0, 0.0);
        GeoPoint bottomRight = new GeoPoint(0.0, 10.0);
        Assert.assertTrue((boolean)topLeft.isNorthWestOf(bottomRight));
        Assert.assertFalse((boolean)bottomRight.isNorthWestOf(topLeft));
        topLeft = new GeoPoint(10.0, -170.0);
        bottomRight = new GeoPoint(0.0, 170.0);
        Assert.assertTrue((boolean)topLeft.isNorthWestOf(bottomRight));
        Assert.assertFalse((boolean)bottomRight.isNorthWestOf(topLeft));
    }

    @Test
    public void testWithin() {
        GeoRect rect1 = new GeoRect(new GeoPoint(10.0, 0.0), new GeoPoint(0.0, 10.0));
        Assert.assertTrue((boolean)new GeoPoint(5.0, 5.0).within((GeoShape)rect1));
        Assert.assertFalse((boolean)new GeoPoint(11.0, 11.0).within((GeoShape)rect1));
    }
}

