/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.type;

import com.mware.ge.type.GeoCircle;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoRect;
import com.mware.ge.type.GeoShape;
import com.mware.ge.type.GeoUtils;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class GeoCircleTest {
    @Test
    public void testBoundingBox() throws Exception {
        GeoCircle geoCircle = new GeoCircle(38.627, -90.1994, 500.0);
        GeoRect boundingBox = (GeoRect)GeoUtils.getEnvelope((GeoShape)geoCircle);
        Assert.assertEquals((double)43.1236, (double)boundingBox.getNorthWest().getLatitude(), (double)1.0E-4);
        Assert.assertEquals((double)-95.959, (double)boundingBox.getNorthWest().getLongitude(), (double)1.0E-4);
        Assert.assertEquals((double)34.1303, (double)boundingBox.getSouthEast().getLatitude(), (double)1.0E-4);
        Assert.assertEquals((double)-84.4397, (double)boundingBox.getSouthEast().getLongitude(), (double)1.0E-4);
        geoCircle = new GeoCircle(0.0, -179.0, 500.0);
        boundingBox = (GeoRect)GeoUtils.getEnvelope((GeoShape)geoCircle);
        Assert.assertEquals((double)4.4966, (double)boundingBox.getNorthWest().getLatitude(), (double)1.0E-4);
        Assert.assertEquals((double)176.5033, (double)boundingBox.getNorthWest().getLongitude(), (double)1.0E-4);
        Assert.assertEquals((double)-4.4966, (double)boundingBox.getSouthEast().getLatitude(), (double)1.0E-4);
        Assert.assertEquals((double)-174.5033, (double)boundingBox.getSouthEast().getLongitude(), (double)1.0E-4);
    }

    @Test
    public void testWithin() {
        GeoCircle geoCircle = new GeoCircle(5.0, 5.0, 500.0);
        Assert.assertTrue((boolean)new GeoRect(new GeoPoint(7.0, 2.0), new GeoPoint(2.0, 7.0)).within((GeoShape)geoCircle));
        Assert.assertFalse((boolean)new GeoRect(new GeoPoint(10.0, 0.0), new GeoPoint(0.0, 10.0)).within((GeoShape)geoCircle));
        Assert.assertTrue((boolean)new GeoCircle(5.0, 5.0, 400.0).within((GeoShape)geoCircle));
        Assert.assertFalse((boolean)new GeoCircle(5.0, 5.0, 600.0).within((GeoShape)geoCircle));
        Assert.assertTrue((boolean)new GeoCircle(3.0, 3.0, 100.0).within((GeoShape)geoCircle));
        Assert.assertFalse((boolean)new GeoCircle(3.0, 3.0, 300.0).within((GeoShape)geoCircle));
        Assert.assertTrue((boolean)new GeoLine(Arrays.asList(new GeoPoint(7.0, 2.0), new GeoPoint(2.0, 7.0))).within((GeoShape)geoCircle));
        Assert.assertFalse((boolean)new GeoLine(Arrays.asList(new GeoPoint(0.0, 2.0), new GeoPoint(2.0, 7.0))).within((GeoShape)geoCircle));
    }
}

