/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.tools;

import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Graph;
import com.mware.ge.GraphFactory;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.id.LongIdGenerator;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.search.DefaultSearchIndex;
import com.mware.ge.tools.GraphBackup;
import com.mware.ge.tools.GraphRestore;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LargeStringInputStream;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BackupRestoreTest {
    public final Authorizations AUTHORIZATIONS_A = this.createAuthorizations("a");
    public final Authorizations AUTHORIZATIONS_B = this.createAuthorizations("b");
    public final Authorizations AUTHORIZATIONS_C = this.createAuthorizations("c");
    public final Authorizations AUTHORIZATIONS_A_AND_B = this.createAuthorizations("a", "b");

    private Authorizations createAuthorizations(String ... auths) {
        return new Authorizations(auths);
    }

    protected Graph createGraph() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("", InMemoryGraph.class.getName());
        config.put("idgenerator", LongIdGenerator.class.getName());
        config.put("search", DefaultSearchIndex.class.getName());
        return new GraphFactory().createGraph(config);
    }

    @Test
    public void testSaveAndLoad() throws IOException, ClassNotFoundException {
        Graph graph = this.createGraph();
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("metadata1", (Value)Values.stringValue((String)"metadata1Value"), GraphTestSetup.VISIBILITY_A);
        int largePropertyValueSize = 1000;
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(largePropertyValueSize));
        StreamingPropertyValue largeDataValue = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), StringValue.class);
        Vertex v1 = (Vertex)graph.prepareVertex("v1", GraphTestSetup.VISIBILITY_A, "thing").addPropertyValue("id1a", "prop1", (Value)Values.stringValue((String)"value1a"), prop1Metadata, GraphTestSetup.VISIBILITY_A).addPropertyValue("id1b", "prop1", (Value)Values.stringValue((String)"value1b"), GraphTestSetup.VISIBILITY_A).addPropertyValue("id2", "prop2", (Value)Values.stringValue((String)"value2"), GraphTestSetup.VISIBILITY_B).setProperty("largeData", (Value)largeDataValue, GraphTestSetup.VISIBILITY_A).save(this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = graph.addVertex("v2", GraphTestSetup.VISIBILITY_A, this.AUTHORIZATIONS_A, "thing");
        Vertex v3 = graph.addVertex("v3", GraphTestSetup.VISIBILITY_B, this.AUTHORIZATIONS_B, "thing");
        graph.addEdge("e1to2", v1, v2, "label1", GraphTestSetup.VISIBILITY_A, this.AUTHORIZATIONS_A);
        graph.addEdge("e1to3", v1, v3, "label1", GraphTestSetup.VISIBILITY_B, this.AUTHORIZATIONS_B);
        File tmp = File.createTempFile(this.getClass().getName(), ".json");
        try (FileOutputStream out = new FileOutputStream(tmp);){
            System.out.println("saving graph to: " + tmp);
            GraphBackup graphBackup = new GraphBackup();
            graphBackup.save(graph, (OutputStream)out, this.AUTHORIZATIONS_A_AND_B);
        }
        var11_11 = null;
        try (FileInputStream in = new FileInputStream(tmp);){
            Graph loadedGraph = this.createGraph();
            GraphRestore graphRestore = new GraphRestore();
            graphRestore.restore(loadedGraph, (InputStream)in, this.AUTHORIZATIONS_A_AND_B, 0L);
            Assert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)loadedGraph.getVertices(this.AUTHORIZATIONS_A_AND_B)));
            Assert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)loadedGraph.getVertices(this.AUTHORIZATIONS_A)));
            Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)loadedGraph.getVertices(this.AUTHORIZATIONS_B)));
            Assert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)loadedGraph.getEdges(this.AUTHORIZATIONS_A_AND_B)));
            Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)loadedGraph.getEdges(this.AUTHORIZATIONS_A)));
            Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)loadedGraph.getEdges(this.AUTHORIZATIONS_B)));
            v1 = loadedGraph.getVertex("v1", this.AUTHORIZATIONS_A_AND_B);
            Assert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
            Iterable properties = v1.getProperties();
            boolean prop1_id1a_found = false;
            boolean prop1_id1b_found = false;
            for (Property property : properties) {
                if (!property.getName().equals("prop1")) continue;
                if (property.getKey().equals("id1a")) {
                    prop1_id1a_found = true;
                    Assert.assertEquals((Object)Values.stringValue((String)"value1a"), (Object)property.getValue());
                }
                if (!property.getKey().equals("id1b")) continue;
                prop1_id1b_found = true;
                Assert.assertEquals((Object)Values.stringValue((String)"value1b"), (Object)property.getValue());
            }
            Assert.assertTrue((String)"prop1[id1a] not found", (boolean)prop1_id1a_found);
            Assert.assertTrue((String)"prop1[id1b] not found", (boolean)prop1_id1b_found);
            Assert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)v1.getPropertyValue("prop2", 0));
            StreamingPropertyValue spv = (StreamingPropertyValue)v1.getPropertyValue("largeData", 0);
            Assert.assertNotNull((String)"largeData property not found", (Object)spv);
            Assert.assertEquals(StringValue.class, (Object)spv.getValueType());
            Assert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)spv.getInputStream()));
            v2 = loadedGraph.getVertex("v2", this.AUTHORIZATIONS_A_AND_B);
            Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v2.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
            v3 = loadedGraph.getVertex("v3", this.AUTHORIZATIONS_A_AND_B);
            Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v3.getEdges(Direction.BOTH, this.AUTHORIZATIONS_A_AND_B)));
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        tmp.delete();
    }
}

