/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.serializer;

import com.mware.ge.serializer.GeSerializer;
import com.mware.ge.serializer.kryo.quickSerializers.QuickKryoGeSerializer;
import com.mware.ge.type.GeoCircle;
import com.mware.ge.type.GeoHash;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoPolygon;
import com.mware.ge.type.GeoRect;
import com.mware.ge.util.GeAssert;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import org.junit.Test;

public class QuickKryoSerializerTest {
    GeSerializer geSerializer = new QuickKryoGeSerializer(false);

    @Test
    public void testValues() {
        this.test((Value)Values.booleanValue((boolean)true));
        this.test((Value)Values.booleanArray((boolean[])new boolean[]{true, false, true, false, true, true}));
        this.test((Value)Values.byteValue((byte)18));
        this.test((Value)Values.byteArray((byte[])"Marry had a little lamb".getBytes()));
        this.test((Value)Values.charValue((char)'y'));
        this.test((Value)Values.charArray((char[])"Marry had a little lamb".toCharArray()));
        this.test((Value)Values.doubleValue((double)3.49083454522283E12));
        this.test((Value)Values.doubleArray((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 2.098409234203123E9, 3.908903845210923E10}));
        this.test((Value)Values.floatValue((float)3.4908346E8f));
        this.test((Value)Values.floatArray((float[])new float[]{Float.MAX_VALUE, Float.MIN_VALUE, 203434.23f, 3045345.0f}));
        this.test((Value)Values.intValue((int)3904851));
        this.test((Value)Values.intArray((int[])new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, 290348234, 2987123, 13214, 343456, 46456}));
        this.test((Value)Values.shortValue((short)334));
        this.test((Value)Values.shortArray((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, 123, 343, 11, 5, 55, 33}));
        this.test((Value)Values.longValue((long)0x2C4CC2L));
        this.test((Value)Values.longArray((long[])new long[]{Long.MAX_VALUE, Long.MIN_VALUE, 903234L, 29034934L, 12093213L, 9012839018203923L}));
        this.test((Value)Values.stringValue((String)"Marry had a little lamb"));
        this.test((Value)Values.stringArray((String[])new String[]{"Marry had a little lamb", "Flavius has a little dog", "John had a little kitty"}));
        this.test(Values.temporalValue((Temporal)ZonedDateTime.now()));
        this.test(Values.temporalValue((Temporal)ZonedDateTime.now(ZoneOffset.ofHours(4))));
        this.test(Values.temporalValue((Temporal)OffsetDateTime.now()));
        this.test((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{ZonedDateTime.now(), ZonedDateTime.now().plusDays(1L), ZonedDateTime.now().plusMinutes(5L), ZonedDateTime.now().plusNanos(12L)}));
        this.test(Values.temporalValue((Temporal)LocalDate.now()));
        this.test((Value)Values.dateArray((LocalDate[])new LocalDate[]{LocalDate.now(), LocalDate.now().plusDays(1L), LocalDate.now().plusMonths(1L), LocalDate.now().plusYears(1L)}));
        this.test(Values.temporalValue((Temporal)LocalDateTime.now()));
        this.test((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{LocalDateTime.now(), LocalDateTime.now().plusDays(1L), LocalDateTime.now().plusMonths(5L)}));
        this.test(Values.temporalValue((Temporal)LocalTime.now()));
        this.test((Value)Values.localTimeArray((LocalTime[])new LocalTime[]{LocalTime.now(), LocalTime.now().plusHours(5L), LocalTime.now().plusMinutes(11L), LocalTime.now().plusSeconds(33L)}));
        this.test(Values.temporalValue((Temporal)OffsetTime.now()));
        this.test((Value)Values.timeArray((OffsetTime[])new OffsetTime[]{OffsetTime.now(), OffsetTime.now().plusHours(1L), OffsetTime.now().plusSeconds(55L), OffsetTime.now().plusMinutes(5L)}));
        this.test((Value)Values.geoPointValue((GeoPoint)new GeoPoint(11.11, 12.12, 13.13, 14.14)));
        this.test((Value)Values.geoCircleValue((GeoCircle)new GeoCircle(11.11, 12.12, 13.13)));
        this.test((Value)Values.geoLineValue((GeoLine)new GeoLine(new GeoPoint(11.0, 8.0), new GeoPoint(8.0, 11.0))));
        this.test((Value)Values.geoRectValue((GeoRect)new GeoRect(new GeoPoint(2.0, -4.0), new GeoPoint(-2.0, -2.0))));
        this.test((Value)Values.geoHashValue((GeoHash)new GeoHash(48.669, -4.329, 5)));
        GeoPolygon geoPolygonWithHole = new GeoPolygon(Arrays.asList(new GeoPoint(0.0, 0.0), new GeoPoint(0.0, 10.0), new GeoPoint(5.0, 10.0), new GeoPoint(10.0, 5.0), new GeoPoint(5.0, 0.0), new GeoPoint(0.0, 0.0)), Arrays.asList(Arrays.asList(new GeoPoint(1.0, 3.0), new GeoPoint(5.0, 3.0), new GeoPoint(5.0, 7.0), new GeoPoint(1.0, 7.0), new GeoPoint(1.0, 3.0))));
        this.test((Value)Values.geoPolygonValue((GeoPolygon)geoPolygonWithHole));
    }

    private void test(Value sourceValue) {
        Value targetValue = (Value)this.geSerializer.bytesToObject(this.geSerializer.objectToBytes((Object)sourceValue));
        GeAssert.assertEquals((Object)sourceValue, (Object)targetValue);
    }
}

