/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.mutation;

import com.mware.ge.Authorizations;
import com.mware.ge.Element;
import com.mware.ge.FetchHints;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutationImpl;
import com.mware.ge.property.MutablePropertyImpl;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExistingElementMutationImplTest {
    private TestExistingElementMutationImpl mutation;
    @Mock
    private Element element;

    @Before
    public void before() {
        Mockito.when((Object)this.element.getFetchHints()).thenReturn((Object)FetchHints.ALL);
        this.mutation = new TestExistingElementMutationImpl<Element>(this.element);
    }

    @Test
    public void testEmptyMutationHasChanges() {
        Assert.assertFalse((String)"should not have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesProperties() {
        this.mutation.addPropertyValue("key1", "name1", (Value)Values.stringValue((String)"Hello"), new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesDeleteProperty() {
        this.mutation.deleteProperty((Property)new MutablePropertyImpl("key1", "name1", (Value)Values.stringValue((String)"value"), null, null, null, new Visibility(""), FetchHints.ALL));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesSoftDeleteProperty() {
        this.mutation.softDeleteProperty((Property)new MutablePropertyImpl("key1", "name1", (Value)Values.stringValue((String)"value"), null, null, null, new Visibility(""), FetchHints.ALL));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesNewElementVisibility() {
        this.mutation.alterElementVisibility(new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesAlterPropertyVisibility() {
        this.mutation.alterPropertyVisibility("key1", "name1", new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    @Test
    public void testHasChangesSetPropertyMetadata() {
        this.mutation.setPropertyMetadata("key1", "name1", (Value)Values.stringValue((String)"value"), new Visibility(""));
        Assert.assertTrue((String)"should have changes", (boolean)this.mutation.hasChanges());
    }

    private static class TestExistingElementMutationImpl<T extends Element>
    extends ExistingElementMutationImpl<T> {
        public TestExistingElementMutationImpl(T element) {
            super(element);
        }

        public T save(Authorizations authorizations) {
            return null;
        }
    }
}

