/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.inmemory;

import com.mware.ge.GeTypeException;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphBaseTests;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.base.TestGraphFactory;
import com.mware.ge.inmemory.InMemoryGraph;
import com.mware.ge.inmemory.InMemoryGraphFactory;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryBaseTests
extends GraphBaseTests
implements GraphTestSetup {
    @Override
    public TestGraphFactory graphFactory() {
        return new InMemoryGraphFactory();
    }

    @Test
    public void testStrictTyping() {
        Map<String, String> config = InMemoryGraphFactory.createConfig();
        config.put("strictTyping", "true");
        InMemoryGraph g = InMemoryGraph.create(config);
        g.defineProperty("prop1").dataType(TextValue.class).define();
        Vertex v = g.addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        v.addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A, AUTHORIZATIONS_A);
        try {
            v.addPropertyValue("k1", "prop2", (Value)Values.stringValue((String)"value1"), VISIBILITY_A, AUTHORIZATIONS_A);
            throw new RuntimeException("Expected a type exception");
        }
        catch (GeTypeException ex) {
            Assert.assertEquals((Object)"prop2", (Object)ex.getName());
            Assert.assertEquals((Object)"StringWrappingStringValue", (Object)ex.getValueClass().getSimpleName());
            return;
        }
    }
}

