/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.Authorizations;
import com.mware.ge.ElementId;
import com.mware.ge.ElementType;
import com.mware.ge.GeNotSupportedException;
import com.mware.ge.Graph;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.base.TestGraphFactory;
import com.mware.ge.query.DefaultGraphQuery;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.TermsAggregation;
import com.mware.ge.query.aggregations.TermsBucket;
import com.mware.ge.query.aggregations.TermsResult;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.runners.model.Statement;

public interface GraphTestSetup {
    public static final String VISIBILITY_A_STRING = "a";
    public static final String VISIBILITY_B_STRING = "b";
    public static final String VISIBILITY_C_STRING = "c";
    public static final String VISIBILITY_MIXED_CASE_STRING = "MIXED_CASE_a";
    public static final Visibility VISIBILITY_A = new Visibility("a");
    public static final Visibility VISIBILITY_A_AND_B = new Visibility("a&b");
    public static final Visibility VISIBILITY_B = new Visibility("b");
    public static final Visibility VISIBILITY_C = new Visibility("c");
    public static final Visibility VISIBILITY_MIXED_CASE_a = new Visibility("((MIXED_CASE_a))|b");
    public static final Visibility VISIBILITY_EMPTY = new Visibility("");
    public static final String LABEL_LABEL1 = "label1";
    public static final String LABEL_LABEL2 = "label2";
    public static final String LABEL_LABEL3 = "label3";
    public static final String LABEL_BAD = "bad";
    public static final Authorizations AUTHORIZATIONS_A = new Authorizations(new String[]{"a"});
    public static final Authorizations AUTHORIZATIONS_B = new Authorizations(new String[]{"b"});
    public static final Authorizations AUTHORIZATIONS_C = new Authorizations(new String[]{"c"});
    public static final Authorizations AUTHORIZATIONS_MIXED_CASE_a_AND_B = new Authorizations(new String[]{"MIXED_CASE_a", "b"});
    public static final Authorizations AUTHORIZATIONS_A_AND_B = new Authorizations(new String[]{"a", "b"});
    public static final Authorizations AUTHORIZATIONS_B_AND_C = new Authorizations(new String[]{"b", "c"});
    public static final Authorizations AUTHORIZATIONS_A_AND_B_AND_C = new Authorizations(new String[]{"a", "b", "c"});
    public static final Authorizations AUTHORIZATIONS_EMPTY = new Authorizations(new String[0]);
    public static final Authorizations AUTHORIZATIONS_BAD = new Authorizations(new String[]{"bad"});
    public static final Authorizations AUTHORIZATIONS_ALL = new Authorizations(new String[]{"a", "b", "c", "MIXED_CASE_a"});
    public static final int LARGE_PROPERTY_VALUE_SIZE = 0x100001;
    @Rule
    public static final MethodRule skipRule = (base, method, target) -> new Statement(){

        public void evaluate() throws Throwable {
            try {
                base.evaluate();
            }
            catch (GeNotSupportedException e) {
                System.out.println("Ignoring method: " + method.getName());
                Assume.assumeTrue((boolean)false);
            }
        }
    };

    public <T extends Graph> T getGraph();

    public TestGraphFactory graphFactory();

    default public void addAuthorizations(String ... authorizations) {
        this.getGraph().createAuthorizations(authorizations);
    }

    default public boolean isPainlessDateMath() {
        return false;
    }

    default public List<Vertex> sortById(List<Vertex> vertices) {
        Collections.sort(vertices, Comparator.comparing(ElementId::getId));
        return vertices;
    }

    default public boolean isInputStreamMarkResetSupported() {
        return true;
    }

    default public DateValue createDate(int year, int month, int day) {
        return DateValue.date((int)year, (int)month, (int)day);
    }

    default public DateTimeValue createDate(int year, int month, int day, int hour, int min, int sec) {
        return DateTimeValue.datetime((int)year, (int)month, (int)day, (int)hour, (int)min, (int)sec, (int)0, (ZoneId)ZoneOffset.UTC);
    }

    default public Map<Object, Long> termsBucketToMap(Iterable<TermsBucket> buckets) {
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        for (TermsBucket b : buckets) {
            results.put(b.getKey(), b.getCount());
        }
        return results;
    }

    default public List<Vertex> getVertices(long count) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i = 0;
        while ((long)i < count) {
            Vertex vertex = this.getGraph().addVertex(Integer.toString(i), VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
            vertices.add(vertex);
            ++i;
        }
        return vertices;
    }

    default public Map<Object, Long> queryGraphQueryWithTermsAggregation(String propertyName, ElementType elementType, Authorizations authorizations) {
        return this.queryGraphQueryWithTermsAggregation(null, propertyName, elementType, authorizations);
    }

    default public Map<Object, Long> queryGraphQueryWithTermsAggregation(String queryString, String propertyName, ElementType elementType, Authorizations authorizations) {
        TermsResult aggregationResult = this.queryGraphQueryWithTermsAggregationResult(queryString, propertyName, elementType, null, authorizations);
        return this.termsBucketToMap(aggregationResult.getBuckets());
    }

    default public TermsResult queryGraphQueryWithTermsAggregationResult(String propertyName, ElementType elementType, Authorizations authorizations) {
        return this.queryGraphQueryWithTermsAggregationResult(null, propertyName, elementType, null, authorizations);
    }

    default public TermsResult queryGraphQueryWithTermsAggregationResult(String queryString, String propertyName, ElementType elementType, Integer buckets, Authorizations authorizations) {
        Query q = (queryString == null ? this.getGraph().query(authorizations) : this.getGraph().query(queryString, authorizations)).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", propertyName);
        if (buckets != null) {
            agg.setSize(buckets);
        }
        if (!q.isAggregationSupported((Aggregation)agg)) {
            System.err.println(String.format("%s unsupported", agg.getClass().getName()));
            return null;
        }
        q.addAggregation((Aggregation)agg);
        QueryResultsIterable elements = elementType == ElementType.VERTEX ? q.vertices() : q.edges();
        return (TermsResult)elements.getAggregationResult("terms-count", TermsResult.class);
    }

    default public boolean disableEdgeIndexing(Graph graph) {
        return false;
    }

    default public boolean isLuceneQueriesSupported() {
        return !(this.getGraph().query(AUTHORIZATIONS_A) instanceof DefaultGraphQuery);
    }
}

