/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.google.common.collect.Lists;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.TextPredicate;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IOUtils;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LargeStringInputStream;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphSpvTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testAddStreamingPropertyValue() throws IOException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propSmall = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream("value1".getBytes()), TextValue.class, (Long)6L);
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class, null);
        String largePropertyName = "propLarge/\\*!@#$%^&*()[]{}|";
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propSmall", (Value)propSmall, VISIBILITY_A).setProperty(largePropertyName, (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Iterable propSmallValues = v1.getPropertyValues("propSmall");
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)propSmallValues));
        Object propSmallValue = propSmallValues.iterator().next();
        GeAssert.assertTrue((String)("propSmallValue was " + propSmallValue.getClass().getName()), (boolean)(propSmallValue instanceof StreamingPropertyValue));
        StreamingPropertyValue value = (StreamingPropertyValue)propSmallValue;
        GeAssert.assertEquals(TextValue.class, (Object)value.getValueType());
        GeAssert.assertEquals((long)"value1".getBytes().length, (long)value.getLength());
        GeAssert.assertEquals((Object)"value1", (Object)IOUtils.toString((InputStream)value.getInputStream()));
        Iterable propLargeValues = v1.getPropertyValues(largePropertyName);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)propLargeValues));
        Object propLargeValue = propLargeValues.iterator().next();
        GeAssert.assertTrue((String)(largePropertyName + " was " + propLargeValue.getClass().getName()), (boolean)(propLargeValue instanceof StreamingPropertyValue));
        value = (StreamingPropertyValue)propLargeValue;
        GeAssert.assertEquals(TextValue.class, (Object)value.getValueType());
        GeAssert.assertEquals((long)expectedLargeValue.getBytes().length, (long)value.getLength());
        GeAssert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)value.getInputStream()));
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        propSmallValues = v1.getPropertyValues("propSmall");
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)propSmallValues));
        propSmallValue = propSmallValues.iterator().next();
        GeAssert.assertTrue((String)("propSmallValue was " + propSmallValue.getClass().getName()), (boolean)(propSmallValue instanceof StreamingPropertyValue));
        value = (StreamingPropertyValue)propSmallValue;
        GeAssert.assertEquals(TextValue.class, (Object)value.getValueType());
        GeAssert.assertEquals((long)"value1".getBytes().length, (long)value.getLength());
        GeAssert.assertEquals((Object)"value1", (Object)IOUtils.toString((InputStream)value.getInputStream()));
        propLargeValues = v1.getPropertyValues(largePropertyName);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)propLargeValues));
        propLargeValue = propLargeValues.iterator().next();
        GeAssert.assertTrue((String)(largePropertyName + " was " + propLargeValue.getClass().getName()), (boolean)(propLargeValue instanceof StreamingPropertyValue));
        value = (StreamingPropertyValue)propLargeValue;
        GeAssert.assertEquals(TextValue.class, (Object)value.getValueType());
        GeAssert.assertEquals((long)expectedLargeValue.getBytes().length, (long)value.getLength());
        GeAssert.assertEquals((Object)expectedLargeValue, (Object)IOUtils.toString((InputStream)value.getInputStream()));
    }

    @Test
    public void testStreamingPropertyValueLargeReads() throws IOException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        byte[] expectedLargeValueBytes = expectedLargeValue.getBytes();
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propLarge", (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        byte[] buffer = new byte[0x200002];
        int leftToRead = expectedLargeValueBytes.length;
        InputStream in = prop.getInputStream();
        int expectedOffset = 0;
        while (expectedOffset < expectedLargeValueBytes.length) {
            int sizeRead = in.read(buffer);
            int j = 0;
            while (j < sizeRead) {
                GeAssert.assertEquals((String)("invalid data at offset " + expectedOffset), (long)expectedLargeValueBytes[expectedOffset], (long)buffer[j]);
                ++j;
                ++expectedOffset;
                --leftToRead;
            }
            if (sizeRead != -1) continue;
            break;
        }
        GeAssert.assertEquals((long)0L, (long)leftToRead);
        GeAssert.assertEquals((long)-1L, (long)in.read(buffer));
    }

    @Test
    public void testStreamingPropertyDecreasingSize() throws IOException {
        Metadata metadata = Metadata.create();
        Long timestamp = System.currentTimeMillis();
        String expectedValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedValue.getBytes()), TextValue.class, (Long)Long.valueOf(expectedValue.length()));
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "largeProp", (Value)propLarge, metadata, timestamp, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        StreamingPropertyValue spv = (StreamingPropertyValue)v1.getPropertyValue("key1", "largeProp");
        GeAssert.assertEquals((Object)expectedValue, (Object)spv.readToString());
        expectedValue = "small";
        propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedValue.getBytes()), TextValue.class, (Long)Long.valueOf(expectedValue.length()));
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "largeProp", (Value)propLarge, metadata, Long.valueOf(timestamp + 1L), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        spv = (StreamingPropertyValue)v1.getPropertyValue("key1", "largeProp");
        GeAssert.assertEquals((Object)expectedValue, (Object)spv.readToString());
    }

    @Test
    public void testStreamingPropertyValueMarkReset() throws IOException {
        Assume.assumeTrue((String)"InputStream mark/reset is not supported", (boolean)this.isInputStreamMarkResetSupported());
        String expectedLargeValue = "abcdefghijk";
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propLarge", (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        InputStream in = prop.getInputStream();
        byte[] buffer = new byte[15];
        int sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)11L, (long)sizeRead);
        GeAssert.assertEquals((Object)"abcdefghijk", (Object)new String(buffer, 0, sizeRead));
        in.reset();
        buffer = new byte[3];
        sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)3L, (long)sizeRead);
        GeAssert.assertEquals((Object)"abc", (Object)new String(buffer, 0, sizeRead));
        GeAssert.assertEquals((long)100L, (long)((char)in.read()));
        GeAssert.assertEquals((long)101L, (long)((char)in.read()));
        in.mark(32);
        buffer = new byte[5];
        sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)5L, (long)sizeRead);
        GeAssert.assertEquals((Object)"fghij", (Object)new String(buffer, 0, sizeRead));
        in.reset();
        buffer = new byte[10];
        sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)6L, (long)sizeRead);
        GeAssert.assertEquals((Object)"fghijk", (Object)new String(buffer, 0, sizeRead));
        GeAssert.assertEquals((long)-1L, (long)in.read(buffer));
        in.reset();
        buffer = new byte[10];
        sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)6L, (long)sizeRead);
        GeAssert.assertEquals((Object)"fghijk", (Object)new String(buffer, 0, sizeRead));
    }

    @Test
    public void testStreamingPropertyValueMarkResetLargeReads() throws IOException {
        Assume.assumeTrue((String)"InputStream mark/reset is not supported", (boolean)this.isInputStreamMarkResetSupported());
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        byte[] expectedLargeValueBytes = expectedLargeValue.getBytes();
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propLarge", (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        InputStream in = prop.getInputStream();
        byte[] buffer = null;
        for (int amountToRead = expectedLargeValueBytes.length - 8; amountToRead > 0; amountToRead -= in.read(buffer)) {
            buffer = new byte[amountToRead];
        }
        GeAssert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 9), (long)((char)buffer[buffer.length - 1]));
        in.mark(32);
        buffer = new byte[2];
        int sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)2L, (long)sizeRead);
        GeAssert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 8), (long)((char)buffer[0]));
        GeAssert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 7), (long)((char)buffer[1]));
        GeAssert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 6), (long)((char)in.read()));
        in.reset();
        sizeRead = in.read(buffer);
        GeAssert.assertEquals((long)2L, (long)sizeRead);
        GeAssert.assertEquals((long)expectedLargeValue.charAt(expectedLargeValue.length() - 8), (long)((char)buffer[0]));
    }

    @Test
    public void testStreamingPropertyValueResetMutlipleLargeReadsUntilEnd() throws IOException {
        Assume.assumeTrue((String)"InputStream mark/reset is not supported", (boolean)this.isInputStreamMarkResetSupported());
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        byte[] expectedLargeValueBytes = expectedLargeValue.getBytes();
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propLarge", (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        StreamingPropertyValue prop = (StreamingPropertyValue)v1.getPropertyValue("propLarge");
        InputStream in = prop.getInputStream();
        in.mark(2);
        for (int i = 0; i < 3; ++i) {
            int totalBytesRead = 0;
            while (in.read() >= 0) {
                GeAssert.assertTrue((String)"Read past end of input stream", (++totalBytesRead <= expectedLargeValueBytes.length ? 1 : 0) != 0);
            }
            GeAssert.assertEquals((String)("Read unexpected number of bytes on loop: " + i), (long)expectedLargeValueBytes.length, (long)totalBytesRead);
            GeAssert.assertEquals((long)-1L, (long)in.read());
            in.reset();
        }
    }

    @Test
    public void testTextIndexStreamingPropertyValue() throws Exception {
        this.getGraph().defineProperty("none").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.getGraph().defineProperty("both").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("fullText").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("none", (Value)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).setProperty("both", (Value)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).setProperty("fullText", (Value)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Test")).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Test")).vertices()));
        GeAssert.assertEquals((String)"un-indexed property shouldn't match partials", (long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("none", (Value)Values.stringValue((String)"Test")).vertices()));
        try {
            this.getGraph().query(AUTHORIZATIONS_A).has("none", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Test"));
            GeAssert.fail((String)"Full text queries should not be allowed for properties that are not indexed with FULL_TEXT.");
        }
        catch (GeException ve) {
            GeAssert.assertEquals((Object)"Check your TextIndexHint settings. Property none is not full text indexed.", (Object)ve.getMessage());
        }
    }

    @Test
    public void testQueryingUpdatedStreamingPropertyValues() throws Exception {
        this.getGraph().defineProperty("fullText").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("fullText", (Value)StreamingPropertyValue.create((String)"Test Value"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Test")).vertices()));
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().setProperty("fullText", (Value)StreamingPropertyValue.create((String)"Updated Test Value 111"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"111")).vertices()));
        Vertex v = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v.prepareMutation().setProperty("fullText", (Value)StreamingPropertyValue.create((String)"Updated Test Value - existing mutation"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"mutation")).vertices()));
    }

    @Test
    public void testGetStreamingPropertyValueInputStreams() throws Exception {
        this.getGraph().defineProperty("a").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("b").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("c").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("a", (Value)StreamingPropertyValue.create((String)"Test Value A"), VISIBILITY_A).setProperty("b", (Value)StreamingPropertyValue.create((String)"Test Value B"), VISIBILITY_A).setProperty("c", (Value)StreamingPropertyValue.create((String)"Test Value C"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        StreamingPropertyValue spvA = (StreamingPropertyValue)v1.getPropertyValue("a");
        GeAssert.assertEquals((long)12L, (long)spvA.getLength());
        StreamingPropertyValue spvB = (StreamingPropertyValue)v1.getPropertyValue("b");
        GeAssert.assertEquals((long)12L, (long)spvA.getLength());
        StreamingPropertyValue spvC = (StreamingPropertyValue)v1.getPropertyValue("c");
        GeAssert.assertEquals((long)12L, (long)spvA.getLength());
        ArrayList spvs = Lists.newArrayList((Object[])new StreamingPropertyValue[]{spvA, spvB, spvC});
        List streams = this.getGraph().getStreamingPropertyValueInputStreams((List)spvs);
        GeAssert.assertEquals((Object)"Test Value A", (Object)IOUtils.toString((InputStream)((InputStream)streams.get(0))));
        GeAssert.assertEquals((Object)"Test Value B", (Object)IOUtils.toString((InputStream)((InputStream)streams.get(1))));
        GeAssert.assertEquals((Object)"Test Value C", (Object)IOUtils.toString((InputStream)((InputStream)streams.get(2))));
    }

    @Test
    public void testChangeVisibilityOnStreamingProperty() throws IOException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propSmall = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream("value1".getBytes()), TextValue.class);
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class);
        String largePropertyName = "propLarge/\\*!@#$%^&*()[]{}|";
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propSmall", (Value)propSmall, VISIBILITY_A).setProperty(largePropertyName, (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility("propSmall", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility(largePropertyName, VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties()));
    }
}

