/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.google.common.collect.Lists;
import com.mware.ge.Graph;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.query.Compare;
import com.mware.ge.query.IterableWithScores;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.SortDirection;
import com.mware.ge.scoring.FieldValueScoringStrategy;
import com.mware.ge.scoring.HammingDistanceScoringStrategy;
import com.mware.ge.scoring.ScoringStrategy;
import com.mware.ge.sorting.LengthOfStringSortingStrategy;
import com.mware.ge.sorting.SortingStrategy;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphSortingScoringTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testHammingDistanceScoringStrategy() {
        this.getGraph().defineProperty("prop1").dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"0000000000000000"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"ffffffffffffffff"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"0000000000000001"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"3000000000000000"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).scoringStrategy(this.getHammingDistanceScoringStrategy("prop1", "0000000000000000")).vertices();
        Assume.assumeTrue((String)"IterableWithScores", (boolean)(vertices instanceof IterableWithScores));
        IterableWithScores scores = (IterableWithScores)vertices;
        List verticesList = IterableUtils.toList((Iterable)vertices);
        GeAssert.assertEquals((long)4L, (long)verticesList.size());
        GeAssert.assertEquals((Object)"v1", (Object)((Vertex)verticesList.get(0)).getId());
        GeAssert.assertEquals((double)64.0, (double)scores.getScore((Object)"v1"), (double)1.0E-4);
        GeAssert.assertEquals((Object)"v3", (Object)((Vertex)verticesList.get(1)).getId());
        GeAssert.assertEquals((double)63.0, (double)scores.getScore((Object)"v3"), (double)1.0E-4);
        GeAssert.assertEquals((Object)"v4", (Object)((Vertex)verticesList.get(2)).getId());
        GeAssert.assertEquals((double)62.0, (double)scores.getScore((Object)"v4"), (double)1.0E-4);
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)verticesList.get(3)).getId());
        GeAssert.assertEquals((double)0.0, (double)scores.getScore((Object)"v2"), (double)1.0E-4);
    }

    @Test
    public void testGetLengthOfStringSortingStrategy() {
        this.getGraph().defineProperty("prop1").dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"aaaaa"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"bbb"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"zzzzzzz"), VISIBILITY_A).addPropertyValue("k2", "prop1", (Value)Values.stringValue((String)"z"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"cccc"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v5", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v6", VISIBILITY_A, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"aaaaaaaaaaaaaaaaaaaaaa"), VISIBILITY_B).addPropertyValue("k2", "prop1", (Value)Values.stringValue((String)"a"), VISIBILITY_B).addPropertyValue("k3", "prop1", (Value)Values.stringValue((String)"ddddd"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).sort(this.getLengthOfStringSortingStrategy("prop1"), SortDirection.ASCENDING).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v3", "v2", "v4", "v1", "v6", "v5"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).sort(this.getLengthOfStringSortingStrategy("prop1"), SortDirection.DESCENDING).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v3", "v1", "v6", "v4", "v2", "v5"});
    }

    @Test
    public void testMinimumScoreQueryParameter() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.intValue((int)1), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.intValue((int)2), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.intValue((int)3), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).scoringStrategy(this.getFieldValueScoringStrategy("prop1")).minScore(2.0).vertices();
        Assume.assumeTrue((String)"IterableWithScores", (boolean)(vertices instanceof IterableWithScores));
        GeAssert.assertEquals((long)2L, (long)Lists.newArrayList((Iterable)vertices).size());
        IterableWithScores scores = (IterableWithScores)vertices;
        GeAssert.assertEquals((double)2.0, (double)scores.getScore((Object)"v2"), (double)0.001);
        GeAssert.assertEquals((double)3.0, (double)scores.getScore((Object)"v3"), (double)0.001);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).scoringStrategy(this.getFieldValueScoringStrategy("prop1")).minScore(4.0).vertices();
        GeAssert.assertEquals((long)0L, (long)Lists.newArrayList((Iterable)vertices).size());
    }

    @Test
    public void testGraphQuerySort() {
        String namePropertyName = "first.name";
        String agePropertyName = "age";
        String genderPropertyName = "gender";
        this.getGraph().defineProperty(agePropertyName).dataType(IntValue.class).sortable(true).define();
        this.getGraph().defineProperty(namePropertyName).dataType(TextValue.class).sortable(true).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().defineProperty(genderPropertyName).dataType(TextValue.class).sortable(true).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT, TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"bob"), VISIBILITY_B).setProperty(agePropertyName, (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"tom"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)30), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"tom"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)35), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label2", VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e2", "v1", "v2", "label1", VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e3", "v1", "v2", "label3", VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(agePropertyName, SortDirection.ASCENDING).vertices());
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2", "v3", "v4", "v1"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(agePropertyName, SortDirection.DESCENDING).vertices());
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v4", "v3", "v2", "v1"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.ASCENDING).vertices());
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(0)).getId());
        GeAssert.assertEquals((Object)"v1", (Object)((Vertex)vertices.get(1)).getId());
        GeAssert.assertTrue((((Vertex)vertices.get(2)).getId().equals("v3") || ((Vertex)vertices.get(2)).getId().equals("v4") ? 1 : 0) != 0);
        GeAssert.assertTrue((((Vertex)vertices.get(3)).getId().equals("v3") || ((Vertex)vertices.get(3)).getId().equals("v4") ? 1 : 0) != 0);
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.DESCENDING).vertices());
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertTrue((((Vertex)vertices.get(0)).getId().equals("v3") || ((Vertex)vertices.get(0)).getId().equals("v4") ? 1 : 0) != 0);
        GeAssert.assertTrue((((Vertex)vertices.get(1)).getId().equals("v3") || ((Vertex)vertices.get(1)).getId().equals("v4") ? 1 : 0) != 0);
        GeAssert.assertEquals((Object)"v1", (Object)((Vertex)vertices.get(2)).getId());
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(3)).getId());
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.ASCENDING).sort(agePropertyName, SortDirection.ASCENDING).vertices());
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2", "v1", "v3", "v4"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(namePropertyName, SortDirection.ASCENDING).sort(agePropertyName, SortDirection.DESCENDING).vertices());
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2", "v1", "v4", "v3"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("__ID__", SortDirection.ASCENDING).vertices());
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1", "v2", "v3", "v4"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("__ID__", SortDirection.DESCENDING).vertices());
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v4", "v3", "v2", "v1"});
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("otherfield", SortDirection.ASCENDING).vertices());
        GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)vertices));
        List edges = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("__edgeLabel", SortDirection.ASCENDING).edges());
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"e2", "e1", "e3"});
        edges = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("__edgeLabel", SortDirection.DESCENDING).edges());
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"e3", "e1", "e2"});
        edges = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("__outVertexId", SortDirection.ASCENDING).sort("__ID__", SortDirection.ASCENDING).edges());
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"e1", "e2", "e3"});
        edges = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("__inVertexId", SortDirection.ASCENDING).sort("__ID__", SortDirection.ASCENDING).edges());
        GeAssert.assertEdgeIds((Iterable)edges, (String[])new String[]{"e1", "e2", "e3"});
        this.getGraph().prepareVertex("v5", VISIBILITY_A, "thing").setProperty(genderPropertyName, (Value)Values.stringValue((String)"female"), VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v6", VISIBILITY_A, "thing").setProperty(genderPropertyName, (Value)Values.stringValue((String)"male"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort(genderPropertyName, SortDirection.ASCENDING).vertices());
        GeAssert.assertEquals((long)6L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertEquals((Object)"v5", (Object)((Vertex)vertices.get(0)).getId());
        GeAssert.assertEquals((Object)"v6", (Object)((Vertex)vertices.get(1)).getId());
        GeAssert.assertTrue((((Vertex)vertices.get(2)).getId().equals("v2") || ((Vertex)vertices.get(2)).getId().equals("v1") ? 1 : 0) != 0);
        GeAssert.assertTrue((((Vertex)vertices.get(3)).getId().equals("v2") || ((Vertex)vertices.get(3)).getId().equals("v1") ? 1 : 0) != 0);
        GeAssert.assertTrue((((Vertex)vertices.get(4)).getId().equals("v3") || ((Vertex)vertices.get(4)).getId().equals("v4") ? 1 : 0) != 0);
        GeAssert.assertTrue((((Vertex)vertices.get(5)).getId().equals("v3") || ((Vertex)vertices.get(5)).getId().equals("v4") ? 1 : 0) != 0);
    }

    @Test
    public void testGraphQuerySortOnPropertyThatHasNoValuesInTheIndex() {
        this.getGraph().defineProperty("age").dataType(IntValue.class).sortable(true).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"bob"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).sort("age", SortDirection.ASCENDING).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQuerySortOnPropertyWhichIsFullTextAndExactMatchIndexed() {
        this.getGraph().defineProperty("name").dataType(TextValue.class).sortable(true).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"1-2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"1-1"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"3-1"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).sort("name", SortDirection.ASCENDING).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2", "v1", "v3"});
        vertices = this.getGraph().query("3", AUTHORIZATIONS_A_AND_B).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v3"});
        vertices = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).has("name", (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"3-1")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v3"});
    }

    protected ScoringStrategy getHammingDistanceScoringStrategy(String field, String hash) {
        return new HammingDistanceScoringStrategy(field, hash);
    }

    protected SortingStrategy getLengthOfStringSortingStrategy(String propertyName) {
        return new LengthOfStringSortingStrategy(propertyName);
    }

    protected ScoringStrategy getFieldValueScoringStrategy(String field) {
        return new FieldValueScoringStrategy(field);
    }
}

