/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.ElementFilter;
import com.mware.ge.ElementType;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.query.Compare;
import com.mware.ge.query.GeoCompare;
import com.mware.ge.query.IterableWithTotalHits;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.aggregations.TermsResult;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IOUtils;
import com.mware.ge.util.IncreasingTime;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.LargeStringInputStream;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphSecurityTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testFilterEdgeIdsByAuthorization() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Metadata metadataPropB = Metadata.create();
        metadataPropB.add("meta1", (Value)Values.stringValue((String)"meta1"), VISIBILITY_A);
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("propA", (Value)Values.stringValue((String)"propA"), VISIBILITY_A).setProperty("propB", (Value)Values.stringValue((String)"propB"), VISIBILITY_A_AND_B).setProperty("propBmeta", (Value)Values.stringValue((String)"propBmeta"), metadataPropB, VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ArrayList<String> edgeIds = new ArrayList<String>();
        edgeIds.add("e1");
        List foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "a", ElementFilter.ALL, AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"e1", (Iterable)foundEdgeIds);
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "b", ElementFilter.ALL, AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"e1", (Iterable)foundEdgeIds);
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "c", ElementFilter.ALL, AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundEdgeIds.size());
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "a", EnumSet.of(ElementFilter.ELEMENT), AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"e1", (Iterable)foundEdgeIds);
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "b", EnumSet.of(ElementFilter.ELEMENT), AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundEdgeIds.size());
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "a", EnumSet.of(ElementFilter.PROPERTY), AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"e1", (Iterable)foundEdgeIds);
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "c", EnumSet.of(ElementFilter.PROPERTY), AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundEdgeIds.size());
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "a", EnumSet.of(ElementFilter.PROPERTY_METADATA), AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"e1", (Iterable)foundEdgeIds);
        foundEdgeIds = IterableUtils.toList((Iterable)this.getGraph().filterEdgeIdsByAuthorization(edgeIds, "c", EnumSet.of(ElementFilter.PROPERTY_METADATA), AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundEdgeIds.size());
    }

    @Test
    public void testFilterVertexIdsByAuthorization() {
        Metadata metadataPropB = Metadata.create();
        metadataPropB.add("meta1", (Value)Values.stringValue((String)"meta1"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propA", (Value)Values.stringValue((String)"propA"), VISIBILITY_A).setProperty("propB", (Value)Values.stringValue((String)"propB"), VISIBILITY_A_AND_B).setProperty("propBmeta", (Value)Values.stringValue((String)"propBmeta"), metadataPropB, VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ArrayList<String> vertexIds = new ArrayList<String>();
        vertexIds.add("v1");
        List foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "a", ElementFilter.ALL, AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"v1", (Iterable)foundVertexIds);
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "b", ElementFilter.ALL, AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"v1", (Iterable)foundVertexIds);
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "c", ElementFilter.ALL, AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundVertexIds.size());
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "a", EnumSet.of(ElementFilter.ELEMENT), AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"v1", (Iterable)foundVertexIds);
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "b", EnumSet.of(ElementFilter.ELEMENT), AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundVertexIds.size());
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "a", EnumSet.of(ElementFilter.PROPERTY), AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"v1", (Iterable)foundVertexIds);
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "c", EnumSet.of(ElementFilter.PROPERTY), AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundVertexIds.size());
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "a", EnumSet.of(ElementFilter.PROPERTY_METADATA), AUTHORIZATIONS_ALL));
        IterableUtils.assertContains((Object)"v1", (Iterable)foundVertexIds);
        foundVertexIds = IterableUtils.toList((Iterable)this.getGraph().filterVertexIdsByAuthorization(vertexIds, "c", EnumSet.of(ElementFilter.PROPERTY_METADATA), AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)0L, (long)foundVertexIds.size());
    }

    @Test
    public void testChangeVisibilityOnStreamingProperty() throws IOException {
        String expectedLargeValue = IOUtils.toString((InputStream)new LargeStringInputStream(0x100001));
        StreamingPropertyValue propSmall = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream("value1".getBytes()), TextValue.class);
        StreamingPropertyValue propLarge = StreamingPropertyValue.create((InputStream)new ByteArrayInputStream(expectedLargeValue.getBytes()), TextValue.class);
        String largePropertyName = "propLarge/\\*!@#$%^&*()[]{}|";
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propSmall", (Value)propSmall, VISIBILITY_A).setProperty(largePropertyName, (Value)propLarge, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility("propSmall", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility(largePropertyName, VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getProperties()));
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).getProperties()));
    }

    @Test
    public void testChangeVisibilityVertex() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v1);
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        GeAssert.assertNotNull((Object)v1);
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v1);
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        GeAssert.assertNotNull((Object)v1);
    }

    @Test
    public void testChangeVertexVisibility() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        GeAssert.assertNotNull((Object)v1);
    }

    @Test
    public void testChangeVertexVisibilityAndAlterPropertyVisibilityAndChangePropertyAtTheSameTime() {
        Metadata metadata = Metadata.create();
        metadata.add("m1", (Value)Values.stringValue((String)"m1-value1"), VISIBILITY_EMPTY);
        metadata.add("m2", (Value)Values.stringValue((String)"m2-value1"), VISIBILITY_EMPTY);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "age", (Value)Values.intValue((int)25), metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().createAuthorizations(AUTHORIZATIONS_ALL, new String[0]);
        this.getGraph().flush();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("age", (Value)Values.intValue((int)25)).vertices());
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_ALL);
        ExistingVertexMutation m = v1.prepareMutation();
        m.alterElementVisibility(VISIBILITY_B);
        for (Property property : v1.getProperties()) {
            m.alterPropertyVisibility(property, VISIBILITY_B);
            m.setPropertyMetadata(property, "m1", (Value)Values.stringValue((String)"m1-value2"), VISIBILITY_EMPTY);
        }
        m.save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_B);
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)v1.getVisibility());
        List properties = IterableUtils.toList((Iterable)v1.getProperties());
        GeAssert.assertEquals((long)1L, (long)properties.size());
        GeAssert.assertEquals((Object)"age", (Object)((Property)properties.get(0)).getName());
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)((Property)properties.get(0)).getVisibility());
        GeAssert.assertEquals((long)2L, (long)((Property)properties.get(0)).getMetadata().entrySet().size());
        GeAssert.assertTrue((boolean)((Property)properties.get(0)).getMetadata().containsKey("m1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"m1-value2"), (Object)((Property)properties.get(0)).getMetadata().getEntry("m1").getValue());
        GeAssert.assertEquals((Object)VISIBILITY_EMPTY, (Object)((Property)properties.get(0)).getMetadata().getEntry("m1").getVisibility());
        GeAssert.assertTrue((boolean)((Property)properties.get(0)).getMetadata().containsKey("m2"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"m2-value1"), (Object)((Property)properties.get(0)).getMetadata().getEntry("m2").getValue());
        GeAssert.assertEquals((Object)VISIBILITY_EMPTY, (Object)((Property)properties.get(0)).getMetadata().getEntry("m2").getVisibility());
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((String)"v1 should not be returned for auth a", (Object)v1);
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("age", (Value)Values.intValue((int)25)).vertices());
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("age", (Value)Values.intValue((int)25)).vertices());
    }

    @Test
    public void testChangeVisibilityPropertiesWithPropertyKey() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("k1", "prop1", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v1.getProperty("prop1"));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices()));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices()));
        TermsResult aggregationResult = this.queryGraphQueryWithTermsAggregationResult("prop1", ElementType.VERTEX, AUTHORIZATIONS_A);
        Map<Object, Long> propertyCountByValue = this.termsBucketToMap(aggregationResult.getBuckets());
        if (propertyCountByValue != null) {
            GeAssert.assertEquals(null, (Object)propertyCountByValue.get("value1"));
        }
        if ((propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, AUTHORIZATIONS_B)) != null) {
            GeAssert.assertEquals((long)1L, (long)propertyCountByValue.get("value1"));
        }
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        Property v1Prop1 = v1.getProperty("prop1");
        GeAssert.assertNotNull((Object)v1Prop1);
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)v1Prop1.getVisibility());
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_EMPTY).addPropertyValue("k2", "prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        e1.prepareMutation().alterPropertyVisibility("k2", "prop2", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)e1.getProperty("prop2"));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_B).has("prop2", (Value)Values.stringValue((String)"value2")).edges()));
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("prop2", (Value)Values.stringValue((String)"value2")).edges()));
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop2", ElementType.EDGE, AUTHORIZATIONS_A);
        if (propertyCountByValue != null) {
            GeAssert.assertEquals(null, (Object)propertyCountByValue.get("value2"));
        }
        if ((propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop2", ElementType.EDGE, AUTHORIZATIONS_B)) != null) {
            GeAssert.assertEquals((long)1L, (long)propertyCountByValue.get("value2"));
        }
        e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        Property e1prop1 = e1.getProperty("prop2");
        GeAssert.assertNotNull((Object)e1prop1);
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)e1prop1.getVisibility());
    }

    @Test
    public void testChangeVisibilityVertexProperties() {
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("prop1_key1", (Value)Values.stringValue((String)"value1"), VISIBILITY_EMPTY);
        Metadata prop2Metadata = Metadata.create();
        prop2Metadata.add("prop2_key1", (Value)Values.stringValue((String)"value1"), VISIBILITY_EMPTY);
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_A).setProperty("prop2", (Value)Values.stringValue((String)"value2"), prop2Metadata, VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertNull((Object)v1.getProperty("prop1"));
        GeAssert.assertNotNull((Object)v1.getProperty("prop2"));
        IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, AUTHORIZATIONS_A);
        if (propertyCountByValue != null) {
            GeAssert.assertEquals(null, (Object)propertyCountByValue.get("value1"));
        }
        if ((propertyCountByValue = this.queryGraphQueryWithTermsAggregation("prop1", ElementType.VERTEX, AUTHORIZATIONS_B)) != null) {
            GeAssert.assertEquals((long)1L, (long)propertyCountByValue.get("value1"));
        }
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        Property v1Prop1 = v1.getProperty("prop1");
        GeAssert.assertNotNull((Object)v1Prop1);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.toList((Iterable)v1Prop1.getMetadata().entrySet()).size());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)v1Prop1.getMetadata().getValue("prop1_key1"));
        GeAssert.assertNotNull((Object)v1.getProperty("prop2"));
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1New"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1New")).vertices());
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1New")).vertices());
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((Object)v1.getProperty("prop1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1New"), (Object)v1.getPropertyValue("prop1"));
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1New2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((Object)v1.getProperty("prop1"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1New2"), (Object)v1.getPropertyValue("prop1"));
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1New")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1New")).vertices());
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_B).has("prop1", (Value)Values.stringValue((String)"value1New2")).vertices());
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1New2")).vertices());
    }

    @Test
    public void testAlterVisibilityAndSetMetadataInOneMutation() {
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("prop1_key1", (Value)Values.stringValue((String)"metadata1"), VISIBILITY_EMPTY);
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1", VISIBILITY_B).setPropertyMetadata("prop1", "prop1_key1", (Value)Values.stringValue((String)"metadata1New"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertNotNull((Object)v1.getProperty("prop1"));
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)v1.getProperty("prop1").getVisibility());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata1New"), (Object)v1.getProperty("prop1").getMetadata().getValue("prop1_key1"));
        List historicalPropertyValues = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(AUTHORIZATIONS_A_AND_B));
        GeAssert.assertEquals((long)3L, (long)historicalPropertyValues.size());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata1New"), (Object)((HistoricalPropertyValue)historicalPropertyValues.get(0)).getMetadata().getValue("prop1_key1"));
        GeAssert.assertTrue((boolean)((HistoricalPropertyValue)historicalPropertyValues.get(1)).isDeleted());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata1"), (Object)((HistoricalPropertyValue)historicalPropertyValues.get(2)).getMetadata().getValue("prop1_key1"));
    }

    @Test
    public void testAlterPropertyVisibilityOverwritingProperty() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_EMPTY).addPropertyValue("", "prop1", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        long beforeAlterTimestamp = IncreasingTime.currentTimeMillis();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        v1.prepareMutation().alterPropertyVisibility(v1.getProperty("", "prop1", VISIBILITY_A), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertNotNull((Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY).getValue());
        GeAssert.assertNull((Object)v1.getProperty("", "prop1", VISIBILITY_A));
        this.getGraph().dumpGraph();
        v1 = this.getGraph().getVertex("v1", this.getGraph().getDefaultFetchHints(), Long.valueOf(beforeAlterTimestamp), AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        GeAssert.assertNotNull((Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)v1.getProperty("", "prop1", VISIBILITY_EMPTY).getValue());
        GeAssert.assertNotNull((Object)v1.getProperty("", "prop1", VISIBILITY_A));
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)v1.getProperty("", "prop1", VISIBILITY_A).getValue());
    }

    @Test
    public void testAlterPropertyVisibilityOfGeoLocation() {
        this.getGraph().defineProperty("prop1").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("prop2").dataType(GeoPointValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("key1", "prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("key1", "prop2", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        v1.prepareMutation().alterPropertyVisibility(v1.getProperty("key1", "prop1", VISIBILITY_A), VISIBILITY_EMPTY).alterPropertyVisibility(v1.getProperty("key1", "prop2", VISIBILITY_A), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_EMPTY).has("prop1", (Value)Values.stringValue((String)"value1")).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        QueryResultsIterable vertexIds = this.getGraph().query(AUTHORIZATIONS_EMPTY).has("prop2", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)vertexIds, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertexIds);
        vertices = this.getGraph().query(AUTHORIZATIONS_EMPTY).has("prop2", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
    }

    @Test
    public void testChangeVisibilityEdge() {
        Vertex v1 = this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_B)));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A);
        e1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_B)));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
        e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_B);
        e1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_B);
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_B)));
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.BOTH, AUTHORIZATIONS_A)));
    }

    @Test
    public void testChangeVisibilityOnBadPropertyName() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_EMPTY).setProperty("prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        try {
            this.getGraph().getVertex("v1", AUTHORIZATIONS_A).prepareMutation().alterPropertyVisibility("propBad", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
            GeAssert.fail((String)"show throw");
        }
        catch (GeException ex) {
            GeAssert.assertNotNull((Object)((Object)ex));
        }
    }

    @Test
    public void testMutationChangePropertyVisibilityFollowedByMetadataUsingPropertyObject() {
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("prop1_key1", (Value)Values.stringValue((String)"valueOld"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        Property p1 = v1.getProperty("prop1", VISIBILITY_A);
        v1.prepareMutation().alterPropertyVisibility(p1, VISIBILITY_B).setPropertyMetadata(p1, "prop1_key1", (Value)Values.stringValue((String)"valueNew"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueNew"), (Object)v1.getProperty("prop1", VISIBILITY_B).getMetadata().getEntry("prop1_key1", VISIBILITY_B).getValue());
    }

    @Test
    public void testIsVisibilityValid() {
        GeAssert.assertFalse((boolean)this.getGraph().isVisibilityValid(VISIBILITY_A, AUTHORIZATIONS_C));
        GeAssert.assertTrue((boolean)this.getGraph().isVisibilityValid(VISIBILITY_B, AUTHORIZATIONS_A_AND_B));
        GeAssert.assertTrue((boolean)this.getGraph().isVisibilityValid(VISIBILITY_B, AUTHORIZATIONS_B));
        GeAssert.assertTrue((boolean)this.getGraph().isVisibilityValid(VISIBILITY_EMPTY, AUTHORIZATIONS_A));
    }

    @Test
    public void testModifyVertexWithLowerAuthorizationThenOtherProperties() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v1.setProperty("prop1", (Value)Values.stringValue((String)"value1New"), VISIBILITY_A, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop2", (Value)Values.stringValue((String)"value2")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
    }

    @Test
    @Ignore
    public void manyVisibilities() {
        String itemVisibilityString;
        int i;
        int count = 1010;
        ArrayList<String> authsToAdd = new ArrayList<String>();
        authsToAdd.add("all");
        for (i = 0; i < count; ++i) {
            itemVisibilityString = String.format("v%d", i);
            authsToAdd.add(itemVisibilityString);
        }
        System.out.println("Adding auths");
        this.addAuthorizations(authsToAdd.toArray(new String[authsToAdd.size()]));
        System.out.println("Add vertices");
        for (i = 0; i < count; ++i) {
            itemVisibilityString = String.format("v%d", i);
            Visibility visibility = new Visibility(String.format("v%d|all", i));
            Authorizations authorizations = new Authorizations(new String[]{"all", itemVisibilityString});
            this.getGraph().prepareVertex(visibility, "thing").addPropertyValue("key1", "name1", (Value)Values.stringValue((String)itemVisibilityString), visibility).save(authorizations);
        }
        this.getGraph().flush();
        System.out.println("Getting vertices");
        Authorizations authorizations = new Authorizations(new String[]{"all"});
        ArrayList vertices = Lists.newArrayList((Iterable)this.getGraph().getVertices(authorizations));
        GeAssert.assertEquals((long)count, (long)vertices.size());
        System.out.println("Query vertices");
        vertices = Lists.newArrayList((Iterable)this.getGraph().query(authorizations).limit((Integer)null).vertices());
        GeAssert.assertEquals((long)count, (long)vertices.size());
    }

    @Test
    public void testGraphQueryVertexHasWithSecurity() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        if (vertices instanceof IterableWithTotalHits) {
            GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
        if (vertices instanceof IterableWithTotalHits) {
            GeAssert.assertEquals((long)0L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        if (vertices instanceof IterableWithTotalHits) {
            GeAssert.assertEquals((long)2L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityGranularity() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("description", (Value)Values.stringValue((String)"v1"), VISIBILITY_A).setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("description", (Value)Values.stringValue((String)"v2"), VISIBILITY_A).setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices();
        boolean hasAgeVisA = false;
        boolean hasAgeVisB = false;
        for (Vertex v : vertices) {
            Property prop = v.getProperty("age");
            if (prop == null || !Values.intValue((int)25).eq((Object)prop.getValue())) continue;
            if (prop.getVisibility().equals((Object)VISIBILITY_A)) {
                hasAgeVisA = true;
                continue;
            }
            if (!prop.getVisibility().equals((Object)VISIBILITY_B)) continue;
            hasAgeVisB = true;
        }
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertTrue((String)"has a", (boolean)hasAgeVisA);
        GeAssert.assertFalse((String)"has b", (boolean)hasAgeVisB);
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityComplexFormula() {
        this.getGraph().prepareVertex("v1", VISIBILITY_MIXED_CASE_a, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_MIXED_CASE_a).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_B).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_MIXED_CASE_a_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexNoVisibility() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("text", (Value)Values.stringValue((String)"hello"), VISIBILITY_EMPTY).setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query("hello", AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("hello", AUTHORIZATIONS_A_AND_B).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryTextVertexDifferentAuths() {
        this.getGraph().defineProperty("title").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("fullText").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("title", (Value)Values.stringValue((String)"hello"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_B, "thing").setProperty("fullText", (Value)StreamingPropertyValue.create((String)"this is text with hello"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query("hello", AUTHORIZATIONS_A).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query("hello", AUTHORIZATIONS_A_AND_B).vertices();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
    }

    @Test
    public void testGraphQueryVertexDifferentAuths() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_B, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
    }

    @Test
    public void testAlterElementVisibility() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.graph.getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        long count = this.graph.query(new String[]{"v1"}, AUTHORIZATIONS_B).vertexIds().getTotalHits();
        GeAssert.assertEquals((long)count, (long)1L);
    }
}

