/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.google.common.collect.Lists;
import com.mware.ge.Authorizations;
import com.mware.ge.Direction;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.ElementType;
import com.mware.ge.ExtendedDataRowId;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.GeNotSupportedException;
import com.mware.ge.Graph;
import com.mware.ge.GraphWithSearchIndex;
import com.mware.ge.IdFetchHint;
import com.mware.ge.TextIndexHint;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.query.Compare;
import com.mware.ge.query.Contains;
import com.mware.ge.query.DefaultGraphQuery;
import com.mware.ge.query.DefaultGraphQueryIterable;
import com.mware.ge.query.GeoCompare;
import com.mware.ge.query.IterableWithTotalHits;
import com.mware.ge.query.Predicate;
import com.mware.ge.query.Query;
import com.mware.ge.query.QueryParameters;
import com.mware.ge.query.QueryResultsIterable;
import com.mware.ge.query.QueryStringQueryParameters;
import com.mware.ge.query.SimilarToGraphQuery;
import com.mware.ge.query.SortDirection;
import com.mware.ge.query.TextPredicate;
import com.mware.ge.query.aggregations.Aggregation;
import com.mware.ge.query.aggregations.CardinalityAggregation;
import com.mware.ge.query.aggregations.CardinalityResult;
import com.mware.ge.query.aggregations.ChronoFieldAggregation;
import com.mware.ge.query.aggregations.GeohashAggregation;
import com.mware.ge.query.aggregations.GeohashBucket;
import com.mware.ge.query.aggregations.GeohashResult;
import com.mware.ge.query.aggregations.HistogramAggregation;
import com.mware.ge.query.aggregations.HistogramBucket;
import com.mware.ge.query.aggregations.HistogramResult;
import com.mware.ge.query.aggregations.Percentile;
import com.mware.ge.query.aggregations.PercentilesAggregation;
import com.mware.ge.query.aggregations.PercentilesResult;
import com.mware.ge.query.aggregations.RangeAggregation;
import com.mware.ge.query.aggregations.RangeResult;
import com.mware.ge.query.aggregations.StatisticsAggregation;
import com.mware.ge.query.aggregations.StatisticsResult;
import com.mware.ge.query.aggregations.TermsAggregation;
import com.mware.ge.query.aggregations.TermsBucket;
import com.mware.ge.query.aggregations.TermsResult;
import com.mware.ge.util.ConvertingIterable;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.util.StreamUtils;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.NumberValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphQueryTests
implements GraphTestSetup {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(GraphQueryTests.class);
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testGraphQueryPagingForUniqueIdsSortedOrder() {
        String namePropertyName = "first.name";
        this.getGraph().defineProperty(namePropertyName).dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", namePropertyName, (Value)Values.stringValue((String)"B"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addPropertyValue("k1", namePropertyName, (Value)Values.stringValue((String)"A"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").addPropertyValue("k1", namePropertyName, (Value)Values.stringValue((String)"C"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable idsIterable = this.getGraph().query(AUTHORIZATIONS_A).sort("__ID__", SortDirection.ASCENDING).skip(0).limit(Integer.valueOf(1)).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).sort("__ID__", SortDirection.ASCENDING).skip(1).limit(Integer.valueOf(1)).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v2"});
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).sort("__ID__", SortDirection.ASCENDING).skip(2).limit(Integer.valueOf(1)).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v3"});
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).sort(namePropertyName, SortDirection.ASCENDING).vertexIds();
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).limit((Long)null).vertexIds();
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)idsIterable);
        List vertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A).sort(namePropertyName, SortDirection.ASCENDING).skip(0).limit(Integer.valueOf(1)).vertices());
        GeAssert.assertEquals((long)1L, (long)vertices.size());
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(0)).getId());
    }

    @Test
    public void testGraphQueryForIds() {
        String namePropertyName = "first.name";
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", namePropertyName, (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").addExtendedData("table1", "row1", namePropertyName, (Value)Values.stringValue((String)"value 1"), VISIBILITY_A).addExtendedData("table1", "row2", namePropertyName, (Value)Values.stringValue((String)"value 2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v2, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable idsIterable = this.getGraph().query(AUTHORIZATIONS_A).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v1", "v2", "v3"});
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).skip(1).vertexIds();
        GeAssert.assertResultsCount((int)2, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).limit(Integer.valueOf(1)).vertexIds();
        GeAssert.assertResultsCount((int)1, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).skip(1).limit(Integer.valueOf(1)).vertexIds();
        GeAssert.assertResultsCount((int)1, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).skip(3).vertexIds();
        GeAssert.assertResultsCount((int)0, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).skip(2).limit(Integer.valueOf(2)).vertexIds();
        GeAssert.assertResultsCount((int)1, (int)3, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).edgeIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"e1", "e2"});
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1"}).edgeIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"e1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1", "label2"}).edgeIds();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).elementIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v1", "v2", "v3", "e1", "e2"});
        GeAssert.assertResultsCount((int)5, (int)5, (IterableWithTotalHits)idsIterable);
        Assume.assumeTrue((String)"FetchHints.NONE vertex queries are not supported", (boolean)this.isFetchHintNoneVertexQuerySupported());
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).has(namePropertyName).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v1"});
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)idsIterable);
        QueryResultsIterable extendedDataRowIds = this.getGraph().query(AUTHORIZATIONS_A).hasExtendedData("table1").extendedDataRowIds();
        List rowIds = StreamUtils.stream((Iterable[])new Iterable[]{extendedDataRowIds}).map(ExtendedDataRowId::getRowId).collect(Collectors.toList());
        GeAssert.assertIdsAnyOrder(rowIds, (String[])new String[]{"row1", "row2"});
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)extendedDataRowIds);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).hasNot(namePropertyName).vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v2", "v3"});
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).has("notSetProp").vertexIds();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)idsIterable);
        idsIterable = this.getGraph().query(AUTHORIZATIONS_A).hasNot("notSetProp").vertexIds();
        GeAssert.assertIdsAnyOrder((Iterable)idsIterable, (String[])new String[]{"v1", "v2", "v3"});
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)idsIterable);
        try {
            this.getGraph().query(AUTHORIZATIONS_A).has("notSetProp", (Predicate)Compare.NOT_EQUAL, (Value)Values.intValue((int)5)).vertexIds();
            GeAssert.fail((String)"Value queries should not be allowed for properties that are not defined.");
        }
        catch (GeException ve) {
            GeAssert.assertEquals((Object)"Could not find property definition for property name: notSetProp", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGraphQueryForEdgesUsingInOutVertexIds() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e3", v3, v1, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).has("__outVertexId", (Value)Values.stringValue((String)"v1")).has("__inVertexId", (Value)Values.stringValue((String)"v2")).edges();
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{"e1"});
        edges = this.getGraph().query(AUTHORIZATIONS_A).has("__outVertexId", (Value)Values.stringValue((String)"v1")).edges();
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{"e1", "e2"});
    }

    @Test
    public void testGraphQueryForEdgesUsingEdgeLabel() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v3, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e3", v3, v1, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).has("__edgeLabel", (Value)Values.stringValue((String)"label1")).edges();
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{"e1"});
        edges = this.getGraph().query(AUTHORIZATIONS_A).has("__edgeLabel", (Value)Values.stringValue((String)"label2")).edges();
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{"e2", "e3"});
    }

    @Test
    public void testGraphQueryForEdgesUsingInOrOutVertexId() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e3", v2, v3, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).has("__inOrOutVertexId", (Value)Values.stringValue((String)"v1")).edges();
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{"e1", "e2"});
    }

    @Test
    public void testGraphQuery() {
        String namePropertyName = "first.name";
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", namePropertyName, (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().addEdge("e2", v1, v2, "label2", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).skip(1).vertices();
        GeAssert.assertResultsCount((int)1, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).limit(Integer.valueOf(1)).vertices();
        GeAssert.assertResultsCount((int)1, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).skip(1).limit(Integer.valueOf(1)).vertices();
        GeAssert.assertResultsCount((int)1, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).skip(2).vertices();
        GeAssert.assertResultsCount((int)0, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).skip(1).limit(Integer.valueOf(2)).vertices();
        GeAssert.assertResultsCount((int)1, (int)2, (IterableWithTotalHits)vertices);
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).edges();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)edges);
        edges = this.getGraph().query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1"}).edges();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)edges);
        edges = this.getGraph().query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1", "label2"}).edges();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)edges);
        QueryResultsIterable elements = this.getGraph().query(AUTHORIZATIONS_A).elements();
        GeAssert.assertResultsCount((int)4, (int)4, (IterableWithTotalHits)elements);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(namePropertyName).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot(namePropertyName).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("notSetProp").vertices();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot("notSetProp").vertices();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1"}).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1", "v2"}).vertices();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1", "v2"}).hasId(new String[]{"v1"}).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1"}).hasId(new String[]{"v2"}).vertices();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        edges = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"e1"}).edges();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)edges);
        edges = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"e1", "e2"}).edges();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)edges);
        try {
            this.getGraph().query(AUTHORIZATIONS_A).has("notSetProp", (Predicate)Compare.NOT_EQUAL, (Value)Values.intValue((int)5)).vertices();
            GeAssert.fail((String)"Value queries should not be allowed for properties that are not defined.");
        }
        catch (GeException ve) {
            GeAssert.assertEquals((Object)"Could not find property definition for property name: notSetProp", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGraphQueryWithBoolean() {
        this.getGraph().defineProperty("boolean").dataType(BooleanValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "boolean", (Value)BooleanValue.TRUE, VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query("zzzzz", AUTHORIZATIONS_A).vertices();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("boolean", (Value)BooleanValue.TRUE).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("boolean", (Value)BooleanValue.FALSE).vertices();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertices);
    }

    @Test
    public void testClosingIterables() throws IOException {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"matt"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Iterable vertices1 = this.getGraph().getVertices(AUTHORIZATIONS_A);
        if (vertices1 instanceof Closeable) {
            ((Closeable)((Object)vertices1)).close();
        }
        vertices1 = this.getGraph().getVertices(AUTHORIZATIONS_A);
        IterableUtils.toList((Iterable)vertices1);
        if (vertices1 instanceof Closeable) {
            ((Closeable)((Object)vertices1)).close();
        }
        QueryResultsIterable queryResults = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1"}).vertices();
        queryResults.close();
        queryResults = this.getGraph().query(AUTHORIZATIONS_A).hasId(new String[]{"v1"}).vertices();
        IterableUtils.toList((Iterable)queryResults);
        queryResults.close();
    }

    @Test
    public void testGraphQueryWithFetchHints() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"matt"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().addEdge("e1", "v1", "v2", "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertTrue((this.getGraph().getVertexCount(AUTHORIZATIONS_A) == 3L ? 1 : 0) != 0);
        FetchHints propertiesFetchHints = FetchHints.builder().setIncludeAllProperties(true).build();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Value)Values.stringValue((String)"joe")).vertices(propertiesFetchHints);
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
        Assume.assumeTrue((String)"FetchHints.NONE vertex queries are not supported", (boolean)this.isFetchHintNoneVertexQuerySupported());
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Value)Values.stringValue((String)"joe")).vertices(FetchHints.ALL);
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertices);
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).has("__edgeLabel", (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"label1")).edges(FetchHints.EDGE_REFS);
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)edges);
    }

    @Test
    public void testGraphQueryWithQueryString() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v1.setProperty("description", (Value)Values.stringValue((String)"This is vertex 1 - dog."), VISIBILITY_A, AUTHORIZATIONS_ALL);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v2.setProperty("description", (Value)Values.stringValue((String)"This is vertex 2 - cat."), VISIBILITY_B, AUTHORIZATIONS_ALL);
        Edge e1 = this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        e1.setProperty("description", (Value)Values.stringValue((String)"This is edge 1 - dog to cat."), VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query("vertex", AUTHORIZATIONS_A_AND_B).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("vertex", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("dog", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("dog", AUTHORIZATIONS_B).vertices();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
        QueryResultsIterable elements = this.getGraph().query("dog", AUTHORIZATIONS_A_AND_B).elements();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)elements));
    }

    @Test
    public void testGraphQueryWithQueryStringWithAuthorizations() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v1.setProperty("description", (Value)Values.stringValue((String)"This is vertex 1 - dog."), VISIBILITY_A, AUTHORIZATIONS_ALL);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_B, AUTHORIZATIONS_ALL, "thing");
        v2.setProperty("description", (Value)Values.stringValue((String)"This is vertex 2 - cat."), VISIBILITY_B, AUTHORIZATIONS_ALL);
        Edge e1 = this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_ALL);
        e1.setProperty("edgeDescription", (Value)Values.stringValue((String)"This is edge 1 - dog to cat."), VISIBILITY_A, AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        if (this.isIterableWithTotalHitsSupported((Iterable<Vertex>)vertices)) {
            IterableWithTotalHits hits = (IterableWithTotalHits)vertices;
            GeAssert.assertEquals((long)1L, (long)hits.getTotalHits());
        }
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).edges();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)edges));
    }

    @Test
    public void testGraphQueryHas() {
        String agePropertyName = "age.property";
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"hello"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)25), VISIBILITY_EMPTY).setProperty("birthDate", (Value)this.createDate(1989, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Value)this.createDate(2014, 2, 24, 13, 0, 5), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"world"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)30), VISIBILITY_A).setProperty("birthDate", (Value)this.createDate(1984, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Value)this.createDate(2014, 2, 25, 13, 0, 5), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        try {
            vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot(agePropertyName).vertices();
            GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
        }
        catch (GeNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).has("birthDate", (Predicate)Compare.EQUAL, (Value)this.createDate(1989, 1, 5)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("hello", AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).has("birthDate", (Predicate)Compare.EQUAL, (Value)this.createDate(1989, 1, 5)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("birthDate", (Predicate)Compare.EQUAL, (Value)this.createDate(1989, 1, 5)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("lastAccessed", (Predicate)Compare.EQUAL, (Value)this.createDate(2014, 2, 24, 13, 0, 5)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)((Vertex)IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName));
        try {
            vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot(agePropertyName, (Value)Values.intValue((int)25)).vertices();
            GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
            GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)((Vertex)IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName));
        }
        catch (GeNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.GREATER_THAN_EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.IN, (Value)Values.intArray((int[])new int[]{25})).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)((Vertex)IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName));
        try {
            vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.NOT_IN, (Value)Values.intArray((int[])new int[]{25})).vertices();
            GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
            GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)((Vertex)IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue(agePropertyName));
        }
        catch (GeNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.IN, (Value)Values.intArray((int[])new int[]{25, 30})).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.GREATER_THAN, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.LESS_THAN, (Value)Values.intValue((int)26)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.LESS_THAN_EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Compare.NOT_EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("__ID__", (Predicate)Compare.NOT_EQUAL, (Value)Values.stringValue((String)"v1")).vertices();
        GeAssert.assertElementIds((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("lastAccessed", (Predicate)Compare.EQUAL, (Value)this.createDate(2014, 2, 24)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("*", AUTHORIZATIONS_A).has(agePropertyName, (Predicate)Contains.IN, (Value)Values.intArray((int[])new int[]{25, 30})).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testStartsWithQuery() {
        this.getGraph().defineProperty("location").dataType(GeoPointValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("text").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"hello world"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"junit says hello"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("text", (Predicate)Compare.STARTS_WITH, (Value)Values.stringValue((String)"hel")).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("text", (Predicate)Compare.STARTS_WITH, (Value)Values.stringValue((String)"foo")).vertices();
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
    }

    @Test
    public void testGraphQueryMultiPropertyHas() {
        this.getGraph().defineProperty("unusedFloatProp").dataType(FloatValue.class).define();
        this.getGraph().defineProperty("unusedDateProp").dataType(DateValue.class).define();
        this.getGraph().defineProperty("unusedStringProp").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        String agePropertyName = "age.property";
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"hello"), VISIBILITY_A).setProperty("text2", (Value)Values.stringValue((String)"foo"), VISIBILITY_A).setProperty("text3", (Value)Values.stringValue((String)"bar"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)25), VISIBILITY_A).setProperty("birthDate", (Value)this.createDate(1989, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Value)this.createDate(2014, 2, 24, 13, 0, 5), VISIBILITY_A).setProperty("location", (Value)Values.geoPointValue((double)38.9544, (double)-77.3464), VISIBILITY_A).addExtendedData("table1", "row1", "column1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"world"), VISIBILITY_A).setProperty("text2", (Value)Values.stringValue((String)"foo"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)30), VISIBILITY_A).setProperty("birthDate", (Value)this.createDate(1984, 1, 5), VISIBILITY_A).setProperty("lastAccessed", (Value)this.createDate(2014, 2, 25, 13, 0, 5), VISIBILITY_A).setProperty("location", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has(TextValue.class).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot(TextValue.class).vertices();
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
        try {
            this.getGraph().query(AUTHORIZATIONS_A).has(DoubleValue.class).vertices();
            GeAssert.fail((String)"Should not allow searching for a dataType that there are no mappings for");
        }
        catch (GeException geException) {
            // empty catch block
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(FloatValue.class).vertices();
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot(FloatValue.class).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(Arrays.asList("text3", "unusedStringProp")).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasNot(Arrays.asList("text3", "unusedStringProp")).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(TextValue.class, (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"hello")).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(TextValue.class, (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"foo")).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(Arrays.asList("text", "text2"), (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"hello")).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(Arrays.asList("text", "text2"), (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"foo")).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(Arrays.asList("text"), (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"foo")).vertices();
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(NumberValue.class, (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(DateTimeValue.class, (Predicate)Compare.GREATER_THAN, (Value)this.createDate(2014, 2, 25, 0, 0, 0)).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(DateTimeValue.class, (Predicate)Compare.LESS_THAN, (Value)this.createDate(2014, 2, 25, 0, 0, 0)).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(DateValue.class, (Predicate)Compare.LESS_THAN, (Value)this.createDate(1985, 1, 5)).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(DateValue.class, (Predicate)Compare.GREATER_THAN, (Value)this.createDate(2000, 1, 1)).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(GeoShapeValue.class, (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(GeoPointValue.class, (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)1.0)).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(GeoPointValue.class, (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)38.9186, (double)-77.2297, (double)25.0)).vertices();
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2"});
        try {
            this.getGraph().query(AUTHORIZATIONS_A).has(DoubleValue.class, (Predicate)Compare.EQUAL, (Value)Values.doubleValue((double)25.0)).vertices();
            GeAssert.fail((String)"Should not allow searching for a dataType that there are no mappings for");
        }
        catch (GeException geException) {
            // empty catch block
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has(FloatValue.class, (Predicate)Compare.EQUAL, (Value)Values.floatValue((float)25.0f)).vertices();
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
    }

    @Test
    public void testGraphQueryHasAuthorization() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"hello"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("text.with.dots", (Value)Values.stringValue((String)"world"), VISIBILITY_B).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v3", VISIBILITY_C, "thing").setProperty("text", (Value)Values.stringValue((String)"world"), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_ALL).hasAuthorization(new String[]{"a"}).vertices();
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2", "v3"});
        vertices = this.getGraph().query(AUTHORIZATIONS_ALL).hasAuthorization(new String[]{"b"}).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v2"});
        vertices = this.getGraph().query(AUTHORIZATIONS_ALL).hasAuthorization(new String[]{"c"}).vertices();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v3"});
    }

    @Test
    public void testGraphQueryHasAuthorizationWithHidden() {
        Vertex v1 = this.getGraph().addVertex("v1", Visibility.EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", Visibility.EMPTY, AUTHORIZATIONS_A, "thing");
        Vertex v3 = (Vertex)this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("junit", "name", (Value)Values.stringValue((String)"value"), VISIBILITY_B).save(AUTHORIZATIONS_B_AND_C);
        Edge e1 = this.getGraph().addEdge("e1", v1.getId(), v2.getId(), "junit edge", Visibility.EMPTY, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().markEdgeHidden(e1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().markVertexHidden(v1, VISIBILITY_A, AUTHORIZATIONS_A);
        v3.markPropertyHidden("junit", "name", VISIBILITY_B, VISIBILITY_C, AUTHORIZATIONS_B_AND_C);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).vertices(FetchHints.ALL);
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
        QueryResultsIterable vertexIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).vertexIds(IdFetchHint.NONE);
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertexIds);
        vertexIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).vertexIds();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)vertexIds);
        vertices = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).vertices(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v1.getId()});
        vertices = this.getGraph().query(AUTHORIZATIONS_B_AND_C).hasAuthorization(new String[]{"c"}).vertices(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v3.getId()});
        vertexIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).vertexIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertexIds);
        GeAssert.assertIdsAnyOrder((Iterable)vertexIds, (String[])new String[]{v1.getId()});
        vertexIds = this.getGraph().query(AUTHORIZATIONS_B_AND_C).hasAuthorization(new String[]{"c"}).vertexIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)vertexIds);
        GeAssert.assertIdsAnyOrder((Iterable)vertexIds, (String[])new String[]{v3.getId()});
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).edges(FetchHints.ALL);
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)edges);
        QueryResultsIterable edgeIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).edgeIds(IdFetchHint.NONE);
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)edgeIds);
        edgeIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).edgeIds();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)edgeIds);
        edges = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).edges(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)edges);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{e1.getId()});
        edgeIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).edgeIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)edgeIds);
        GeAssert.assertIdsAnyOrder((Iterable)edgeIds, (String[])new String[]{e1.getId()});
        QueryResultsIterable elements = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).elements(FetchHints.ALL);
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)elements);
        QueryResultsIterable elementIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).elementIds(IdFetchHint.NONE);
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)elementIds);
        elementIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).elementIds();
        GeAssert.assertResultsCount((int)0, (int)0, (IterableWithTotalHits)elementIds);
        elements = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).elements(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)elements);
        GeAssert.assertElementIdsAnyOrder((Iterable)elements, (String[])new String[]{v1.getId(), e1.getId()});
        elementIds = this.getGraph().query(AUTHORIZATIONS_A).hasAuthorization(new String[]{"a"}).elementIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)elementIds);
        GeAssert.assertIdsAnyOrder((Iterable)elementIds, (String[])new String[]{v1.getId(), e1.getId()});
    }

    @Test
    public void testGraphQueryContainsNotIn() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("status", (Value)Values.stringValue((String)"0"), VISIBILITY_A).setProperty("name", (Value)Values.stringValue((String)"susan"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("status", (Value)Values.stringValue((String)"1"), VISIBILITY_A).setProperty("name", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v5", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v6", VISIBILITY_A, "thing").setProperty("status", (Value)Values.stringValue((String)"0"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        try {
            QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("status", (Predicate)Contains.NOT_IN, (Value)Values.stringArray((String[])new String[]{"0"})).vertices();
            GeAssert.assertEquals((long)4L, (long)IterableUtils.count((Iterable)vertices));
            vertices = this.getGraph().query(AUTHORIZATIONS_A).has("status", (Predicate)Contains.NOT_IN, (Value)Values.stringArray((String[])new String[]{"0", "1"})).vertices();
            GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)vertices));
        }
        catch (GeNotSupportedException ex) {
            LOGGER.warn("skipping. Not supported", (Throwable)ex);
        }
    }

    @Test
    public void testGraphQueryHasGeoPointAndExact() {
        this.getGraph().defineProperty("location").dataType(GeoPointValue.class).define();
        this.getGraph().defineProperty("exact").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"val1"), VISIBILITY_A).setProperty("exact", (Value)Values.stringValue((String)"val1"), VISIBILITY_A).setProperty("location", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop2", (Value)Values.stringValue((String)"val2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).has("prop1").elements();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)results));
        GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertEquals((Object)"v1", (Object)((Element)results.iterator().next()).getId());
        results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).has("exact").elements();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)results));
        GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertEquals((Object)"v1", (Object)((Element)results.iterator().next()).getId());
        results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).has("location").elements();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)results));
        GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertEquals((Object)"v1", (Object)((Element)results.iterator().next()).getId());
    }

    @Test
    public void testGraphQueryHasNotGeoPointAndExact() {
        this.getGraph().defineProperty("location").dataType(GeoPointValue.class).define();
        this.getGraph().defineProperty("exact").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"val1"), VISIBILITY_A).setProperty("exact", (Value)Values.stringValue((String)"val2"), VISIBILITY_A).setProperty("location", (Value)Values.geoPointValue((double)38.9186, (double)-77.2297), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop2", (Value)Values.stringValue((String)"val2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).hasNot("prop1").elements();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)results));
        GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertEquals((Object)"v2", (Object)((Element)results.iterator().next()).getId());
        results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).hasNot("prop3").sort("__ID__", SortDirection.ASCENDING).elements();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)results));
        Iterator iterator = results.iterator();
        GeAssert.assertEquals((Object)"v1", (Object)((Element)iterator.next()).getId());
        GeAssert.assertEquals((Object)"v2", (Object)((Element)iterator.next()).getId());
        results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).hasNot("exact").elements();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)results));
        GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertEquals((Object)"v2", (Object)((Element)results.iterator().next()).getId());
        results = this.getGraph().query("*", AUTHORIZATIONS_A_AND_B).hasNot("location").elements();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)results));
        GeAssert.assertEquals((long)1L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertEquals((Object)"v2", (Object)((Element)results.iterator().next()).getId());
    }

    @Test
    public void testGraphQueryHasTwoVisibilities() {
        String agePropertyName = "age.property";
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"v1"), VISIBILITY_A).setProperty(agePropertyName, (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"v2"), VISIBILITY_A).addPropertyValue("k1", agePropertyName, (Value)Values.intValue((int)30), VISIBILITY_A).addPropertyValue("k2", agePropertyName, (Value)Values.intValue((int)35), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"v3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has(agePropertyName).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).hasNot(agePropertyName).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryIn() {
        String namePropertyName = "full.name";
        this.getGraph().defineProperty("age").dataType(IntValue.class).sortable(true).define();
        this.getGraph().defineProperty(namePropertyName).dataType(TextValue.class).sortable(true).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"joe ferner"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"bob smith"), VISIBILITY_B).setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty(namePropertyName, (Value)Values.stringValue((String)"tom thumb"), VISIBILITY_A).setProperty("age", (Value)Values.intValue((int)30), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable results = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has(namePropertyName, (Predicate)Contains.IN, (Value)Values.stringArray((String[])new String[]{"joe ferner", "tom thumb"})).vertices();
        GeAssert.assertEquals((long)2L, (long)((IterableWithTotalHits)results).getTotalHits());
        GeAssert.assertVertexIdsAnyOrder((Iterable)results, (String[])new String[]{"v1", "v3"});
    }

    @Test
    public void testGraphQueryHidden() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Edge e1 = this.getGraph().addEdge("e1", "v1", "v2", "junit edge", VISIBILITY_A, AUTHORIZATIONS_A);
        Edge e2 = this.getGraph().addEdge("e2", "v2", "v3", "junit edge", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        this.getGraph().markEdgeHidden(e1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().markVertexHidden(v1, VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices(FetchHints.ALL);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v2.getId(), v3.getId()});
        QueryResultsIterable vertexIds = this.getGraph().query(AUTHORIZATIONS_A).vertexIds(IdFetchHint.NONE);
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertexIds);
        GeAssert.assertIdsAnyOrder((Iterable)vertexIds, (String[])new String[]{v2.getId(), v3.getId()});
        vertexIds = this.getGraph().query(AUTHORIZATIONS_A).vertexIds();
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)vertexIds);
        GeAssert.assertIdsAnyOrder((Iterable)vertexIds, (String[])new String[]{v2.getId(), v3.getId()});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)3, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{v1.getId(), v2.getId(), v3.getId()});
        vertexIds = this.getGraph().query(AUTHORIZATIONS_A).vertexIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)vertexIds);
        GeAssert.assertIdsAnyOrder((Iterable)vertexIds, (String[])new String[]{v1.getId(), v2.getId(), v3.getId()});
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).edges(FetchHints.ALL);
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)edges);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{e2.getId()});
        QueryResultsIterable edgeIds = this.getGraph().query(AUTHORIZATIONS_A).edgeIds(IdFetchHint.NONE);
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)edgeIds);
        GeAssert.assertIdsAnyOrder((Iterable)edgeIds, (String[])new String[]{e2.getId()});
        edgeIds = this.getGraph().query(AUTHORIZATIONS_A).edgeIds();
        GeAssert.assertResultsCount((int)1, (int)1, (IterableWithTotalHits)edgeIds);
        GeAssert.assertIdsAnyOrder((Iterable)edgeIds, (String[])new String[]{e2.getId()});
        edges = this.getGraph().query(AUTHORIZATIONS_A).edges(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)2, (QueryResultsIterable)edges);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)edges, (String[])new String[]{e1.getId(), e2.getId()});
        edgeIds = this.getGraph().query(AUTHORIZATIONS_A).edgeIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)2, (int)2, (IterableWithTotalHits)edgeIds);
        GeAssert.assertIdsAnyOrder((Iterable)edgeIds, (String[])new String[]{e1.getId(), e2.getId()});
        QueryResultsIterable elements = this.getGraph().query(AUTHORIZATIONS_A).elements(FetchHints.ALL);
        GeAssert.assertResultsCount((int)3, (QueryResultsIterable)elements);
        GeAssert.assertElementIdsAnyOrder((Iterable)elements, (String[])new String[]{v2.getId(), v3.getId(), e2.getId()});
        QueryResultsIterable elementIds = this.getGraph().query(AUTHORIZATIONS_A).elementIds(IdFetchHint.NONE);
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)elementIds);
        GeAssert.assertIdsAnyOrder((Iterable)elementIds, (String[])new String[]{v2.getId(), v3.getId(), e2.getId()});
        elementIds = this.getGraph().query(AUTHORIZATIONS_A).elementIds();
        GeAssert.assertResultsCount((int)3, (int)3, (IterableWithTotalHits)elementIds);
        GeAssert.assertIdsAnyOrder((Iterable)elementIds, (String[])new String[]{v2.getId(), v3.getId(), e2.getId()});
        elements = this.getGraph().query(AUTHORIZATIONS_A).elements(FetchHints.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)5, (QueryResultsIterable)elements);
        GeAssert.assertElementIdsAnyOrder((Iterable)elements, (String[])new String[]{v1.getId(), v2.getId(), v3.getId(), e1.getId(), e2.getId()});
        elementIds = this.getGraph().query(AUTHORIZATIONS_A).elementIds(IdFetchHint.ALL_INCLUDING_HIDDEN);
        GeAssert.assertResultsCount((int)5, (int)5, (IterableWithTotalHits)elementIds);
        GeAssert.assertIdsAnyOrder((Iterable)elementIds, (String[])new String[]{v1.getId(), v2.getId(), v3.getId(), e1.getId(), e2.getId()});
    }

    @Test
    public void testGraphQueryVertexWithVisibilityChange() {
        Vertex v1 = this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{v1.getId()});
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v1 = (Vertex)v1.prepareMutation().alterElementVisibility(VISIBILITY_EMPTY).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)VISIBILITY_EMPTY, (Object)v1.getVisibility());
        vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices();
        GeAssert.assertResultsCount((int)1, (QueryResultsIterable)vertices);
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{v1.getId()});
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        vertices = this.getGraph().query(AUTHORIZATIONS_A).vertices();
        GeAssert.assertResultsCount((int)0, (QueryResultsIterable)vertices);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityCantSeeVertex() {
        this.getGraph().prepareVertex("v1", VISIBILITY_B, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryVertexHasWithSecurityCantSeeProperty() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryEdgeHasWithSecurity() {
        Vertex v1 = this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        Vertex v3 = this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e2", v1, v3, "label1", VISIBILITY_A).setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).edges();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)edges));
    }

    @Test
    public void testGraphQueryUpdateVertex() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        Vertex v3 = this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().addEdge("v2tov3", v2, v3, "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").setProperty("name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").setProperty("name", (Value)Values.stringValue((String)"Bob"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").setProperty("name", (Value)Values.stringValue((String)"Same"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List allVertices = IterableUtils.toList((Iterable)this.getGraph().query(AUTHORIZATIONS_A_AND_B).vertices());
        GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)allVertices));
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("name", (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"Joe")).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("age", (Predicate)Compare.EQUAL, (Value)Values.intValue((int)25)).has("name", (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"Joe")).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testQueryWithVertexIds() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)30), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)35), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        List vertices = IterableUtils.toList((Iterable)this.getGraph().query(new String[]{"v1", "v2"}, AUTHORIZATIONS_A).has("age", (Predicate)Compare.GREATER_THAN, (Value)Values.intValue((int)27)).vertices());
        GeAssert.assertEquals((long)1L, (long)vertices.size());
        GeAssert.assertEquals((Object)"v2", (Object)((Vertex)vertices.get(0)).getId());
        vertices = IterableUtils.toList((Iterable)this.getGraph().query(new String[]{"v1", "v2", "v3"}, AUTHORIZATIONS_A).has("age", (Predicate)Compare.GREATER_THAN, (Value)Values.intValue((int)27)).vertices());
        GeAssert.assertEquals((long)2L, (long)vertices.size());
        List vertexIds = IterableUtils.toList((Iterable)new ConvertingIterable<Vertex, String>((Iterable)vertices){

            protected String convert(Vertex o) {
                return o.getId();
            }
        });
        GeAssert.assertTrue((String)"v2 not found", (boolean)vertexIds.contains("v2"));
        GeAssert.assertTrue((String)"v3 not found", (boolean)vertexIds.contains("v3"));
    }

    @Test
    public void testDisableEdgeIndexing() {
        Assume.assumeTrue((String)"disabling indexing not supported", (boolean)this.disableEdgeIndexing(this.getGraph()));
        Vertex v1 = this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", v1, v2, "label1", VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable edges = this.getGraph().query(AUTHORIZATIONS_A).has("prop1", (Value)Values.stringValue((String)"value1")).edges();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)edges));
    }

    @Test
    public void testGraphQueryHasWithSpaces() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"Joe Ferner"), VISIBILITY_A).setProperty("propWithNonAlphaCharacters", (Value)Values.stringValue((String)"hyphen-word, etc."), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"Joe Smith"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query("Ferner", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)1L, (long)vertices.getTotalHits());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("joe", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)2L, (long)vertices.getTotalHits());
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        if (this.isLuceneQueriesSupported()) {
            vertices = this.getGraph().query("joe AND ferner", AUTHORIZATIONS_A).vertices();
            GeAssert.assertEquals((long)1L, (long)vertices.getTotalHits());
            GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        }
        if (this.isLuceneQueriesSupported()) {
            vertices = this.getGraph().query("joe smith", AUTHORIZATIONS_A).vertices();
            List verticesList = IterableUtils.toList((Iterable)vertices);
            GeAssert.assertEquals((long)2L, (long)verticesList.size());
            boolean foundV1 = false;
            boolean foundV2 = false;
            for (Vertex v : verticesList) {
                if (v.getId().equals("v1")) {
                    foundV1 = true;
                    continue;
                }
                if (v.getId().equals("v2")) {
                    foundV2 = true;
                    continue;
                }
                throw new RuntimeException("Invalid vertex id: " + v.getId());
            }
            GeAssert.assertTrue((boolean)foundV1);
            GeAssert.assertTrue((boolean)foundV2);
        }
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Ferner")).vertices();
        GeAssert.assertEquals((long)1L, (long)vertices.getTotalHits());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Joe")).has("name", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Ferner")).vertices();
        GeAssert.assertEquals((long)1L, (long)vertices.getTotalHits());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("name", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Joe Ferner")).vertices();
        GeAssert.assertEquals((long)1L, (long)vertices.getTotalHits());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("propWithNonAlphaCharacters", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"hyphen-word, etc.")).vertices();
        GeAssert.assertEquals((long)1L, (long)vertices.getTotalHits());
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryWithANDOperatorAndWithExactMatchFields() {
        this.getGraph().defineProperty("firstName").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).setProperty("lastName", (Value)Values.stringValue((String)"Ferner"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("firstName", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).setProperty("lastName", (Value)Values.stringValue((String)"Smith"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Assume.assumeTrue((String)"lucene and queries not supported", (this.isLuceneQueriesSupported() && this.isLuceneAndQueriesSupported() ? 1 : 0) != 0);
        QueryResultsIterable vertices = this.getGraph().query("Joe AND ferner", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryHasWithSpacesAndFieldedQueryString() {
        Assume.assumeTrue((String)"fielded query not supported", (boolean)this.isFieldNamesInQuerySupported());
        this.getGraph().defineProperty("name").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"Joe Ferner"), VISIBILITY_A).setProperty("propWithHyphen", (Value)Values.stringValue((String)"hyphen-word"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("name", (Value)Values.stringValue((String)"Joe Smith"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Assume.assumeTrue((String)"lucene queries", (boolean)this.isLuceneQueriesSupported());
        QueryResultsIterable vertices = this.getGraph().query("name:Joe", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("name:\"Joe Ferner\"", AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("name:Fer*", AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("name:Fer*er", AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("name:/f.*r/", AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("name:terner~", AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query("name:{Fern TO Gern}", AUTHORIZATIONS_A).vertices();
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testGraphQueryRange() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)25), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("age", (Value)Values.intValue((int)30), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)25), (Value)Values.intValue((int)25)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)20), (Value)Values.intValue((int)29)).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)25), (Value)Values.intValue((int)30)).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)25), true, (Value)Values.intValue((int)30), false).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)((Vertex)IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("age"));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)25), false, (Value)Values.intValue((int)30), true).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)((Vertex)IterableUtils.toList((Iterable)vertices).get(0)).getPropertyValue("age"));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)25), true, (Value)Values.intValue((int)30), true).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        vertices = this.getGraph().query(AUTHORIZATIONS_A).range("age", (Value)Values.intValue((int)25), false, (Value)Values.intValue((int)30), false).vertices();
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)vertices));
    }

    @Test
    public void testVertexQuery() {
        String propertyName = "prop.one";
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v1.setProperty(propertyName, (Value)Values.stringValue((String)"value1"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v2.setProperty(propertyName, (Value)Values.stringValue((String)"value2"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        Vertex v3 = this.getGraph().addVertex("v3", VISIBILITY_A, AUTHORIZATIONS_ALL, "thing");
        v3.setProperty(propertyName, (Value)Values.stringValue((String)"value3"), VISIBILITY_A, AUTHORIZATIONS_ALL);
        Edge ev1v2 = (Edge)this.getGraph().prepareEdge("e v1->v2", v1, v2, "label1", VISIBILITY_A).setProperty(propertyName, (Value)Values.stringValue((String)"value1"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        Edge ev1v3 = (Edge)this.getGraph().prepareEdge("e v1->v3", v1, v3, "label2", VISIBILITY_A).setProperty(propertyName, (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e v2->v3", v2, v3, "label2", VISIBILITY_A).setProperty(propertyName, (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        QueryResultsIterable vertices = v1.query(AUTHORIZATIONS_A).vertices();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)vertices));
        IterableUtils.assertContains((Object)v2, (Iterable)vertices);
        IterableUtils.assertContains((Object)v3, (Iterable)vertices);
        if (this.isIterableWithTotalHitsSupported((Iterable<Vertex>)vertices)) {
            GeAssert.assertEquals((long)2L, (long)((IterableWithTotalHits)vertices).getTotalHits());
            vertices = v1.query(AUTHORIZATIONS_A).limit(Integer.valueOf(1)).vertices();
            GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
            GeAssert.assertEquals((long)2L, (long)((IterableWithTotalHits)vertices).getTotalHits());
        }
        vertices = v1.query(AUTHORIZATIONS_A).has(propertyName, (Value)Values.stringValue((String)"value2")).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        IterableUtils.assertContains((Object)v2, (Iterable)vertices);
        QueryResultsIterable edges = v1.query(AUTHORIZATIONS_A).edges();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)edges));
        IterableUtils.assertContains((Object)ev1v2, (Iterable)edges);
        IterableUtils.assertContains((Object)ev1v3, (Iterable)edges);
        edges = v1.query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1", "label2"}).edges();
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)edges));
        IterableUtils.assertContains((Object)ev1v2, (Iterable)edges);
        IterableUtils.assertContains((Object)ev1v3, (Iterable)edges);
        edges = v1.query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1"}).edges();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)edges));
        IterableUtils.assertContains((Object)ev1v2, (Iterable)edges);
        vertices = v1.query(AUTHORIZATIONS_A).hasEdgeLabel(new String[]{"label1"}).vertices();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)vertices));
        IterableUtils.assertContains((Object)v2, (Iterable)vertices);
        GeAssert.assertVertexIdsAnyOrder((Iterable)v1.query(AUTHORIZATIONS_A).hasDirection(Direction.OUT).vertices(), (String[])new String[]{"v2", "v3"});
        GeAssert.assertVertexIdsAnyOrder((Iterable)v1.query(AUTHORIZATIONS_A).hasDirection(Direction.IN).vertices(), (String[])new String[0]);
        GeAssert.assertEdgeIdsAnyOrder((Iterable)v1.query(AUTHORIZATIONS_A).hasDirection(Direction.OUT).edges(), (String[])new String[]{"e v1->v2", "e v1->v3"});
        GeAssert.assertEdgeIdsAnyOrder((Iterable)v1.query(AUTHORIZATIONS_A).hasDirection(Direction.IN).edges(), (String[])new String[0]);
        GeAssert.assertVertexIdsAnyOrder((Iterable)v1.query(AUTHORIZATIONS_A).hasOtherVertexId("v2").vertices(), (String[])new String[]{"v2"});
        GeAssert.assertEdgeIds((Iterable)v1.query(AUTHORIZATIONS_A).hasOtherVertexId("v2").edges(), (String[])new String[]{"e v1->v2"});
    }

    @Test
    public void testGraphQueryEdgeWithTermsAggregationAlterElementVisibility() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_A).addPropertyValue("k1", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Edge e1 = this.getGraph().getEdge("e1", AUTHORIZATIONS_A_AND_B);
        e1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.EDGE, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.EDGE, AUTHORIZATIONS_A);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.EDGE, AUTHORIZATIONS_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)propertyCountByValue.size());
    }

    @Test
    public void testGraphQueryWithNestedTermsAggregation() {
        this.getGraph().defineProperty("name").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("gender").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"male"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"male"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"female"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"female"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Query q = this.getGraph().query(AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        TermsResult aggregationResult = (TermsResult)q.vertices().getAggregationResult("terms-count", TermsResult.class);
        Map<Object, Map<Object, Long>> vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
    }

    @Test
    public void testVertexQueryWithNestedTermsAggregation() {
        this.getGraph().defineProperty("name").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("gender").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"male"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"male"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"female"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v5", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addPropertyValue("k1", "gender", (Value)Values.stringValue((String)"female"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().addEdge("v1", "v2", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.getGraph().addEdge("v1", "v3", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.getGraph().addEdge("v1", "v4", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.getGraph().addEdge("v1", "v5", "label1", VISIBILITY_EMPTY, AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Query q = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).query(AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        TermsResult aggregationResult = (TermsResult)q.vertices().getAggregationResult("terms-count", TermsResult.class);
        Map<Object, Map<Object, Long>> vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
    }

    @Test
    public void testVertexQueryWithNestedTermsAggregationOnExtendedData() {
        this.getGraph().defineProperty("name").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("gender").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addExtendedData("t1", "r1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addExtendedData("t1", "r1", "gender", (Value)Values.stringValue((String)"male"), VISIBILITY_EMPTY).addExtendedData("t1", "r2", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addExtendedData("t1", "r2", "gender", (Value)Values.stringValue((String)"male"), VISIBILITY_EMPTY).addExtendedData("t1", "r3", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addExtendedData("t1", "r3", "gender", (Value)Values.stringValue((String)"female"), VISIBILITY_EMPTY).addExtendedData("t1", "r4", "name", (Value)Values.stringValue((String)"Sam"), VISIBILITY_EMPTY).addExtendedData("t1", "r4", "gender", (Value)Values.stringValue((String)"female"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        Query q = v1.getExtendedData("t1").query(AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        TermsAggregation agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        TermsResult aggregationResult = (TermsResult)q.extendedDataRows().getAggregationResult("terms-count", TermsResult.class);
        Map<Object, Map<Object, Long>> vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
        q = v1.getExtendedData().query(AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        agg = new TermsAggregation("terms-count", "name");
        agg.addNestedAggregation((Aggregation)new TermsAggregation("nested", "gender"));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)agg));
        q.addAggregation((Aggregation)agg);
        aggregationResult = (TermsResult)q.extendedDataRows().getAggregationResult("terms-count", TermsResult.class);
        vertexPropertyCountByValue = this.nestedTermsBucketToMap(aggregationResult.getBuckets(), "nested");
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Joe").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").size());
        GeAssert.assertEquals((long)1L, (long)vertexPropertyCountByValue.get("Sam").get("male"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Sam").get("female"));
    }

    @Test
    public void testGraphQueryWithHistogramAggregation() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.getGraph().defineProperty("emptyField").dataType(IntValue.class).define();
        String agePropertyName = "age.property";
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)25), VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1990-09-04"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)20), VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-09-04"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)20), VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-08-15"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)20), VISIBILITY_A).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-03-02"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Map<Object, Long> histogram = this.queryGraphQueryWithHistogramAggregation(agePropertyName, "1", 0L, new HistogramAggregation.ExtendedBounds((Value)Values.longValue((long)20L), (Value)Values.longValue((long)25L)), AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)6L, (long)histogram.size());
        GeAssert.assertEquals((long)1L, (long)histogram.get("25"));
        GeAssert.assertEquals((long)(searchIndexFieldLevelSecurity ? 2L : 3L), (long)histogram.get("20"));
        histogram = this.queryGraphQueryWithHistogramAggregation(agePropertyName, "1", null, null, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)histogram.size());
        GeAssert.assertEquals((long)1L, (long)histogram.get("25"));
        GeAssert.assertEquals((long)3L, (long)histogram.get("20"));
        histogram = this.queryGraphQueryWithHistogramAggregation("emptyField", "1", null, null, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)histogram.size());
        histogram = this.queryGraphQueryWithHistogramAggregation("birthDate", "year", null, null, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)histogram.size());
        histogram = this.queryGraphQueryWithHistogramAggregation("birthDate", "31536000000", null, null, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)histogram.size());
    }

    private Map<Object, Long> queryGraphQueryWithHistogramAggregation(String propertyName, String interval, Long minDocCount, HistogramAggregation.ExtendedBounds extendedBounds, Authorizations authorizations) {
        Query q = this.getGraph().query(authorizations).limit(Integer.valueOf(0));
        HistogramAggregation agg = new HistogramAggregation("hist-count", propertyName, interval, minDocCount);
        agg.setExtendedBounds(extendedBounds);
        if (!q.isAggregationSupported((Aggregation)agg)) {
            LOGGER.warn("%s unsupported", new Object[]{HistogramAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return this.histogramBucketToMap(((HistogramResult)q.vertices().getAggregationResult("hist-count", HistogramResult.class)).getBuckets());
    }

    @Test
    public void testGraphQueryWithRangeAggregation() throws ParseException {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.getGraph().defineProperty("emptyField").dataType(IntValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1990-09-04"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-09-04"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-08-15"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_A).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-03-02"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", "v1", "v2", "v1Tov2", VISIBILITY_EMPTY).addPropertyValue("", "birthDate", (Value)DateValue.parse((CharSequence)"1995-03-02"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        RangeResult aggregationResult = this.queryGraphQueryWithRangeAggregation("age", null, "lower", (Value)Values.intValue((int)21), "middle", (Value)Values.intValue((int)23), "upper", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)(searchIndexFieldLevelSecurity ? 2L : 3L), (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        GeAssert.assertEquals((long)0L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("age", null, "lower", (Value)Values.intValue((int)21), "middle", (Value)Values.intValue((int)23), "upper", AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)3L, (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        GeAssert.assertEquals((long)0L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("emptyField", null, "lower", (Value)Values.intValue((int)21), "middle", (Value)Values.intValue((int)23), "upper", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)aggregationResult.getBuckets()));
        aggregationResult = this.queryGraphQueryWithRangeAggregation("birthDate", null, "lower", (Value)DateValue.parse((CharSequence)"1991-01-01"), "middle", (Value)DateValue.parse((CharSequence)"1995-08-30"), "upper", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        GeAssert.assertEquals((long)2L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("birthDate", "yyyy-MM-dd", null, (Value)Values.stringValue((String)"1991-01-01"), null, (Value)Values.stringValue((String)"1995-08-30"), null, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"*-1991-01-01").getCount());
        GeAssert.assertEquals((long)2L, (long)aggregationResult.getBucketByKey((Object)"1991-01-01-1995-08-30").getCount());
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"1995-08-30-*").getCount());
        aggregationResult = this.queryGraphQueryWithRangeAggregation("birthDate", null, "lower", (Value)DateValue.parse((CharSequence)"1991-01-01"), "middle", (Value)DateValue.parse((CharSequence)"1995-08-30"), "upper", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"range aggregation not supported", (aggregationResult != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"lower").getCount());
        GeAssert.assertEquals((long)2L, (long)aggregationResult.getBucketByKey((Object)"middle").getCount());
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getBucketByKey((Object)"upper").getCount());
    }

    private RangeResult queryGraphQueryWithRangeAggregation(String propertyName, String format, String keyOne, Value boundaryOne, String keyTwo, Value boundaryTwo, String keyThree, Authorizations authorizations) {
        RangeAggregation agg;
        Query q = this.getGraph().query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new RangeAggregation("range-count", propertyName, format)))) {
            LOGGER.warn("%s unsupported", new Object[]{RangeAggregation.class.getName()});
            return null;
        }
        agg.addUnboundedTo(keyOne, boundaryOne);
        agg.addRange(keyTwo, boundaryOne, boundaryTwo);
        agg.addUnboundedFrom(keyThree, boundaryTwo);
        q.addAggregation((Aggregation)agg);
        return (RangeResult)q.vertices().getAggregationResult("range-count", RangeResult.class);
    }

    @Test
    public void testGraphQueryWithRangeAggregationAndNestedTerms() throws ParseException {
        String agePropertyName = "age.property";
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)25), VISIBILITY_EMPTY).addPropertyValue("", "name", (Value)Values.stringValue((String)"Alice"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)20), VISIBILITY_EMPTY).addPropertyValue("", "name", (Value)Values.stringValue((String)"Alice"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)21), VISIBILITY_EMPTY).addPropertyValue("", "name", (Value)Values.stringValue((String)"Alice"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("", agePropertyName, (Value)Values.intValue((int)22), VISIBILITY_EMPTY).addPropertyValue("", "name", (Value)Values.stringValue((String)"Bob"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Query q = this.getGraph().query(AUTHORIZATIONS_A_AND_B).limit(Integer.valueOf(0));
        RangeAggregation rangeAggregation = new RangeAggregation("range-count", agePropertyName);
        TermsAggregation termsAggregation = new TermsAggregation("name-count", "name");
        rangeAggregation.addNestedAggregation((Aggregation)termsAggregation);
        Assume.assumeTrue((String)"range aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)rangeAggregation));
        Assume.assumeTrue((String)"terms aggregation not supported", (boolean)q.isAggregationSupported((Aggregation)termsAggregation));
        rangeAggregation.addUnboundedTo("lower", (Value)Values.intValue((int)23));
        rangeAggregation.addUnboundedFrom("upper", (Value)Values.intValue((int)23));
        q.addAggregation((Aggregation)rangeAggregation);
        RangeResult rangeAggResult = (RangeResult)q.vertices().getAggregationResult("range-count", RangeResult.class);
        GeAssert.assertEquals((long)3L, (long)rangeAggResult.getBucketByKey((Object)"lower").getCount());
        GeAssert.assertEquals((long)1L, (long)rangeAggResult.getBucketByKey((Object)"upper").getCount());
        Comparator bucketComparator = (b1, b2) -> Long.compare(b2.getCount(), b1.getCount());
        Map lowerNestedResult = rangeAggResult.getBucketByKey((Object)"lower").getNestedResults();
        TermsResult lowerTermsResult = (TermsResult)lowerNestedResult.get(termsAggregation.getAggregationName());
        List lowerTermsBuckets = IterableUtils.toList((Iterable)lowerTermsResult.getBuckets());
        Collections.sort(lowerTermsBuckets, bucketComparator);
        GeAssert.assertEquals((long)1L, (long)lowerNestedResult.size());
        GeAssert.assertEquals((long)2L, (long)lowerTermsBuckets.size());
        GeAssert.assertEquals((Object)"Alice", (Object)((TermsBucket)lowerTermsBuckets.get(0)).getKey());
        GeAssert.assertEquals((long)2L, (long)((TermsBucket)lowerTermsBuckets.get(0)).getCount());
        GeAssert.assertEquals((Object)"Bob", (Object)((TermsBucket)lowerTermsBuckets.get(1)).getKey());
        GeAssert.assertEquals((long)1L, (long)((TermsBucket)lowerTermsBuckets.get(1)).getCount());
        Map upperNestedResult = rangeAggResult.getBucketByKey((Object)"upper").getNestedResults();
        TermsResult upperTermsResult = (TermsResult)upperNestedResult.get(termsAggregation.getAggregationName());
        List upperTermsBuckets = IterableUtils.toList((Iterable)upperTermsResult.getBuckets());
        GeAssert.assertEquals((long)1L, (long)upperNestedResult.size());
        GeAssert.assertEquals((long)1L, (long)upperTermsBuckets.size());
        GeAssert.assertEquals((Object)"Alice", (Object)((TermsBucket)upperTermsBuckets.get(0)).getKey());
        GeAssert.assertEquals((long)1L, (long)((TermsBucket)upperTermsBuckets.get(0)).getCount());
    }

    @Test
    public void testGraphQueryWithStatisticsAggregation() throws ParseException {
        this.getGraph().defineProperty("emptyField").dataType(IntValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)30), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        StatisticsResult stats = this.queryGraphQueryWithStatisticsAggregation("age", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"statistics aggregation not supported", (stats != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)3L, (long)stats.getCount());
        GeAssert.assertEquals((double)65.0, (double)stats.getSum(), (double)0.1);
        GeAssert.assertEquals((double)20.0, (double)stats.getMin(), (double)0.1);
        GeAssert.assertEquals((double)25.0, (double)stats.getMax(), (double)0.1);
        GeAssert.assertEquals((double)2.35702, (double)stats.getStandardDeviation(), (double)0.1);
        GeAssert.assertEquals((double)21.666666, (double)stats.getAverage(), (double)0.1);
        stats = this.queryGraphQueryWithStatisticsAggregation("emptyField", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"statistics aggregation not supported", (stats != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)stats.getCount());
        GeAssert.assertEquals((double)0.0, (double)stats.getSum(), (double)0.1);
        GeAssert.assertEquals((double)0.0, (double)stats.getMin(), (double)0.1);
        GeAssert.assertEquals((double)0.0, (double)stats.getMax(), (double)0.1);
        GeAssert.assertEquals((double)0.0, (double)stats.getAverage(), (double)0.1);
        GeAssert.assertEquals((double)0.0, (double)stats.getStandardDeviation(), (double)0.1);
        stats = this.queryGraphQueryWithStatisticsAggregation("age", AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"statistics aggregation not supported", (stats != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)4L, (long)stats.getCount());
        GeAssert.assertEquals((double)95.0, (double)stats.getSum(), (double)0.1);
        GeAssert.assertEquals((double)20.0, (double)stats.getMin(), (double)0.1);
        GeAssert.assertEquals((double)30.0, (double)stats.getMax(), (double)0.1);
        GeAssert.assertEquals((double)23.75, (double)stats.getAverage(), (double)0.1);
        GeAssert.assertEquals((double)4.14578, (double)stats.getStandardDeviation(), (double)0.1);
    }

    private StatisticsResult queryGraphQueryWithStatisticsAggregation(String propertyName, Authorizations authorizations) {
        StatisticsAggregation agg;
        Query q = this.getGraph().query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new StatisticsAggregation("stats", propertyName)))) {
            LOGGER.warn("%s unsupported", new Object[]{StatisticsAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return (StatisticsResult)q.vertices().getAggregationResult("stats", StatisticsResult.class);
    }

    @Test
    public void testGraphQueryWithCardinalityAggregation() {
        this.getGraph().defineProperty("emptyField").dataType(IntValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)30), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        CardinalityResult stats = this.queryGraphQueryWithCardinalityAggregation("__ID__", AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"Cardinality aggregation not supported", (stats != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)3L, (long)stats.value());
        stats = this.queryGraphQueryWithCardinalityAggregation("__ID__", AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"Cardinality aggregation not supported", (stats != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)4L, (long)stats.value());
        CardinalityResult r = this.queryGraphQueryWithCardinalityAggregation("age", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)r.value());
    }

    @Test
    public void testGraphQueryWithPercentilesAggregation() throws ParseException {
        this.getGraph().defineProperty("emptyField").dataType(IntValue.class).define();
        for (int i = 0; i <= 100; ++i) {
            this.getGraph().prepareVertex("v" + i, VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)i), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        }
        this.getGraph().prepareVertex("v200", VISIBILITY_EMPTY, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)30), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        PercentilesResult percentilesResult = this.queryGraphQueryWithPercentilesAggregation("age", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, new double[0]);
        Assume.assumeTrue((String)"percentiles aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        List percentiles = IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        percentiles.sort(Comparator.comparing(Percentile::getPercentile));
        Assert.assertEquals((long)7L, (long)percentiles.size());
        Assert.assertEquals((double)1.0, (double)((Percentile)percentiles.get(0)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)1.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.5);
        Assert.assertEquals((double)5.0, (double)((Percentile)percentiles.get(1)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.5);
        Assert.assertEquals((double)25.0, (double)((Percentile)percentiles.get(2)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)((Percentile)percentiles.get(2)).getValue(), (double)0.5);
        Assert.assertEquals((double)50.0, (double)((Percentile)percentiles.get(3)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)50.0, (double)((Percentile)percentiles.get(3)).getValue(), (double)0.5);
        Assert.assertEquals((double)75.0, (double)((Percentile)percentiles.get(4)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)75.0, (double)((Percentile)percentiles.get(4)).getValue(), (double)0.5);
        Assert.assertEquals((double)95.0, (double)((Percentile)percentiles.get(5)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)95.0, (double)((Percentile)percentiles.get(5)).getValue(), (double)0.5);
        Assert.assertEquals((double)99.0, (double)((Percentile)percentiles.get(6)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)99.0, (double)((Percentile)percentiles.get(6)).getValue(), (double)0.5);
        percentilesResult = this.queryGraphQueryWithPercentilesAggregation("age", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, 60.0, 99.99);
        Assume.assumeTrue((String)"statistics aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        percentiles = IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        percentiles.sort(Comparator.comparing(Percentile::getPercentile));
        Assert.assertEquals((long)2L, (long)percentiles.size());
        Assert.assertEquals((double)60.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)60.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.99, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.99, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        percentilesResult = this.queryGraphQueryWithPercentilesAggregation("emptyField", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, new double[0]);
        Assume.assumeTrue((String)"statistics aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        percentiles = IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        Assert.assertEquals((long)0L, (long)percentiles.size());
        percentilesResult = this.queryGraphQueryWithPercentilesAggregation("age", VISIBILITY_A, AUTHORIZATIONS_A_AND_B, new double[0]);
        Assume.assumeTrue((String)"statistics aggregation not supported", (percentilesResult != null ? 1 : 0) != 0);
        percentiles = IterableUtils.toList((Iterable)percentilesResult.getPercentiles());
        percentiles.sort(Comparator.comparing(Percentile::getPercentile));
        Assert.assertEquals((long)7L, (long)percentiles.size());
        Assert.assertEquals((double)1.0, (double)((Percentile)percentiles.get(0)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(0)).getValue(), (double)0.1);
        Assert.assertEquals((double)5.0, (double)((Percentile)percentiles.get(1)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(1)).getValue(), (double)0.1);
        Assert.assertEquals((double)25.0, (double)((Percentile)percentiles.get(2)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(2)).getValue(), (double)0.1);
        Assert.assertEquals((double)50.0, (double)((Percentile)percentiles.get(3)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(3)).getValue(), (double)0.1);
        Assert.assertEquals((double)75.0, (double)((Percentile)percentiles.get(4)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(4)).getValue(), (double)0.1);
        Assert.assertEquals((double)95.0, (double)((Percentile)percentiles.get(5)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(5)).getValue(), (double)0.1);
        Assert.assertEquals((double)99.0, (double)((Percentile)percentiles.get(6)).getPercentile(), (double)0.1);
        Assert.assertEquals((double)30.0, (double)((Percentile)percentiles.get(6)).getValue(), (double)0.1);
    }

    private PercentilesResult queryGraphQueryWithPercentilesAggregation(String propertyName, Visibility visibility, Authorizations authorizations, double ... percents) {
        Query q = this.getGraph().query(authorizations).limit(Integer.valueOf(0));
        PercentilesAggregation agg = new PercentilesAggregation("percentiles", propertyName, visibility);
        agg.setPercents(percents);
        if (!q.isAggregationSupported((Aggregation)agg)) {
            LOGGER.warn("%s unsupported", new Object[]{StatisticsAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return (PercentilesResult)q.vertices().getAggregationResult("percentiles", PercentilesResult.class);
    }

    @Test
    public void testGraphQueryWithGeohashAggregation() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.getGraph().defineProperty("emptyField").dataType(GeoPointValue.class).define();
        this.getGraph().defineProperty("location").dataType(GeoPointValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "location", (Value)Values.geoPointValue((double)50.0, (double)-10.0), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", "location", (Value)Values.geoPointValue((double)39.0, (double)-77.0), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", "location", (Value)Values.geoPointValue((double)39.1, (double)-77.1), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("", "location", (Value)Values.geoPointValue((double)39.2, (double)-77.2), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Map<String, Long> histogram = this.queryGraphQueryWithGeohashAggregation("location", 2, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"geo hash histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)histogram.size());
        GeAssert.assertEquals((long)1L, (long)histogram.get("gb"));
        GeAssert.assertEquals((long)(searchIndexFieldLevelSecurity ? 2L : 3L), (long)histogram.get("dq"));
        histogram = this.queryGraphQueryWithGeohashAggregation("emptyField", 2, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"geo hash histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)histogram.size());
        histogram = this.queryGraphQueryWithGeohashAggregation("location", 2, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"geo hash histogram aggregation not supported", (histogram != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)histogram.size());
        GeAssert.assertEquals((long)1L, (long)histogram.get("gb"));
        GeAssert.assertEquals((long)3L, (long)histogram.get("dq"));
    }

    @Test
    public void testGraphQueryWithCalendarFieldAggregation() {
        String dateFieldName = "agg_date_field";
        this.getGraph().prepareVertex("v0", VISIBILITY_EMPTY, "thing").addPropertyValue("", "other_field", (Value)this.createDate(2016, Month.APRIL.getValue(), 27, 10, 18, 56), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", dateFieldName, (Value)this.createDate(2016, Month.APRIL.getValue(), 27, 10, 18, 56), VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", dateFieldName, (Value)this.createDate(2017, Month.MAY.getValue(), 26, 10, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v3", VISIBILITY_A_AND_B, "thing").addPropertyValue("", dateFieldName, (Value)this.createDate(2016, Month.APRIL.getValue(), 27, 12, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v4", VISIBILITY_A_AND_B, "thing").addPropertyValue("", dateFieldName, (Value)this.createDate(2016, Month.APRIL.getValue(), 24, 12, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v5", VISIBILITY_A_AND_B, "thing").addPropertyValue("", dateFieldName, (Value)this.createDate(2016, Month.APRIL.getValue(), 25, 12, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v6", VISIBILITY_A_AND_B, "thing").addPropertyValue("", dateFieldName, (Value)this.createDate(2016, Month.APRIL.getValue(), 30, 12, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        TimeZone timeZone = TimeZone.getTimeZone(ZoneOffset.UTC);
        QueryResultsIterable results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)new ChronoFieldAggregation("agg1", dateFieldName, null, timeZone, ChronoField.HOUR_OF_DAY)).limit(Integer.valueOf(0)).vertices();
        HistogramResult aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
        GeAssert.assertEquals((long)2L, (long)aggResult.getBucketByKey((Object)10).getCount());
        GeAssert.assertEquals((long)4L, (long)aggResult.getBucketByKey((Object)12).getCount());
        results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)new ChronoFieldAggregation("agg1", dateFieldName, null, timeZone, ChronoField.DAY_OF_WEEK)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        GeAssert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)DayOfWeek.SUNDAY.getValue()).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)DayOfWeek.MONDAY.getValue()).getCount());
        GeAssert.assertEquals((long)2L, (long)aggResult.getBucketByKey((Object)DayOfWeek.WEDNESDAY.getValue()).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)DayOfWeek.FRIDAY.getValue()).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)DayOfWeek.SATURDAY.getValue()).getCount());
        results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)new ChronoFieldAggregation("agg1", dateFieldName, null, timeZone, ChronoField.DAY_OF_MONTH)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        GeAssert.assertEquals((long)5L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)24).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)25).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)26).getCount());
        GeAssert.assertEquals((long)2L, (long)aggResult.getBucketByKey((Object)27).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)30).getCount());
        results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)new ChronoFieldAggregation("agg1", dateFieldName, null, timeZone, ChronoField.MONTH_OF_YEAR)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
        GeAssert.assertEquals((long)5L, (long)aggResult.getBucketByKey((Object)Month.APRIL.getValue()).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)Month.MAY.getValue()).getCount());
        results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)new ChronoFieldAggregation("agg1", dateFieldName, null, timeZone, ChronoField.YEAR)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        GeAssert.assertEquals((long)2L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
        GeAssert.assertEquals((long)5L, (long)aggResult.getBucketByKey((Object)2016).getCount());
        GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)2017).getCount());
        results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)new ChronoFieldAggregation("agg1", dateFieldName, null, timeZone, ChronoField.ALIGNED_WEEK_OF_YEAR)).limit(Integer.valueOf(0)).vertices();
        aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        if (this.isPainlessDateMath()) {
            GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
            GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)18).getCount());
            GeAssert.assertEquals((long)4L, (long)aggResult.getBucketByKey((Object)17).getCount());
            GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)21).getCount());
        } else {
            GeAssert.assertEquals((long)3L, (long)IterableUtils.count((Iterable)aggResult.getBuckets()));
            GeAssert.assertEquals((long)4L, (long)aggResult.getBucketByKey((Object)17).getCount());
            GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)18).getCount());
            GeAssert.assertEquals((long)1L, (long)aggResult.getBucketByKey((Object)21).getCount());
        }
    }

    @Test
    public void testGraphQueryWithCalendarFieldAggregationNested() {
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("", "date", (Value)this.createDate(2016, Month.APRIL.getValue(), 27, 10, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("", "date", (Value)this.createDate(2016, Month.APRIL.getValue(), 27, 10, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().prepareVertex("v3", VISIBILITY_EMPTY, "thing").addPropertyValue("", "date", (Value)this.createDate(2016, Month.APRIL.getValue(), 27, 12, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v4", VISIBILITY_EMPTY, "thing").addPropertyValue("", "date", (Value)this.createDate(2016, Month.APRIL.getValue(), 28, 10, 18, 56), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        ChronoFieldAggregation agg = new ChronoFieldAggregation("agg1", "date", null, TimeZone.getTimeZone(ZoneOffset.UTC), ChronoField.DAY_OF_WEEK);
        agg.addNestedAggregation((Aggregation)new ChronoFieldAggregation("aggNested", "date", null, TimeZone.getTimeZone(ZoneOffset.UTC), ChronoField.HOUR_OF_DAY));
        QueryResultsIterable results = this.getGraph().query(AUTHORIZATIONS_ALL).addAggregation((Aggregation)agg).limit(Integer.valueOf(0)).vertices();
        HistogramResult aggResult = (HistogramResult)results.getAggregationResult("agg1", ChronoFieldAggregation.RESULT_CLASS);
        HistogramBucket bucket = aggResult.getBucketByKey((Object)DayOfWeek.WEDNESDAY.getValue());
        GeAssert.assertEquals((long)3L, (long)bucket.getCount());
        HistogramResult nestedResult = (HistogramResult)bucket.getNestedResults().get("aggNested");
        GeAssert.assertEquals((long)2L, (long)nestedResult.getBucketByKey((Object)10).getCount());
        GeAssert.assertEquals((long)1L, (long)nestedResult.getBucketByKey((Object)12).getCount());
        bucket = aggResult.getBucketByKey((Object)DayOfWeek.THURSDAY.getValue());
        GeAssert.assertEquals((long)1L, (long)bucket.getCount());
        nestedResult = (HistogramResult)bucket.getNestedResults().get("aggNested");
        GeAssert.assertEquals((long)1L, (long)nestedResult.getBucketByKey((Object)10).getCount());
    }

    @Test
    public void testIteratorWithLessThanPageSizeResultsPageOne() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", AUTHORIZATIONS_EMPTY);
        parameters.setSkip(0L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(3L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            GeAssert.assertNotNull((Object)v);
        }
        GeAssert.assertEquals((long)3L, (long)count);
        GeAssert.assertNotNull((String)"v was null", (Object)v);
        GeAssert.assertEquals((Object)"2", (Object)v.getId());
    }

    @Test
    public void testIteratorWithPageSizeResultsPageOne() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", AUTHORIZATIONS_EMPTY);
        parameters.setSkip(0L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(5L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            GeAssert.assertNotNull((Object)v);
        }
        GeAssert.assertEquals((long)5L, (long)count);
        GeAssert.assertNotNull((String)"v was null", (Object)v);
        GeAssert.assertEquals((Object)"4", (Object)v.getId());
    }

    @Test
    public void testIteratorWithMoreThanPageSizeResultsPageOne() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", AUTHORIZATIONS_EMPTY);
        parameters.setSkip(0L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(7L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            GeAssert.assertNotNull((Object)v);
        }
        GeAssert.assertEquals((long)5L, (long)count);
        GeAssert.assertNotNull((String)"v was null", (Object)v);
        GeAssert.assertEquals((Object)"4", (Object)v.getId());
    }

    @Test
    public void testIteratorWithMoreThanPageSizeResultsPageTwo() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", AUTHORIZATIONS_EMPTY);
        parameters.setSkip(5L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(12L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            GeAssert.assertNotNull((Object)v);
        }
        GeAssert.assertEquals((long)5L, (long)count);
        GeAssert.assertNotNull((String)"v was null", (Object)v);
        GeAssert.assertEquals((Object)"9", (Object)v.getId());
    }

    @Test
    public void testIteratorWithMoreThanPageSizeResultsPageThree() {
        QueryStringQueryParameters parameters = new QueryStringQueryParameters("*", AUTHORIZATIONS_EMPTY);
        parameters.setSkip(10L);
        parameters.setLimit(Integer.valueOf(5));
        DefaultGraphQueryIterable iterable = new DefaultGraphQueryIterable((QueryParameters)parameters, this.getVertices(12L), false, false, false);
        int count = 0;
        Iterator iterator = iterable.iterator();
        Vertex v = null;
        while (iterator.hasNext()) {
            ++count;
            v = (Vertex)iterator.next();
            GeAssert.assertNotNull((Object)v);
        }
        GeAssert.assertEquals((long)2L, (long)count);
        GeAssert.assertNotNull((String)"v was null", (Object)v);
        GeAssert.assertEquals((Object)"11", (Object)v.getId());
    }

    @Test
    public void testSimilarityByText() {
        Assume.assumeTrue((String)"query similar", (boolean)this.getGraph().isQuerySimilarToTextSupported());
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Mary had a little lamb, His fleece was white as snow."), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Mary had a little tiger, His fleece was white as snow."), VISIBILITY_B).save(AUTHORIZATIONS_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_B, "thing").setProperty("text", (Value)Values.stringValue((String)"Mary had a little lamb, His fleece was white as snow"), VISIBILITY_A).save(AUTHORIZATIONS_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Mary had a little lamb."), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v5", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"His fleece was white as snow."), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v6", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Mary had a little lamb, His fleece was black as snow."), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v6", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Jack and Jill went up the hill to fetch a pail of water."), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        SimilarToGraphQuery query = this.getGraph().querySimilarTo(new String[]{"text"}, "Mary had a little lamb, His fleece was white as snow", AUTHORIZATIONS_A_AND_B).minTermFrequency(1).maxQueryTerms(25).minDocFrequency(1).maxDocFrequency(10).boost(2.0f);
        QueryResultsIterable searchResults = query.search();
        List vertices = IterableUtils.toList((Iterable)query.vertices());
        GeAssert.assertTrue((vertices.size() > 0 ? 1 : 0) != 0);
        GeAssert.assertEquals((long)vertices.size(), (long)searchResults.getTotalHits());
        query = this.getGraph().querySimilarTo(new String[]{"text"}, "Mary had a little lamb, His fleece was white as snow", AUTHORIZATIONS_A).minTermFrequency(1).maxQueryTerms(25).minDocFrequency(1).maxDocFrequency(10).boost(2.0f);
        searchResults = query.search();
        vertices = IterableUtils.toList((Iterable)query.vertices());
        GeAssert.assertTrue((vertices.size() > 0 ? 1 : 0) != 0);
        GeAssert.assertTrue((boolean)vertices.stream().noneMatch(vertex -> vertex.getId().equals("v3")));
        GeAssert.assertEquals((long)vertices.size(), (long)searchResults.getTotalHits());
    }

    @Test
    public void testGraphQueryWithTermsAggregation() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.getGraph().defineProperty("name").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH, TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("emptyField").dataType(IntValue.class).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_EMPTY).addPropertyValue("", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_B).addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e1", "v1", "v2", "label1", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e2", "v1", "v2", "label1", VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("e3", "v1", "v2", "label2", VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        TermsResult aggregationResult = this.queryGraphQueryWithTermsAggregationResult(null, "name", ElementType.VERTEX, 10, AUTHORIZATIONS_EMPTY);
        GeAssert.assertEquals((long)0L, (long)aggregationResult.getSumOfOtherDocCounts());
        Map<Object, Long> vertexPropertyCountByValue = this.termsBucketToMap(aggregationResult.getBuckets());
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joe"));
        GeAssert.assertEquals((long)(searchIndexFieldLevelSecurity ? 1L : 2L), (long)vertexPropertyCountByValue.get("Joseph"));
        aggregationResult = this.queryGraphQueryWithTermsAggregationResult(null, "name", ElementType.VERTEX, 1, AUTHORIZATIONS_EMPTY);
        GeAssert.assertEquals((long)1L, (long)aggregationResult.getSumOfOtherDocCounts());
        vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("emptyField", ElementType.VERTEX, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)vertexPropertyCountByValue.size());
        vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("name", ElementType.VERTEX, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joe"));
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joseph"));
        Map<Object, Long> edgePropertyCountByValue = this.queryGraphQueryWithTermsAggregation("__edgeLabel", ElementType.EDGE, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (edgePropertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)edgePropertyCountByValue.size());
        GeAssert.assertEquals((long)2L, (long)edgePropertyCountByValue.get("label1"));
        GeAssert.assertEquals((long)1L, (long)edgePropertyCountByValue.get("label2"));
        vertexPropertyCountByValue = this.queryGraphQueryWithTermsAggregation("Joe", "name", ElementType.VERTEX, AUTHORIZATIONS_EMPTY);
        Assume.assumeTrue((String)"terms aggregation not supported", (vertexPropertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.get("Joe"));
        GeAssert.assertEquals((long)(searchIndexFieldLevelSecurity ? 1L : 2L), (long)vertexPropertyCountByValue.get("Joseph"));
    }

    @Test
    public void testGraphQueryVertexWithTermsAggregationAlterElementVisibility() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("k1", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterElementVisibility(VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Map<Object, Long> propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.VERTEX, AUTHORIZATIONS_A_AND_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.VERTEX, AUTHORIZATIONS_A);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)0L, (long)propertyCountByValue.size());
        propertyCountByValue = this.queryGraphQueryWithTermsAggregation("age", ElementType.VERTEX, AUTHORIZATIONS_B);
        Assume.assumeTrue((String)"terms aggregation not supported", (propertyCountByValue != null ? 1 : 0) != 0);
        GeAssert.assertEquals((long)1L, (long)propertyCountByValue.size());
    }

    @Test
    public void testCaseSensitivityOfExactMatch() {
        this.getGraph().defineProperty("text").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.graph.flush();
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"JOE"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").setProperty("text", (Value)Values.stringValue((String)"Joe"), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("text", (Predicate)Compare.EQUAL, (Value)Values.stringValue((String)"Joe")).addAggregation((Aggregation)new TermsAggregation("agg1", "text")).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2", "v3", "v4"});
        TermsResult agg = (TermsResult)vertices.getAggregationResult("agg1", TermsResult.class);
        ArrayList buckets = Lists.newArrayList((Iterable)agg.getBuckets());
        GeAssert.assertEquals((long)1L, (long)buckets.size());
        GeAssert.assertEquals((Object)"Joe", (Object)((TermsBucket)buckets.get(0)).getKey());
        GeAssert.assertEquals((long)4L, (long)((TermsBucket)buckets.get(0)).getCount());
    }

    @Test
    public void testTextIndex() throws Exception {
        this.getGraph().defineProperty("none").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.getGraph().defineProperty("none").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.NONE).define();
        this.getGraph().defineProperty("both").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("fullText").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("exactMatch").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("none", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).setProperty("both", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).setProperty("fullText", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).setProperty("exactMatch", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"Test Value"), (Object)v1.getPropertyValue("none"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"Test Value"), (Object)v1.getPropertyValue("both"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"Test Value"), (Object)v1.getPropertyValue("fullText"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"Test Value"), (Object)v1.getPropertyValue("exactMatch"));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Test")).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("fullText", (Predicate)TextPredicate.CONTAINS, (Value)Values.stringValue((String)"Test")).vertices()));
        GeAssert.assertEquals((String)"exact match shouldn't match partials", (long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("exactMatch", (Value)Values.stringValue((String)"Test")).vertices()));
        GeAssert.assertEquals((String)"un-indexed property shouldn't match partials", (long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("none", (Value)Values.stringValue((String)"Test")).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("both", (Value)Values.stringValue((String)"Test Value")).vertices()));
        GeAssert.assertEquals((String)"default has predicate is equals which shouldn't work for full text", (long)0L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("fullText", (Value)Values.stringValue((String)"Test Value")).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("exactMatch", (Value)Values.stringValue((String)"Test Value")).vertices()));
        if (IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("none", (Value)Values.stringValue((String)"Test Value")).vertices()) != 0) {
            LOGGER.warn("default has predicate is equals which shouldn't work for un-indexed", new Object[0]);
        }
    }

    @Test
    public void testTextIndexDoesNotContain() throws Exception {
        this.getGraph().defineProperty("both").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).define();
        this.getGraph().defineProperty("fullText").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.FULL_TEXT}).define();
        this.getGraph().defineProperty("exactMatch").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("exactMatch", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).setProperty("both", (Value)Values.stringValue((String)"Test123"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("both", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v3", VISIBILITY_A, "thing").setProperty("both", (Value)Values.stringValue((String)"Temp"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v4", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v5", VISIBILITY_A, "thing").setProperty("both", (Value)Values.stringValue((String)"Test123 test"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.DOES_NOT_CONTAIN, (Value)Values.stringValue((String)"Test")).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v3", "v4"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("exactMatch", (Value)Values.stringValue((String)"Test Value")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        this.getGraph().query(AUTHORIZATIONS_A).has("exactMatch", (Predicate)TextPredicate.DOES_NOT_CONTAIN, (Value)Values.stringValue((String)"Test")).vertices();
        this.getGraph().prepareVertex("v6", VISIBILITY_A, "thing").setProperty("both", (Value)Values.stringValue((String)"susan-test"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v7", VISIBILITY_A, "thing").setProperty("both", (Value)Values.stringValue((String)"susan-test"), Visibility.EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        vertices = this.getGraph().query(AUTHORIZATIONS_A).has("both", (Predicate)TextPredicate.DOES_NOT_CONTAIN, (Value)Values.stringValue((String)"susan")).vertices();
        GeAssert.assertVertexIdsAnyOrder((Iterable)vertices, (String[])new String[]{"v1", "v2", "v3", "v4", "v5"});
    }

    @Test
    public void testFieldBoost() throws Exception {
        Assume.assumeTrue((String)"Boost not supported", (boolean)this.getGraph().isFieldBoostSupported());
        this.getGraph().defineProperty("a").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).boost(1.0).define();
        this.getGraph().defineProperty("b").dataType(TextValue.class).textIndexHint((Collection)TextIndexHint.ALL).boost(2.0).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("a", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("b", (Value)Values.stringValue((String)"Test Value"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        GeAssert.assertVertexIds((Iterable)this.getGraph().query("Test", AUTHORIZATIONS_A).vertices(), (String[])new String[]{"v2", "v1"});
    }

    @Test
    public void testValueTypes() throws Exception {
        DateTimeValue date = this.createDate(2014, 2, 24, 13, 0, 5);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("int", (Value)Values.intValue((int)5), VISIBILITY_A).setProperty("double", (Value)Values.doubleValue((double)5.6), VISIBILITY_A).setProperty("float", (Value)Values.floatValue((float)6.4f), VISIBILITY_A).setProperty("string", (Value)Values.stringValue((String)"test"), VISIBILITY_A).setProperty("byte", (Value)Values.byteValue((byte)5), VISIBILITY_A).setProperty("long", (Value)Values.longValue((long)5L), VISIBILITY_A).setProperty("boolean", (Value)BooleanValue.TRUE, VISIBILITY_A).setProperty("geopoint", (Value)Values.geoPointValue((double)77.0, (double)-33.0), VISIBILITY_A).setProperty("short", (Value)Values.shortValue((short)5), VISIBILITY_A).setProperty("date", (Value)date, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("int", (Value)Values.intValue((int)5)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("double", (Value)Values.doubleValue((double)5.6)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).range("float", (Value)Values.floatValue((float)6.3f), (Value)Values.floatValue((float)6.5f)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("string", (Value)Values.stringValue((String)"test")).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("byte", (Value)Values.byteValue((byte)5)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("long", (Value)Values.longValue((long)5L)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("boolean", (Value)BooleanValue.TRUE).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("short", (Value)Values.shortValue((short)5)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("date", (Value)date).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("geopoint", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)77.0, (double)-33.0, (double)1.0)).vertices()));
    }

    @Test
    public void testValueTypesUpdatingWithMutations() throws Exception {
        DateTimeValue date = this.createDate(2014, 2, 24, 13, 0, 5);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B).prepareMutation().addPropertyValue("", "int", (Value)Values.intValue((int)5), VISIBILITY_A).addPropertyValue("", "double", (Value)Values.doubleValue((double)5.6), VISIBILITY_A).addPropertyValue("", "float", (Value)Values.floatValue((float)6.4f), VISIBILITY_A).addPropertyValue("", "string", (Value)Values.stringValue((String)"test"), VISIBILITY_A).addPropertyValue("", "byte", (Value)Values.byteValue((byte)5), VISIBILITY_A).addPropertyValue("", "long", (Value)Values.longValue((long)5L), VISIBILITY_A).addPropertyValue("", "boolean", (Value)BooleanValue.TRUE, VISIBILITY_A).addPropertyValue("", "geopoint", (Value)Values.geoPointValue((double)77.0, (double)-33.0), VISIBILITY_A).addPropertyValue("", "short", (Value)Values.shortValue((short)5), VISIBILITY_A).addPropertyValue("", "date", (Value)date, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("int", (Value)Values.intValue((int)5)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("double", (Value)Values.doubleValue((double)5.6)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).range("float", (Value)Values.floatValue((float)6.3f), (Value)Values.floatValue((float)6.5f)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("string", (Value)Values.stringValue((String)"test")).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("byte", (Value)Values.byteValue((byte)5)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("long", (Value)Values.longValue((long)5L)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("boolean", (Value)BooleanValue.TRUE).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("short", (Value)Values.shortValue((short)5)).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("date", (Value)date).vertices()));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().query(AUTHORIZATIONS_A).has("geopoint", (Predicate)GeoCompare.WITHIN, (Value)Values.geoCircleValue((double)77.0, (double)-33.0, (double)1.0)).vertices()));
    }

    @Test
    public void testPartialUpdateOfVertex() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1New"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop2", (Value)Values.stringValue((String)"value2")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
    }

    @Test
    public void testPartialUpdateOfVertexPropertyKey() {
        Assume.assumeTrue((String)"Known bug in partial updates", (boolean)this.isParitalUpdateOfVertexPropertyKeySupported());
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "prop", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).addPropertyValue("key2", "prop", (Value)Values.stringValue((String)"value2"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        QueryResultsIterable vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop", (Value)Values.stringValue((String)"value1")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop", (Value)Values.stringValue((String)"value2")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("key1", "prop", (Value)Values.stringValue((String)"value1New"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop", (Value)Values.stringValue((String)"value1New")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop", (Value)Values.stringValue((String)"value2")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[]{"v1"});
        vertices = this.getGraph().query(AUTHORIZATIONS_A_AND_B).has("prop", (Value)Values.stringValue((String)"value1")).vertices();
        GeAssert.assertVertexIds((Iterable)vertices, (String[])new String[0]);
    }

    @Test
    public void testGetVertexPropertyCountByValue() {
        boolean searchIndexFieldLevelSecurity = this.isSearchIndexFieldLevelSecuritySupported();
        this.getGraph().defineProperty("name").dataType(TextValue.class).textIndexHint(new TextIndexHint[]{TextIndexHint.EXACT_MATCH}).define();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_EMPTY).addPropertyValue("", "age", (Value)Values.intValue((int)25), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareVertex("v2", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).addPropertyValue("k2", "name", (Value)Values.stringValue((String)"Joseph"), VISIBILITY_B).addPropertyValue("", "age", (Value)Values.intValue((int)20), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().prepareEdge("v1", "v2", "label1", VISIBILITY_EMPTY).addPropertyValue("k1", "name", (Value)Values.stringValue((String)"Joe"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Map vertexPropertyCountByValue = this.getGraph().getVertexPropertyCountByValue("name", AUTHORIZATIONS_EMPTY);
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)2L, (long)((Long)vertexPropertyCountByValue.get("joe")));
        GeAssert.assertEquals((long)(searchIndexFieldLevelSecurity ? 1L : 2L), (long)((Long)vertexPropertyCountByValue.get("joseph")));
        vertexPropertyCountByValue = this.getGraph().getVertexPropertyCountByValue("name", AUTHORIZATIONS_A_AND_B);
        GeAssert.assertEquals((long)2L, (long)vertexPropertyCountByValue.size());
        GeAssert.assertEquals((long)2L, (long)((Long)vertexPropertyCountByValue.get("joe")));
        GeAssert.assertEquals((long)2L, (long)((Long)vertexPropertyCountByValue.get("joseph")));
    }

    @Test
    public void testGetCounts() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addEdge("e1", v1, v2, "label1", VISIBILITY_A, AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((long)2L, (long)this.getGraph().getVertexCount(AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)1L, (long)this.getGraph().getEdgeCount(AUTHORIZATIONS_A));
    }

    protected boolean isFieldNamesInQuerySupported() {
        return true;
    }

    protected boolean isLuceneAndQueriesSupported() {
        return !(this.getGraph().query(AUTHORIZATIONS_A) instanceof DefaultGraphQuery);
    }

    protected boolean isIterableWithTotalHitsSupported(Iterable<Vertex> vertices) {
        return vertices instanceof IterableWithTotalHits;
    }

    protected boolean isFetchHintNoneVertexQuerySupported() {
        return true;
    }

    private Map<String, Long> geoHashBucketToMap(Iterable<GeohashBucket> buckets) {
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (GeohashBucket b : buckets) {
            results.put(b.getKey(), b.getCount());
        }
        return results;
    }

    private Map<Object, Map<Object, Long>> nestedTermsBucketToMap(Iterable<TermsBucket> buckets, String nestedAggName) {
        HashMap<Object, Map<Object, Long>> results = new HashMap<Object, Map<Object, Long>>();
        for (TermsBucket entry : buckets) {
            TermsResult nestedResults = (TermsResult)entry.getNestedResults().get(nestedAggName);
            if (nestedResults == null) {
                throw new GeException("Could not find nested: " + nestedAggName);
            }
            results.put(entry.getKey(), this.termsBucketToMap(nestedResults.getBuckets()));
        }
        return results;
    }

    private Map<Object, Long> histogramBucketToMap(Iterable<HistogramBucket> buckets) {
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        for (HistogramBucket b : buckets) {
            results.put(b.getKey(), b.getCount());
        }
        return results;
    }

    private boolean isSearchIndexFieldLevelSecuritySupported() {
        if (this.getGraph() instanceof GraphWithSearchIndex) {
            return ((GraphWithSearchIndex)this.getGraph()).getSearchIndex().isFieldLevelSecuritySupported();
        }
        return true;
    }

    protected boolean isParitalUpdateOfVertexPropertyKeySupported() {
        return true;
    }

    private CardinalityResult queryGraphQueryWithCardinalityAggregation(String propertyName, Authorizations authorizations) {
        CardinalityAggregation agg;
        Query q = this.getGraph().query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new CardinalityAggregation("card", propertyName)))) {
            LOGGER.warn("%s unsupported", new Object[]{CardinalityAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return (CardinalityResult)q.limit(Integer.valueOf(0)).vertices().getAggregationResult("card", CardinalityResult.class);
    }

    private Map<String, Long> queryGraphQueryWithGeohashAggregation(String propertyName, int precision, Authorizations authorizations) {
        GeohashAggregation agg;
        Query q = this.getGraph().query(authorizations).limit(Integer.valueOf(0));
        if (!q.isAggregationSupported((Aggregation)(agg = new GeohashAggregation("geo-count", propertyName, precision)))) {
            LOGGER.warn("%s unsupported", new Object[]{GeohashAggregation.class.getName()});
            return null;
        }
        q.addAggregation((Aggregation)agg);
        return this.geoHashBucketToMap(((GeohashResult)q.vertices().getAggregationResult("geo-count", GeohashResult.class)).getBuckets());
    }
}

