/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.mware.ge.Edge;
import com.mware.ge.FetchHints;
import com.mware.ge.FetchHintsBuilder;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.mutation.ExistingEdgeMutation;
import com.mware.ge.mutation.ExistingVertexMutation;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphMetadataTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void testGraphMetadata() {
        List existingMetadata = IterableUtils.toList((Iterable)this.getGraph().getMetadata());
        this.getGraph().setMetadata("test1", (Object)"value1old");
        this.getGraph().setMetadata("test1", (Object)"value1");
        this.getGraph().setMetadata("test2", (Object)"value2");
        GeAssert.assertEquals((Object)"value1", (Object)this.getGraph().getMetadata("test1"));
        GeAssert.assertEquals((Object)"value2", (Object)this.getGraph().getMetadata("test2"));
        GeAssert.assertEquals(null, (Object)this.getGraph().getMetadata("missingProp"));
        this.getGraph().dumpGraph();
        List newMetadata = IterableUtils.toList((Iterable)this.getGraph().getMetadata());
        GeAssert.assertEquals((long)(existingMetadata.size() + 2), (long)newMetadata.size());
    }

    @Test
    public void testGraphMetadataStore() {
        this.getGraph().setMetadata("testMeta1", (Object)"testMeta1Value");
        this.getGraph().dumpGraph();
        GeAssert.assertEquals((Object)this.getGraph().getMetadata("testMeta1"), (Object)"testMeta1Value");
        this.getGraph().removeMetadata("testMeta1");
        GeAssert.assertNull((Object)this.getGraph().getMetadata("testMeta1"));
    }

    @Test
    public void testMetadata() {
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop1", (Value)Values.stringValue((String)"value1"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex newV1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        ExistingVertexMutation m = newV1.prepareMutation();
        m.setPropertyMetadata(v1.getProperty("prop1", VISIBILITY_A), "metadata1", (Value)Values.stringValue((String)"metadata-value1aa"), VISIBILITY_A);
        m.setPropertyMetadata(v1.getProperty("prop1", VISIBILITY_A), "metadata1", (Value)Values.stringValue((String)"metadata-value1ab"), VISIBILITY_B);
        m.setPropertyMetadata(v1.getProperty("prop1", VISIBILITY_B), "metadata1", (Value)Values.stringValue((String)"metadata-value1bb"), VISIBILITY_B);
        m.save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        Property prop1A = v1.getProperty("prop1", VISIBILITY_A);
        GeAssert.assertEquals((long)2L, (long)prop1A.getMetadata().entrySet().size());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata-value1aa"), (Object)prop1A.getMetadata().getValue("metadata1", VISIBILITY_A));
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata-value1ab"), (Object)prop1A.getMetadata().getValue("metadata1", VISIBILITY_B));
        Property prop1B = v1.getProperty("prop1", VISIBILITY_B);
        GeAssert.assertEquals((long)1L, (long)prop1B.getMetadata().entrySet().size());
        GeAssert.assertEquals((Object)Values.stringValue((String)"metadata-value1bb"), (Object)prop1B.getMetadata().getValue("metadata1", VISIBILITY_B));
    }

    @Test
    public void testMetadataMutationsOnVertex() {
        Metadata metadataPropB = Metadata.create();
        metadataPropB.add("meta1", (Value)Values.stringValue((String)"meta1"), VISIBILITY_A);
        Vertex vertex = (Vertex)this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propBmeta", (Value)Values.stringValue((String)"propBmeta"), metadataPropB, VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ExistingVertexMutation m = vertex.prepareMutation();
        m.setPropertyMetadata("propBmeta", "meta1", (Value)Values.stringValue((String)"meta2"), VISIBILITY_A);
        vertex = (Vertex)m.save(AUTHORIZATIONS_ALL);
        GeAssert.assertEquals((Object)Values.stringValue((String)"meta2"), (Object)vertex.getProperty("propBmeta").getMetadata().getEntry("meta1").getValue());
    }

    @Test
    public void testMetadataMutationsOnEdge() {
        this.getGraph().addVertex("v1", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        this.getGraph().addVertex("v2", VISIBILITY_A, AUTHORIZATIONS_A, "thing");
        Metadata metadataPropB = Metadata.create();
        metadataPropB.add("meta1", (Value)Values.stringValue((String)"meta1"), VISIBILITY_A);
        Edge edge = (Edge)this.getGraph().prepareEdge("v1", "v2", "label1", VISIBILITY_A).setProperty("propBmeta", (Value)Values.stringValue((String)"propBmeta"), metadataPropB, VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        ExistingEdgeMutation m = edge.prepareMutation();
        m.setPropertyMetadata("propBmeta", "meta1", (Value)Values.stringValue((String)"meta2"), VISIBILITY_A);
        edge = (Edge)m.save(AUTHORIZATIONS_ALL);
        GeAssert.assertEquals((Object)Values.stringValue((String)"meta2"), (Object)edge.getProperty("propBmeta").getMetadata().getEntry("meta1").getValue());
    }

    @Test
    public void testMetadataUpdate() {
        Metadata metadataPropB = Metadata.create();
        metadataPropB.add("meta1", (Value)Values.stringValue((String)"value1"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("propBmeta", (Value)Values.stringValue((String)"propBmeta"), metadataPropB, VISIBILITY_A).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        FetchHints fetchHints = new FetchHintsBuilder().setPropertyNamesToInclude(new String[]{"propBmeta"}).build();
        Vertex vertex = this.getGraph().getVertex("v1", fetchHints, AUTHORIZATIONS_A);
        ExistingVertexMutation m = vertex.prepareMutation();
        m.setPropertyMetadata("propBmeta", "meta1", (Value)Values.stringValue((String)"value2"), VISIBILITY_A);
        m.save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        vertex = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)vertex.getProperty("propBmeta").getMetadata().getEntry("meta1").getValue());
        fetchHints = new FetchHintsBuilder().setPropertyNamesToInclude(new String[]{"propBmeta"}).build();
        vertex = this.getGraph().getVertex("v1", fetchHints, AUTHORIZATIONS_A);
        m = vertex.prepareMutation();
        Metadata newMetadata = Metadata.create();
        newMetadata.add("meta1", (Value)Values.stringValue((String)"value3"), VISIBILITY_A);
        m.setProperty("propBmeta", (Value)Values.stringValue((String)"propBmeta"), newMetadata, VISIBILITY_A);
        m.save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        vertex = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)vertex.getProperty("propBmeta").getMetadata().getEntry("meta1").getValue());
    }

    @Test
    public void testChangePropertyMetadata() {
        Metadata prop1Metadata = Metadata.create();
        prop1Metadata.add("prop1_key1", (Value)Values.stringValue((String)"valueOld"), VISIBILITY_EMPTY);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1", (Value)Values.stringValue((String)"value1"), prop1Metadata, VISIBILITY_EMPTY).setProperty("prop2", (Value)Values.stringValue((String)"value2"), null, VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        v1.prepareMutation().setPropertyMetadata("prop1", "prop1_key1", (Value)Values.stringValue((String)"valueNew"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueNew"), (Object)v1.getProperty("prop1").getMetadata().getEntry("prop1_key1", VISIBILITY_EMPTY).getValue());
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueNew"), (Object)v1.getProperty("prop1").getMetadata().getEntry("prop1_key1", VISIBILITY_EMPTY).getValue());
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        v1.prepareMutation().setPropertyMetadata("prop2", "prop2_key1", (Value)Values.stringValue((String)"valueNew"), VISIBILITY_EMPTY).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueNew"), (Object)v1.getProperty("prop2").getMetadata().getEntry("prop2_key1", VISIBILITY_EMPTY).getValue());
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        GeAssert.assertEquals((Object)Values.stringValue((String)"valueNew"), (Object)v1.getProperty("prop2").getMetadata().getEntry("prop2_key1", VISIBILITY_EMPTY).getValue());
    }
}

