/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.base;

import com.google.common.collect.ImmutableMap;
import com.mware.ge.Edge;
import com.mware.ge.EdgeBuilder;
import com.mware.ge.FetchHints;
import com.mware.ge.GeException;
import com.mware.ge.Graph;
import com.mware.ge.HistoricalPropertyValue;
import com.mware.ge.Metadata;
import com.mware.ge.Vertex;
import com.mware.ge.VertexBuilder;
import com.mware.ge.base.GraphTestSetup;
import com.mware.ge.event.GraphEvent;
import com.mware.ge.event.GraphEventListener;
import com.mware.ge.util.GeAssert;
import com.mware.ge.util.IterableUtils;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class GraphHistoryTests
implements GraphTestSetup {
    protected Graph graph;

    @Before
    public void before() throws Exception {
        this.graph = this.graphFactory().createGraph();
        GeAssert.clearGraphEvents();
        this.getGraph().addGraphEventListener(new GraphEventListener(){

            public void onGraphEvent(GraphEvent graphEvent) {
                GeAssert.addGraphEvent((GraphEvent)graphEvent);
            }
        });
    }

    @After
    public void after() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().drop();
            this.getGraph().shutdown();
            this.graph = null;
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Test
    public void historicalPropertyValueAddProp() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1_A", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2_B", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().setProperty("prop3_A", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        GeAssert.assertEquals((long)3L, (long)values.size());
        GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(0)).getPropertyName());
        GeAssert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(1)).getPropertyName());
        GeAssert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(2)).getPropertyName());
    }

    @Test
    public void historicalPropertyValueDeleteProp() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1_A", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2_B", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).setProperty("prop3_A", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().softDeleteProperties("prop2_B").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        GeAssert.assertEquals((long)4L, (long)values.size());
        boolean isDeletedExpected = false;
        for (int i = 0; i < 4; ++i) {
            HistoricalPropertyValue item = (HistoricalPropertyValue)values.get(i);
            if (item.getPropertyName().equals("prop1_A")) {
                GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(i)).isDeleted());
                continue;
            }
            if (item.getPropertyName().equals("prop2_B")) {
                GeAssert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                GeAssert.assertEquals((Object)isDeletedExpected, (Object)((HistoricalPropertyValue)values.get(i)).isDeleted());
                isDeletedExpected = !isDeletedExpected;
                continue;
            }
            if (item.getPropertyName().equals("prop3_A")) {
                GeAssert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(i)).isDeleted());
                continue;
            }
            GeAssert.fail((String)("Invalid " + item));
        }
        Metadata metadata = Metadata.create();
        metadata.add("metadata1", (Value)Values.stringValue((String)"metadata1Value"), VISIBILITY_A);
        Vertex v2 = (Vertex)this.getGraph().prepareVertex("v2", VISIBILITY_A, "thing").setProperty("prop1_A", (Value)Values.stringValue((String)"value1"), metadata, VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        metadata.add("metadata2", (Value)Values.stringValue((String)"metadata2Value"), VISIBILITY_A);
        v2.prepareMutation().setProperty("prop1_A", (Value)Values.stringValue((String)"value2"), metadata, VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A_AND_B);
        v2.prepareMutation().softDeleteProperties("prop1_A").save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v2 = this.getGraph().getVertex("v2", AUTHORIZATIONS_A_AND_B);
        values = IterableUtils.toList((Iterable)v2.getHistoricalPropertyValues(AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        GeAssert.assertEquals((long)3L, (long)values.size());
        List deletedHpv = values.stream().filter(HistoricalPropertyValue::isDeleted).collect(Collectors.toList());
        GeAssert.assertEquals((long)1L, (long)deletedHpv.size());
        for (int i = 0; i < 3; ++i) {
            HistoricalPropertyValue item = (HistoricalPropertyValue)values.get(i);
            if (item.getPropertyName().equals("prop1_A")) {
                GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(i)).getPropertyName());
                if (!item.isDeleted()) continue;
                Metadata hpvMetadata = item.getMetadata();
                GeAssert.assertEquals((long)2L, (long)hpvMetadata.entrySet().size());
                GeAssert.assertEquals((Object)"b", (Object)item.getPropertyVisibility().getVisibilityString());
                continue;
            }
            GeAssert.fail((String)("Invalid " + item));
        }
    }

    @Test
    public void historicalPropertyValueModifyPropValue() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1_A", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2_B", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).setProperty("prop3_A", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().setProperty("prop3_A", (Value)Values.stringValue((String)"value4"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().setProperty("prop3_A", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A_AND_B);
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        GeAssert.assertEquals((long)5L, (long)values.size());
        GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(0)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(0)).isDeleted());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value1"), (Object)((HistoricalPropertyValue)values.get(0)).getValue());
        GeAssert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(1)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(1)).isDeleted());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value2"), (Object)((HistoricalPropertyValue)values.get(1)).getValue());
        GeAssert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(2)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(2)).isDeleted());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)((HistoricalPropertyValue)values.get(2)).getValue());
        GeAssert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(3)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(3)).isDeleted());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value4"), (Object)((HistoricalPropertyValue)values.get(3)).getValue());
        GeAssert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(4)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(4)).isDeleted());
        GeAssert.assertEquals((Object)Values.stringValue((String)"value3"), (Object)((HistoricalPropertyValue)values.get(4)).getValue());
    }

    @Test
    public void historicalPropertyValueModifyPropVisibility() {
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").setProperty("prop1_A", (Value)Values.stringValue((String)"value1"), VISIBILITY_A).setProperty("prop2_B", (Value)Values.stringValue((String)"value2"), VISIBILITY_B).setProperty("prop3_A", (Value)Values.stringValue((String)"value3"), VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1_A", VISIBILITY_B).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A_AND_B);
        v1.prepareMutation().alterPropertyVisibility("prop1_A", VISIBILITY_A).save(AUTHORIZATIONS_A_AND_B);
        this.getGraph().flush();
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(AUTHORIZATIONS_A_AND_B));
        Collections.reverse(values);
        GeAssert.assertEquals((long)5L, (long)values.size());
        GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(0)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(0)).isDeleted());
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)((HistoricalPropertyValue)values.get(0)).getPropertyVisibility());
        GeAssert.assertEquals((Object)"prop2_B", (Object)((HistoricalPropertyValue)values.get(1)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(1)).isDeleted());
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)((HistoricalPropertyValue)values.get(1)).getPropertyVisibility());
        GeAssert.assertEquals((Object)"prop3_A", (Object)((HistoricalPropertyValue)values.get(2)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(2)).isDeleted());
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)((HistoricalPropertyValue)values.get(2)).getPropertyVisibility());
        GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(3)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(3)).isDeleted());
        GeAssert.assertEquals((Object)VISIBILITY_B, (Object)((HistoricalPropertyValue)values.get(3)).getPropertyVisibility());
        GeAssert.assertEquals((Object)"prop1_A", (Object)((HistoricalPropertyValue)values.get(4)).getPropertyName());
        GeAssert.assertFalse((boolean)((HistoricalPropertyValue)values.get(4)).isDeleted());
        GeAssert.assertEquals((Object)VISIBILITY_A, (Object)((HistoricalPropertyValue)values.get(4)).getPropertyVisibility());
    }

    @Test
    public void testSaveMultipleTimestampedValuesInSameMutationVertex() {
        String vertexId = "v1";
        String propertyKey = "k1";
        String propertyName = "p1";
        ImmutableMap values = ImmutableMap.of((Object)"value1", (Object)((ZonedDateTime)this.createDate(2016, 4, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value2", (Object)((ZonedDateTime)this.createDate(2016, 5, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value3", (Object)((ZonedDateTime)this.createDate(2016, 6, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value4", (Object)((ZonedDateTime)this.createDate(2016, 7, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value5", (Object)((ZonedDateTime)this.createDate(2016, 8, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli());
        VertexBuilder vertexMutation = this.getGraph().prepareVertex(vertexId, VISIBILITY_EMPTY, "thing");
        for (Map.Entry entry : values.entrySet()) {
            vertexMutation.addPropertyValue(propertyKey, propertyName, (Value)Values.stringValue((String)((String)entry.getKey())), Metadata.create(), (Long)entry.getValue(), VISIBILITY_EMPTY);
        }
        vertexMutation.save(AUTHORIZATIONS_EMPTY);
        this.getGraph().flush();
        Vertex retrievedVertex = this.getGraph().getVertex(vertexId, AUTHORIZATIONS_EMPTY);
        Iterable historicalPropertyValues = retrievedVertex.getHistoricalPropertyValues(propertyKey, propertyName, VISIBILITY_EMPTY, null, null, AUTHORIZATIONS_EMPTY);
        this.compareHistoricalValues((Map<String, Long>)values, historicalPropertyValues);
    }

    @Test
    public void testSaveMultipleTimestampedValuesInSameMutationEdge() {
        Vertex v1 = this.getGraph().addVertex("v1", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        Vertex v2 = this.getGraph().addVertex("v2", VISIBILITY_EMPTY, AUTHORIZATIONS_EMPTY, "thing");
        String edgeId = "e1";
        String propertyKey = "k1";
        String propertyName = "p1";
        ImmutableMap values = ImmutableMap.of((Object)"value1", (Object)((ZonedDateTime)this.createDate(2016, 4, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value2", (Object)((ZonedDateTime)this.createDate(2016, 5, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value3", (Object)((ZonedDateTime)this.createDate(2016, 6, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value4", (Object)((ZonedDateTime)this.createDate(2016, 7, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli(), (Object)"value5", (Object)((ZonedDateTime)this.createDate(2016, 8, 6, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli());
        EdgeBuilder edgeMutation = this.getGraph().prepareEdge(edgeId, v1, v2, "label1", VISIBILITY_EMPTY);
        for (Map.Entry entry : values.entrySet()) {
            edgeMutation.addPropertyValue(propertyKey, propertyName, (Value)Values.stringValue((String)((String)entry.getKey())), Metadata.create(), (Long)entry.getValue(), VISIBILITY_EMPTY);
        }
        edgeMutation.save(AUTHORIZATIONS_EMPTY);
        this.getGraph().flush();
        Edge retrievedEdge = this.getGraph().getEdge(edgeId, AUTHORIZATIONS_EMPTY);
        Iterable historicalPropertyValues = retrievedEdge.getHistoricalPropertyValues(propertyKey, propertyName, VISIBILITY_EMPTY, null, null, AUTHORIZATIONS_EMPTY);
        this.compareHistoricalValues((Map<String, Long>)values, historicalPropertyValues);
    }

    @Test
    public void testTimestampsInExistingElementMutation() {
        Long t1 = ((ZonedDateTime)this.createDate(2017, 1, 18, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli();
        Long t2 = ((ZonedDateTime)this.createDate(2017, 1, 19, 9, 20, 0).asObjectCopy()).toInstant().toEpochMilli();
        this.getGraph().prepareVertex("v1", VISIBILITY_EMPTY, "thing").addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"test1"), Metadata.create(), t1, VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_ALL);
        GeAssert.assertEquals((Object)t1, (Object)v1.getProperty("k1", "prop1").getTimestamp());
        this.getGraph().getVertex("v1", AUTHORIZATIONS_ALL).prepareMutation().addPropertyValue("k1", "prop1", (Value)Values.stringValue((String)"test2"), Metadata.create(), t2, VISIBILITY_EMPTY).save(AUTHORIZATIONS_ALL);
        this.getGraph().flush();
        v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_ALL);
        GeAssert.assertEquals((Object)t2, (Object)v1.getProperty("k1", "prop1").getTimestamp());
        List historicalValues = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues("k1", "prop1", VISIBILITY_EMPTY, AUTHORIZATIONS_ALL));
        GeAssert.assertEquals((long)2L, (long)historicalValues.size());
        GeAssert.assertEquals((long)t1, (long)((HistoricalPropertyValue)historicalValues.get(1)).getTimestamp());
        GeAssert.assertEquals((long)t2, (long)((HistoricalPropertyValue)historicalValues.get(0)).getTimestamp());
    }

    @Test
    public void testPropertyHistoricalVersions() {
        DateTimeValue time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        long time25Millis = ((ZonedDateTime)time25.asObjectCopy()).toInstant().toEpochMilli();
        DateTimeValue time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        long time30Millis = ((ZonedDateTime)time30.asObjectCopy()).toInstant().toEpochMilli();
        Metadata metadata = Metadata.create();
        metadata.add("author", (Value)Values.stringValue((String)"author1"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)25), metadata, Long.valueOf(time25Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        metadata = Metadata.create();
        metadata.add("author", (Value)Values.stringValue((String)"author2"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)30), metadata, Long.valueOf(time30Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", FetchHints.ALL, AUTHORIZATIONS_A);
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues("", "age", VISIBILITY_A, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)2L, (long)values.size());
        GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)((HistoricalPropertyValue)values.get(0)).getValue());
        GeAssert.assertEquals((long)time30Millis, (long)((HistoricalPropertyValue)values.get(0)).getTimestamp());
        GeAssert.assertEquals((Object)Values.stringValue((String)"author2"), (Object)((HistoricalPropertyValue)values.get(0)).getMetadata().getValue("author", VISIBILITY_A));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)((HistoricalPropertyValue)values.get(1)).getValue());
        GeAssert.assertEquals((long)time25Millis, (long)((HistoricalPropertyValue)values.get(1)).getTimestamp());
        GeAssert.assertEquals((Object)Values.stringValue((String)"author1"), (Object)((HistoricalPropertyValue)values.get(1)).getMetadata().getValue("author", VISIBILITY_A));
        GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)v1.getPropertyValue("", "age"));
        GeAssert.assertEquals((Object)Values.stringValue((String)"author2"), (Object)v1.getProperty("", "age").getMetadata().getValue("author", VISIBILITY_A));
    }

    @Test
    public void testStreamingPropertyHistoricalVersions() {
        DateTimeValue time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        long time25Millis = ((ZonedDateTime)time25.asObjectCopy()).toInstant().toEpochMilli();
        DateTimeValue time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        long time30Millis = ((ZonedDateTime)time30.asObjectCopy()).toInstant().toEpochMilli();
        Metadata metadata = Metadata.create();
        StreamingPropertyValue value1 = StreamingPropertyValue.create((String)"value1");
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("", "text", (Value)value1, metadata, Long.valueOf(time25Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        StreamingPropertyValue value2 = StreamingPropertyValue.create((String)"value2");
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("", "text", (Value)value2, metadata, Long.valueOf(time30Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues("", "text", VISIBILITY_A, AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)2L, (long)values.size());
        GeAssert.assertEquals((Object)"value2", (Object)((StreamingPropertyValue)((HistoricalPropertyValue)values.get(0)).getValue()).readToString());
        GeAssert.assertEquals((long)time30Millis, (long)((HistoricalPropertyValue)values.get(0)).getTimestamp());
        GeAssert.assertEquals((Object)"value1", (Object)((StreamingPropertyValue)((HistoricalPropertyValue)values.get(1)).getValue()).readToString());
        GeAssert.assertEquals((long)time25Millis, (long)((HistoricalPropertyValue)values.get(1)).getTimestamp());
        GeAssert.assertEquals((Object)"value2", (Object)((StreamingPropertyValue)v1.getPropertyValue("", "text")).readToString());
    }

    @Test
    public void testGetVertexAtASpecificTimeInHistory() {
        DateTimeValue time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        long time25Millis = ((ZonedDateTime)time25.asObjectCopy()).toInstant().toEpochMilli();
        DateTimeValue time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        long time30Millis = ((ZonedDateTime)time30.asObjectCopy()).toInstant().toEpochMilli();
        Metadata metadata = Metadata.create();
        Vertex v1 = (Vertex)this.getGraph().prepareVertex("v1", Long.valueOf(time25Millis), VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)25), metadata, Long.valueOf(time25Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        Vertex v2 = (Vertex)this.getGraph().prepareVertex("v2", Long.valueOf(time25Millis), VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)20), metadata, Long.valueOf(time25Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareEdge("e1", v1, v2, "label1", Long.valueOf(time30Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v1", Long.valueOf(time30Millis), VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)30), metadata, Long.valueOf(time30Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().prepareVertex("v3", Long.valueOf(time30Millis), VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)35), metadata, Long.valueOf(time30Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)this.getGraph().getVertex("v1", AUTHORIZATIONS_A).getPropertyValue("", "age"));
        GeAssert.assertEquals((Object)Values.intValue((int)20), (Object)this.getGraph().getVertex("v2", AUTHORIZATIONS_A).getPropertyValue("", "age"));
        GeAssert.assertEquals((Object)Values.intValue((int)35), (Object)this.getGraph().getVertex("v3", AUTHORIZATIONS_A).getPropertyValue("", "age"));
        GeAssert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(AUTHORIZATIONS_A)));
        GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)this.getGraph().getVertex("v1", this.getGraph().getDefaultFetchHints(), Long.valueOf(time25Millis), AUTHORIZATIONS_A).getPropertyValue("", "age"));
        GeAssert.assertNull((String)"v3 should not exist at time25", (Object)this.getGraph().getVertex("v3", this.getGraph().getDefaultFetchHints(), Long.valueOf(time25Millis), AUTHORIZATIONS_A));
        GeAssert.assertEquals((String)"e1 should not exist", (long)0L, (long)IterableUtils.count((Iterable)this.getGraph().getEdges(this.getGraph().getDefaultFetchHints(), Long.valueOf(time25Millis), AUTHORIZATIONS_A)));
    }

    @Test
    public void testAllPropertyHistoricalVersions() {
        HistoricalPropertyValue item;
        int i;
        DateTimeValue time25 = this.createDate(2015, 4, 6, 16, 15, 0);
        long time25Millis = ((ZonedDateTime)time25.asObjectCopy()).toInstant().toEpochMilli();
        DateTimeValue time30 = this.createDate(2015, 4, 6, 16, 16, 0);
        long time30Millis = ((ZonedDateTime)time30.asObjectCopy()).toInstant().toEpochMilli();
        Metadata metadata = Metadata.create();
        metadata.add("author", (Value)Values.stringValue((String)"author1"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)25), metadata, Long.valueOf(time25Millis), VISIBILITY_A).addPropertyValue("k1", "name", (Value)Values.stringValue((String)"k1Time25Value"), metadata, Long.valueOf(time25Millis), VISIBILITY_A).addPropertyValue("k2", "name", (Value)Values.stringValue((String)"k2Time25Value"), metadata, Long.valueOf(time25Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        metadata = Metadata.create();
        metadata.add("author", (Value)Values.stringValue((String)"author2"), VISIBILITY_A);
        this.getGraph().prepareVertex("v1", VISIBILITY_A, "thing").addPropertyValue("", "age", (Value)Values.intValue((int)30), metadata, Long.valueOf(time30Millis), VISIBILITY_A).addPropertyValue("k1", "name", (Value)Values.stringValue((String)"k1Time30Value"), metadata, Long.valueOf(time30Millis), VISIBILITY_A).addPropertyValue("k2", "name", (Value)Values.stringValue((String)"k2Time30Value"), metadata, Long.valueOf(time30Millis), VISIBILITY_A).save(AUTHORIZATIONS_A);
        this.getGraph().flush();
        Vertex v1 = this.getGraph().getVertex("v1", AUTHORIZATIONS_A);
        List values = IterableUtils.toList((Iterable)v1.getHistoricalPropertyValues(AUTHORIZATIONS_A));
        GeAssert.assertEquals((long)6L, (long)values.size());
        for (i = 0; i < 3; ++i) {
            item = (HistoricalPropertyValue)values.get(i);
            GeAssert.assertEquals((long)time30Millis, (long)((HistoricalPropertyValue)values.get(i)).getTimestamp());
            if (item.getPropertyName().equals("age")) {
                GeAssert.assertEquals((Object)Values.intValue((int)30), (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k1")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"k1Time30Value"), (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k2")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"k2Time30Value"), (Object)item.getValue());
                continue;
            }
            GeAssert.fail((String)("Invalid " + item));
        }
        for (i = 3; i < 6; ++i) {
            item = (HistoricalPropertyValue)values.get(i);
            GeAssert.assertEquals((long)time25Millis, (long)((HistoricalPropertyValue)values.get(i)).getTimestamp());
            if (item.getPropertyName().equals("age")) {
                GeAssert.assertEquals((Object)Values.intValue((int)25), (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k1")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"k1Time25Value"), (Object)item.getValue());
                continue;
            }
            if (item.getPropertyName().equals("name") && item.getPropertyKey().equals("k2")) {
                GeAssert.assertEquals((Object)Values.stringValue((String)"k2Time25Value"), (Object)item.getValue());
                continue;
            }
            GeAssert.fail((String)("Invalid " + item));
        }
    }

    private void compareHistoricalValues(Map<String, Long> expectedValues, Iterable<HistoricalPropertyValue> historicalPropertyValues) {
        HashMap<String, Long> expectedValuesCopy = new HashMap<String, Long>(expectedValues);
        for (HistoricalPropertyValue historicalPropertyValue : historicalPropertyValues) {
            TextValue value = (TextValue)historicalPropertyValue.getValue();
            if (!expectedValuesCopy.containsKey(value.stringValue())) {
                throw new GeException("Expected historical values to contain: " + value.stringValue());
            }
            long expectedValue = (Long)expectedValuesCopy.remove(value.stringValue());
            long ts = historicalPropertyValue.getTimestamp();
            GeAssert.assertEquals((long)expectedValue, (long)ts);
        }
        if (expectedValuesCopy.size() > 0) {
            StringBuilder result = new StringBuilder();
            for (Map.Entry entry : expectedValuesCopy.entrySet()) {
                result.append((String)entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
            }
            throw new GeException("Missing historical values:\n" + result.toString());
        }
    }
}

